<?php $__env->startSection('content'); ?>
    <style>
        table.dataTable.no-footer {
            border-bottom: none !important;
        }


        .color-bordered-table.red-bordered-table {
            border: none !important;
        }

        .newButton {
            background-color: #00c292 !important;
        }
    </style>
    <link href="/assets/node_modules/switchery/dist/switchery.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="//cdn.datatables.net/1.13.2/css/jquery.dataTables.min.css">
    <div class="row page-titles">
        <div class="col-md-12">
            <h4 class="text-white">YSİİD</h4>
        </div>
        <div class="col-md-6">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Anasayfa</a></li>
                <li class="breadcrumb-item active">Ödeme Listesi</li>
            </ol>
        </div>
        <div class="col-md-6 text-right">
            <form class="app-search d-none d-md-block d-lg-block">
                <input type="text" class="form-control" placeholder="Search &amp; enter">
            </form>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <?php if(session('status')): ?>
                        <script>
                            $(document).ready(function() {
                                Swal.fire({
                                    position: 'center-center',
                                    type: 'success',
                                    title: '<?php echo e(session("status")); ?>',
                                    showConfirmButton: false,
                                    timer: 3000
                                })
                            });
                        </script>
                    <?php endif; ?>


                    <div class="table-responsive">
                        <table id="myTable" class="table color-bordered-table red-bordered-table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Kurum adı</th>
                                    <th>Yetkili Adı</th>
                                    <th>Yetkili Soyadı</th>
                                    <th>Ücret</th>
                                    <th>Dönem</th>
                                    <th>Yükleme Zamanı</th>
                                    <th>Dekont</th>
                                    <th>İşlem</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <script src="//cdn.datatables.net/1.13.2/js/jquery.dataTables.min.js"></script>
    <script src="/assets/node_modules/switchery/dist/switchery.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.html5.min.js"></script>
    <script>
        $(function() {
            table = $('#myTable').DataTable({
                "responsive": true,
                "dom": '<"html5buttons"B>lTfgitp',
                "language": {
                    "url": "https://cdn.datatables.net/plug-ins/1.13.2/i18n/tr.json"
                },
                buttons: ['copy', 'csv', 'excel', 'pdf'],
                processing: true,
                serverSide: true,
                ajax: "<?php echo e(route('odemeler.ajaxList')); ?>",
                 "order": [[0, "desc"]],

                "drawCallback": function(settings) {
                    $('.js-switch').each(function() {
                        new Switchery($(this)[0], $(this).data());
                    });
                },

                "columnDefs": [{
                        "render": createManageBtn,
                        "data": 5,
                        "id": 1,
                        "targets": [5]
                    }
                    , {
                        "render": createStatusSwitcher,
                        "data": 7,
                        "id": 1,
                        "targets": [7]
                    },
                    {
                        "render": createSeoLink,
                        "data": 8,
                        "id": 1,
                        "targets": [8]
                    }
                 ],
                columns: [{
                        data: 'id'
                    },
                    {
                        data: 'corporate_name'
                    },
                    {
                        data: 'name'
                    },
                    {
                        data: 'surname'
                    },
                    {
                        data: 'amount'
                    },

                    {
                        data: 'start_date'
                    }
                    ,

                    {
                        data: 'dateTime'
                    },

                    {
                        data: 'file_path'
                    }
                    ,

                    {
                        data: 'islem'
                    }
                ],

            });


        });

        

        function changePay(e){

            var id = $(e).attr("data-id");
            var value = $(e).find('option:selected').val();

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('odemeler.changePay')); ?>",
                data: {
                    id: id,
                    value: value,
                    _token: "<?php echo e(csrf_token()); ?>"
                },
                success: function(data) {
                    console.log(data.status);
                    if (data.status) {
                        Swal.fire({
                            position: 'center-center',
                            type: 'success',
                            title: data.message,
                            showConfirmButton: false,
                            timer: 3000
                        }).then(() => {
                            window.location.reload();
                        })
                    } else {
                        Swal.fire({
                            position: 'center-center',
                            type: 'error',
                            title: data.message,
                            showConfirmButton: false,
                            timer: 3000
                        }).then(() => {
                             window.location.reload();
                        })
                    }
                }
            });
        }

        function createSeoLink(x, y, data) {

            console.log(data.islem);
            if(data.islem == "0"){
                color = "red";
            }else if(data.islem == "1"){
                color = "green";
            }else if(data.islem == "2"){
                color = "#013acc";
            }


            let html = `
            <select onchange="changePay(this)" data-id="${data.id}" style='color:${color};'>
                <option ${data.islem == "0" ? ' selected ' : ''} value="0">Ödenmedi</option>
                <option ${data.islem == "1" ? ' selected ' : ''} value="1">Ödendi</option>
                <option ${data.islem == "2" ? ' selected ' : ''} value="2">İnceleniyor</option>
            </select>
            `;

            return html;
        }

        function createManageBtn(data) {
        const date = new Date(data);
        const year = date.getFullYear();
        const month = ('0' + (date.getMonth() + 1)).slice(-2);
        const formattedDate = year + '-' + month;




            let html = `
        
               ${formattedDate}
             `;
            return html;
        }

        function createStatusSwitcher(x, y, data) {
            // console.log(data);

            html = `${JSON.stringify(data.file_path)}`;

            if(data.file_path){
                 html = `
                <a download href="/${data.file_path}" class="btn btn-info btn-sm">İndir</a>
            `;
            }else{
            html = `Yüklenmedi`;
            }
           

            return html;
        
        
        
        }
        function statusChanger(e) {
            var id = $(e).attr('data-id');
            $.ajax({
                type: "POST",
                url: "/",
                data: {
                    id
                },
                success: function(response) {
                    console.log(response);
                }
            });
        }
        $(document).ready(function() {
            var elems = Array.prototype.slice.call(document.querySelectorAll('.js-switch'));
            $('.js-switch').each(function() {
                new Switchery($(this)[0], $(this).data());
            });
        });

        function del(e) {
            var id = e;
            if (confirm("Silmek istiyor musunuz?") === true) {


                $.ajax({
                    type: "POST",
                    url: "/",
                    data: {
                        id
                    },
                    success: function(response) {
                        let res = JSON.parse(response);
                        if (res.status) {

                            Swal.fire({
                                position: 'center-center',

                                timer: 3000,
                                type: 'success',
                                title: 'Silme işlemi başarılı',
                                showConfirmButton: false,
                            }).then(function() {
                                window.location.reload();
                            })

                        } else {
                            Swal.fire({
                                position: 'center-center',
                                type: 'error',
                                title: 'Silme işlemi başarısız.',
                                showConfirmButton: false,
                                timer: 3000,
                                function() {
                                    location.reload();
                                }
                            });
                        }
                    }
                });


            } else {


                Swal.fire({
                    position: 'center-center',

                    timer: 3000,

                    title: 'İşlem iptal edildi!',
                    showConfirmButton: false,
                })
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ysiidcomtr/public_html/resources/views/admin/pages/member/odemeler.blade.php ENDPATH**/ ?>