<?php $__env->startSection('content'); ?>
    <script src="https://unpkg.com/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>

    <style>
        .rounded-lg {
            border-radius: 1rem;
        }

        .nav-pills .nav-link {
            color: #555;
        }

        .nav-pills .nav-link.active {
            color: #fff;
        }
    </style>

    <div class="container my-5">
        <div class="row">
            <div class="col-lg-7 mx-auto">
                <div class="bg-white rounded-lg shadow p-5">
                    <ul class="nav bg-light nav-pills rounded-pill mb-3" role="tablist">

                        <li class="nav-item" role="presentation">
                            <button class="nav-link rounded-pill" id="nav-tab-bank" data-bs-toggle="pill"
                                data-bs-target="#nav-bank">
                                <i class="fa fa-university"></i> EFT/HAVALE
                            </button>
                        </li>
                    </ul>

                    <div class="tab-content">




                        <div class="tab-pane fade show active" id="nav-bank" role="tabpanel">
                            <h6>Banka Detayları</h6>
                            <div class="alert alert-danger text-center" role="alert">
                                Açıklama alanına şahıslar için <strong> ad soyad </strong> tüzel kişiler için
                               <br> <strong>firma ismi</strong> girmelisiniz.
                            </div>

                            <div class="alert alert-info text-center" role="alert">
                                <strong>Kayıt ücreti olarak aşağıda belirtilen banka hesaplarına <?php echo e($settings->register_pay_amount); ?> TL göndermeniz
                                    gerekmektedir.</strong>
                            </div>

                         
                            <?php $__currentLoopData = json_decode($settings->IBAN); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <div class="row">
                                <dl class="col-6">
                                    <dt>Banka</dt>
                                    <dd><strong style="color: red;"><?php echo e($value->banka); ?></strong></dd>
                                </dl>
                                <dl class="col-6">
                                    <dt>HESAP NUMARASI</dt>
                                    <dd><strong style="color: red;"><?php echo e($value->hesapNumarasi); ?></strong></dd>
                                </dl>
                            </div>
                            <div class="col-12">
                                <dl>
                                    <dt>IBAN</dt>
                                    <dd><strong style="color: red;"><?php echo e($value->iban); ?></strong></dd>
                                </dl>
                            </div>
                            <hr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                               

                          
                          
                            

                            <div class="row">
                                <div class="col-12">
                                    <label for="formFile" class="form-label"><strong>Dekont görselini buradan yükleyiniz</strong></label>
                                  
                                </div>
                                <div class="col-12 ">
                                    <input class="form-control" type="file" id="formFile">
                                      <small>Bu dosya yükleme alanı jpg, jpeg, png, bmp, pdf dosyalarını desteklemektedir </small>
                                </div>
                                <div class="col-12 d-flex mt-3 flex-column align-items-end justify-content-end">

                                    <button onclick="sendReceipt()" class="btn btn-primary ">Yükle</button>

                                </div>

                            </div>






                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(function() {
            $('[data-toggle="tooltip"]').tooltip()
        })


        function sendReceipt(){
            var file = document.getElementById('formFile').files[0];
            var formData = new FormData();
            formData.append('file', file);
            formData.append('type', 'register');
            formData.append('_token', '<?php echo e(csrf_token()); ?>');

            $.ajax({
                url: '<?php echo e(route('eysiid.receipt')); ?>',
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    if (data.status == 'success') {
                        Swal.fire({
                            title: 'Başarılı',
                            text: "Dekontunuz başarıyla yüklendi. Kayıt işleminiz onaylandıktan sonra bilgilendirileceksiniz.",
                            icon: 'success',
                            confirmButtonText: 'Tamam'
                        });
                    } else {
                        Swal.fire({
                            title: 'Hata',
                            text: 'Dosyanız yüklemeye uygun değil. Lütfen dosyanızı kontrol ediniz.',
                            icon: 'error',
                            confirmButtonText: 'Tamam'
                        });
                    }
                },
                error: function(data) {
                    Swal.fire({
                        title: 'Hata',
                        text: 'Bir hata oluştu. Lütfen daha sonra tekrar deneyiniz.',
                        icon: 'error',
                        confirmButtonText: 'Tamam'
                    })
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ysiidcomtr/public_html/resources/views/pages/eysiid/registerPay.blade.php ENDPATH**/ ?>