<?php $__env->startSection('content'); ?>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <style>

    </style>

    <div class="container my-5">
        <div class="row mb-5" style="min-height: 500px">
            <div class="col">
                <h2>Üye Ol</h2>



                <div class="alert alert-warning my-4" role="alert">
                <a target="_blank" style="color:#664d03;" href="/page/uye-olma-rehberi">Üye olma rehberimizi <span style="color:#084298">buraya</span> tıklayarak görebilirsiniz.</a>
                </div>



                <?php if(@$_GET['error'] == '1'): ?>
                    <div class="alert alert-danger">
                        <strong>Girmiş olduğunuz e-posta adresiniz daha önce kullanılmış.<br> <a style="color:blue;"
                                href="/e-ysiid/forget-password">Şifrenizi mi unuttunuz?</a></strong>
                    </div>
                <?php endif; ?>





                <form action="<?php echo e(route('authRegister')); ?>" id="registerMember" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-6">
                            <div class="mb-3">

                                <label for="email" class="form-label">E-Posta Adresi</label>
                                <input type="email" class="form-control" id="email" name="email" required>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="mb-3">
                                <label for="password" class="form-label">Şifre</label>
                                <input type="password" minlength="6" maxlength="10" class="form-control" id="password" name="password" pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{6,10}" required oninvalid="this.setCustomValidity('Parolanız en az 1 rakam, 1 küçük harf, 1 büyük harf içermelidir. En az 6, en fazla 10 karakter olmalıdır.')" oninput="this.setCustomValidity('')" >

                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-6">
                            <div class="mb-3">
                                <label for="name" class="form-label">Yetkili Adı</label>
                                <input type="text" class="form-control" id="name" name="name" required>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="mb-3">
                                <label for="surname" class="form-label">Yetkili Soyadı</label>
                                <input type="text" class="form-control" id="surname" name="surname" required>
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-6">
                            <div class="mb-3">
                                <label for="phone" class="form-label">Yetkili Telefon</label>
                                <input type="tel" class="form-control" id="phone" name="phone" required>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="mb-3">
                                <label for="isLegal" class="form-label">Üyelik Tipi</label>
                                <select class="form-select" id="isLegal" name="isLegal" required>
                                    <option value="tuzel">Tüzel Kişi</option>
                                    <option value="sahis">Gerçek Kişi</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-6">
                            <div class="mb-3">
                                <label for="corporate_name" class="form-label">Şirket Adı</label>
                                <input type="text" class="form-control" id="corporate_name" name="corporate_name"
                                    required>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="mb-3">
                                <label for="corporate_role" class="form-label">Göreviniz</label>
                                <input type="text" class="form-control" id="corporate_role" name="corporate_role"
                                    required>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12 my-3">
                            Kayıt olmanız durumunda <a style="display: inline" target="_blank" href="/docs/aydinlatmametni.html">aydınlatma metnini </a> ve <a target="_blank" href="/docs/acik-riza-beyani.html">açık rıza beyan metnini</a>
                            okumuş ve kabul etmiş sayılırsınız. <br> Bir sonraki adımda dernek tüzüğü ve sözleşme
                            metinlerini onaylamanız gerekmektedir.
                        </div>
                    </div>

                    <div class="g-recaptcha" data-sitekey="<?php echo e(env('GOOGLE_reCAPTCHA_SITE_KEY')); ?>"></div>

                    <div class="col-12 my-4">
                        <button type="submit" class="btn btn-primary mt-3" style="width: 200px;height:45px;">Kayıt
                            ol!</button>
                    </div>
                </form>

            </div>
        </div>
    </div>

    <script>
        document.getElementById('registerMember').addEventListener('submit', function(event) {
            var response = grecaptcha.getResponse();
            if (response.length === 0) {
                event.preventDefault();
                Swal.fire({
                    icon: 'error',
                    title: 'Robot Doğrulaması',
                    text: 'Lütfen reCAPTCHA doğrulamasını tamamlayın.'
                })
            }
        });

      
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ysiidcomtr/public_html/resources/views/pages/eysiid/memberRegister.blade.php ENDPATH**/ ?>