<?php $__env->startSection('content'); ?>
<link href="/assets/node_modules/switchery/dist/switchery.min.css" rel="stylesheet" />
<div class="row page-titles">
    <div class="col-md-12">
        <h4 class="text-white">YSİİD</h4>
    </div>
    <div class="col-md-6">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Anasayfa</a></li>
          
            <li class="breadcrumb-item active">Şema Listesi</li>
        </ol>
    </div>
    <div class="col-md-6 text-right">
        <form class="app-search d-none d-md-block d-lg-block">
            <input type="text" class="form-control" placeholder="Search &amp; enter">
        </form>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <?php if(session('status')): ?>
                <script>
                    $(document).ready(function() {
                        Swal.fire({
                            position: 'center-center',
                            type: 'success',
                            title: '<?php echo e(session("status")); ?>',
                            showConfirmButton: false,
                            timer: 3000
                        })
                    });
                </script>

                <?php endif; ?>


                <div class="table-responsive">
                    <table class="table color-bordered-table red-bordered-table">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Şema Adı</th>
                                <th>Seo Adresi</th>
                                <th>Son Düzenlenme Tarihi</th>
                                <th>Aktif/Pasif</th>
                                <th>İşlem</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><strong><?php echo e($page->page_id); ?></strong></td>
                                <td><strong><?php echo e($page->page_title); ?></strong></td>
                                <td><a target="_blank" href="<?php echo e(url('/')); ?>/sema/<?php echo e($page->page_title_seo); ?>">/sema/<?php echo e($page->page_title_seo); ?></a></td>
                                <td><?php echo e($page->updated_at); ?></td>
                                <td>
                                    <input onchange="statusChanger(this)" data-id="<?php echo e($page->page_id); ?>" type="checkbox" <?php echo e(($page->page_status == "on") ? ' checked="true" ' : ''); ?> class="js-switch" data-size="small" data-color="#009efb" style="display: none;" data-switchery="true">

                                </td>
                                <td>
                                    <a href="<?php echo e(route('sema.Edit',['id' => $page->page_id])); ?>" class="btn btn-info" data-id="<?php echo e($page->page_id); ?>">Düzenle</a>
                                    <button class="btn btn-danger" onclick="del(this)" data-id="<?php echo e($page->page_id); ?>">Sil</button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>
</div>

<script src="/assets/node_modules/switchery/dist/switchery.min.js"></script>
<script>
    function statusChanger(e) {
        var id = $(e).attr('data-id');
        $.ajax({
            type: "POST",
            url: "<?php echo e(Route('sema.statusChanger')); ?>",
            data: {
                id
            },
            success: function(response) {
                console.log(response);
            }
        });
    }

    $(document).ready(function() {
        var elems = Array.prototype.slice.call(document.querySelectorAll('.js-switch'));
        $('.js-switch').each(function() {
            new Switchery($(this)[0], $(this).data());
        });
    });

    function del(e) {
        var id = $(e).attr('data-id');
        if (confirm("Silmek istiyor musunuz?") === true) {


            $.ajax({
                type: "POST",
                url: "<?php echo e(Route('sema.delete')); ?>",
                data: {
                    id
                },
                success: function(response) {
                    let res = JSON.parse(response);
                    if (res.status) {

                        Swal.fire({
                            position: 'center-center',

                            timer: 3000,
                            type: 'success',
                            title: 'Silme işlemi başarılı',
                            showConfirmButton: false,
                        }).then(function() {
                            window.location.reload();
                        })

                    } else {
                        Swal.fire({
                            position: 'center-center',
                            type: 'error',
                            title: 'Silme işlemi başarısız.',
                            showConfirmButton: false,
                            timer: 3000,
                            function() {
                                location.reload();
                            }
                        });
                    }
                }
            });


        } else {


            Swal.fire({
                position: 'center-center',

                timer: 3000,

                title: 'İşlem iptal edildi!',
                showConfirmButton: false,
            })


        }





    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ysiidcomtr/public_html/resources/views/admin/pages/semaList.blade.php ENDPATH**/ ?>