 <?php $__env->startSection('content'); ?><?php
$menuHtml = "";

function buildMenu($menu_items, $parent_id = 0)
{
    $menu = '';
    foreach ($menu_items as $item) {
        if ($item->menuParent == $parent_id) {
            $menu .= "<li class='dd-item dd3-item' data-id='{$item->id}'>";
            $menu .= "<div class='dd-handle dd3-handle'></div>";
            $menu .= "<div class='dd3-content' style='cursor:pointer'  onclick='edit(this)' data-id='$item->id' data-name='$item->menuTitle'>{$item->menuTitle}</div>";
            $menu .= buildMenu($menu_items, $item->id);
            $menu .= "</li>";
        }
    }
    if ($menu != '') {
        $menu = "<ol class='dd-list'>{$menu}</ol>";
    }
    return $menu;
}


?>


<div class="row page-titles">
    <div class="col-md-12">
        <h4 class="text-white">YSİİD</h4>
    </div>
    <div class="col-md-6">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Anasayfa</a></li>
            <li class="breadcrumb-item "><a href="javascript:void(0)">Sayfalar</a></li>
            <li class="breadcrumb-item active">Sayfa Kategorileri</li>
        </ol>
    </div>
    <div class="col-md-6 text-right">
        <form class="app-search d-none d-md-block d-lg-block">
            <input type="text" class="form-control" placeholder="Search &amp; enter">
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header d-flex justify-content-between">
        <h4 class="card-title mt-2">Sayfa Kategorileri</h4>
        <button class="btn btn-danger" onclick="newCategory()">Yeni Ekle</button>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-12">

                <div class="table-responsive">
                    <table class="table muted-table color-bordered-table" style="width:100%">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Kategori Adı</th>
                                <th>Kategori Adı İngilizce</th>
                                <th class="text-center">İşlem</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                            <tr>
                                <td><?php echo e($item->id); ?></td>
                                <td><?php echo e($item->kategori_adi); ?></td>
                                <td><?php echo e($item->kategori_adi_en); ?></td>

                                <td class="text-center">
                                    <button onclick="edit(this)" data-id="<?php echo e($item->id); ?>" data-tr="<?php echo e($item->kategori_adi); ?>" data-en="<?php echo e($item->kategori_adi_en); ?>"   class="btn btn-primary">Düzenle</button>
                                    <button onclick="del(this)" data-id="<?php echo e($item->id); ?>" class="btn btn-danger">Sil</button>
                                </td>
                            </tr>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>
</div>
<div id="tooltipmodals" class="modal" tabindex="-1" role="dialog" aria-labelledby="tooltipmodel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="tooltipmodel">Yeni Kategori Ekle</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-hidden="true"></button>
            </div>
            <div id="modal_content" class="modal-body">
                <div class="form-group">
                    <label for="category_tr" class="form-label">Kategori Adı</label>
                    <input type="text" class="form-control" id="category_tr" aria-describedby="emailHelp" placeholder="*Örneğin: Kurumsal">
                    <small id="emailHelp" class="form-text text-muted">Sayfa Kategori Adı</small>
                </div>
                <div class="form-group">
                    <label for="category_en" class="form-label">Kategori Adı İngilizce</label>
                    <input type="text" class="form-control" id="category_en" aria-describedby="emailHelp" placeholder="*Örneğin: Kurumsal">
                    <small id="emailHelp" class="form-text text-muted">Sayfa Kategori Adı İngilizce Giriniz</small>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-success" onclick="saveCategory(this)" data-dismiss="modal">Kayıt</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Kapat</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>

<div id="edit" class="modal" tabindex="-1" role="dialog" aria-labelledby="tooltipmodel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="tooltipmodel">Kategori Düzenle</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-hidden="true"></button>
            </div>
            <div id="modal_content" class="modal-body">
                <div class="form-group">
                    <label for="category_tr" class="form-label">Kategori Adı</label>
                    <input type="text" class="form-control" id="category_tr_edit" aria-describedby="emailHelp" placeholder="*Örneğin: Kurumsal">
                    <small id="emailHelp" class="form-text text-muted">Sayfa Kategori Adı</small>
                </div>
                <div class="form-group">
                    <label for="category_en" class="form-label">Kategori Adı İngilizce</label>
                    <input type="text" class="form-control" id="category_en_edit" aria-describedby="emailHelp" placeholder="*Örneğin: Kurumsal">
                    <small id="emailHelp" class="form-text text-muted">Sayfa Kategori Adı İngilizce Giriniz</small>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" id="editButton" class="btn btn-success" onclick="editCategory(this)" data-dismiss="modal">Kayıt</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Kapat</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>

<script>
    function del(e){
        if(confirm('Silmek istediğinize emin misiniz?')){
            $.ajax({
                type: "DELETE",
                url: "/admin/pages/category",
                data: {"id" : $(e).attr('data-id')},
                success: function (response) {
                    statusCatcher(response);
                }   
            });
        }else{
            alert("Vazgeçtiniz, işleminiz tamamlanmadı!");
        }
    }

    function editCategory(e){
        let category_name_tr = $("#category_tr_edit").val();
        let category_name_en = $("#category_en_edit").val();
        let id = $(e).attr("data-id");

        let data = {
            category_name_tr,
            category_name_en,
            id
        };

        $.ajax({
            type: "put",
            url: "/admin/pages/category",
            data: data,
            
            success: function (response) {
                statusCatcher(response);
            }
        });

    }

    function edit(e){
        var edit = $("#edit").modal('show');
        $("#category_tr_edit").val($(e).attr('data-tr'));
        $("#category_en_edit").val($(e).attr('data-en'));
        $("#editButton").attr("data-id",$(e).attr('data-id'));

    }

    function saveCategory(e){
        let category_name_tr = $("#category_tr").val();
        let category_name_en = $("#category_en").val();
        let  data = {
                 "_token": "<?php echo e(csrf_token()); ?>",
                 category_name_tr,
                 category_name_en

        }
        $.ajax({
            type: "POST",
            url: "/admin/pages/category",
            data: data,
            
            success: function (response) {
                // location.reload();
                statusCatcher(response);
            }   
        });
    }

    function newCategory() {
        $("#tooltipmodals").modal('show');
    }
    function statusCatcher(response){
        response = JSON.parse(response);
        if(response.status == true){
            location.reload();
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ysiidcomtr/public_html/resources/views/admin/pages/page_categories.blade.php ENDPATH**/ ?>