<?php $__env->startSection('content'); ?>
    <link rel="stylesheet" href="//cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
    <script src="//cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
    <style>
        .btn-group-xs>.btn,
        .btn-xs {
            padding: .25rem .4rem;
            font-size: .875rem;
            line-height: .5;
            border-radius: .2rem;
        }
    </style>
    <div class="container my-5">
        <div class="row">
            <div class="col-md-3 col-12 p-0 shadow border text-center" style="min-height:400px; background-color: #f5f5f5;">
                <a hre="/e-ysiid/portal">
                    <h6 class="strong d-flex justify-content-center align-items-center mb-0"
                        style="display:block;background-color:#474747;color:#fff;height:71px;box-shadow: 0 7px 7px -8px;">Üye
                        Paneli</h6>
                </a>
                <ul class="list-group list-group-flush text-start">

                    <li class="list-group-item"><a class="btn-link" href="/e-ysiid/uye-bilgilerim">Üye Bilgilerim</a></li>
                    <li class="list-group-item"><a class="btn-link" href="/e-ysiid/yuklenen-dosyalar">Yüklenen Dosyalar</a>
                    </li>
                    <li class="list-group-item"><a class="btn-link" href="/e-ysiid/odemeler">Ödemeler</a></li>
                    <li class="list-group-item"><a class="btn-link" href="/e-ysiid/sifre-degistir">Şifre Değiştir</a></li>
                    <li class="list-group-item"><a class="btn-link" href="/e-ysiid/logout">Oturumu Kapat</a></li>
                   
                </ul>
            </div>
            <div class="col-md-9 col-12 px-4" style="min-height:400px">
                <div class="w-100    h-100">
                    <div class="border-bottom text-right d-flex justify-content-between">
                        <div style="font-weight:600;color:#000">
                            <?php echo e($uye->isLegal == 'tuzel' ? $uye->corporate_name : $uye->name . ' ' . $uye->surname); ?>

                        </div>

                        <div>#<?php echo e($uye->id); ?></div>



                    </div>
                    <div class="col-12 mt-2">


                        <table id="myTable" class="display">
                            <thead>
                                <tr>
                                    <th width="5%">SIRA NO</th>
                                    <th>DÖNEM</th>
                                    <th>ÜCRET</th>
                                    <th>DURUM</th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php $__currentLoopData = $odemeler; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td width="5%"><?php echo e($payment->id); ?></td>
                                        <td><?php echo e(date('Y-m', strtotime($payment->start_date))); ?></td>
                                        <td><?php echo e($payment->amount); ?> TL</td>
                                        <td>
                                            <?php if($payment->pay == 1): ?>
                                                <span class=" text-success"><strong>Ödendi</strong></span>
                                            <?php elseif($payment->pay == 0): ?>
                                                <span class=" text-danger"><strong>Ödenmedi</strong></span><br>
                                                <button onclick="uploadReceipt(this)" data-id="<?php echo e($payment->id); ?>"
                                                    class="btn btn-primary btn-xs py-2">Dekont Yükle</button>
                                            <?php elseif($payment->pay == 2): ?>
                                                <span class="" style="color:#aa7107"><strong>Dekont
                                                        İşlemde</strong></span><br>
                                            <?php endif; ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>



                    </div>
                </div>
            </div>
        </div>
    </div>




    <script>
        let oTable = $('#myTable').dataTable({
            "responsive": true,
            "dom": '<"html5buttons"B>lTfgitp',
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.13.4/i18n/tr.json"
            }
        });

        oTable.fnSort([
            [0, 'desc']
        ]);

        function uploadReceipt(e) {
            // Dosya yükleme penceresini aç
            var input = document.createElement('input');
            input.type = 'file';
            input.accept = 'image/*';
            input.addEventListener('change', function() {
                // Dosya yükleme işlemini gerçekleştir
                var formData = new FormData();
                formData.append('file', input.files[0]);
                formData.append('id', e.getAttribute('data-id'));
                formData.append('_token', '<?php echo e(csrf_token()); ?>');

                // Ajax işlemi başlat
                var xhr = new XMLHttpRequest();
                xhr.open('POST', '<?php echo e(route('dekontyukle')); ?>');
                xhr.onload = function() {
                    if (xhr.status === 200) {
                        // Yükleme başarılıysa burada yapılacak işlemler
                        console.log('Dosya yüklendi.');
                        alert('Dosya yüklendi. Dekont işleme alındı.')
                        location.reload();
                    } else {
                        // Hata durumunda burada yapılacak işlemler
                        console.log('Dosya yüklenirken bir hata oluştu.');
                    }
                };
                xhr.send(formData);
            });
            input.click();
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ysiidorg/public_html/resources/views/pages/eysiid/payments.blade.php ENDPATH**/ ?>