<?php

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;


Route::get('/cron-pay', 'HomeController@cronpay')->name('cronpay');

Route::get('/lang_{lang}', 'HomeController@languageSwitcher');      
Route::get('/', 'HomeController@index')->name('Home');
Route::get('/page/{slug}', 'pagesController@getPage')->name('getPage');


Route::get('/haberler', 'newsController@haberler')->name('haberler');
Route::get('/haber/{slug}', 'newsController@singleNews')->name('haber');
Route::post('/contact-form-submit', 'formsController@contactForm')->name('contactForms');
Route::post('/ekspertiz-form-submit', 'formsController@ekspertizForm')->name('ekspertizForms');
Route::post('/serviskayit-form-submit', 'formsController@serviskayitForm')->name('serviskayitForms');
Route::post('/bsarayalim-form-submit', 'formsController@bsarayalimForm')->name('bsarayalimForms');
Route::post('/bulten-form-submit', 'formsController@bultenForm')->name('bultenForms'); 
Route::post('/ik-form-submit', 'formsController@ikForm')->name('ikForms');

Route::get('/blog', 'blogController@bloglar')->name('bloglar');
Route::get('/blog/{slug}', 'blogController@singleBlogs')->name('blog');


// YSİİD
Route::post('auth/login', 'HomeController@login')->name('login');
Route::post('auth/save', 'HomeController@authRegister')->name('authRegister');
Route::post('auth/upload', 'HomeController@authUpload')->name('authUpload');
Route::post('auth/delete', 'HomeController@authImageDelete')->name('authDelete');
Route::post('auth/saveMyForm', 'HomeController@saveMyForm')->name('saveMyForm');

Route::get('/iletisim', 'HomeController@iletisim')->name('iletisim');
Route::get('/duyuru-listesi', 'HomeController@duyuruListe')->name('duyuruListeLocal');
Route::get('/onemli-bilgilendirmeler', 'HomeController@onemliBilgilendirmeler')->name('onemliBilgilendirmeler');


//  İLETİŞİM KAYIT


Route::POST('/iletisim-kayit', 'HomeController@iletisimSave')->name('iletisimSave');





Route::group(['prefix' => 'e-ysiid', 'middleware' => ['uyeLoginControl']], function () {
    Route::get('/', 'HomeController@eysiid')->name('eysiid');
    Route::get('/portal', 'HomeController@portal')->name('portal');
    Route::get('/logout', 'HomeController@logout')->name('logout');
    Route::get('/register', 'HomeController@register')->name('register');
    Route::get('/register/register-step-two', 'HomeController@authRegisterTwo')->name('authRegisterTwo');
    Route::post('/register/list-files', 'HomeController@listFiles')->name('listFiles');
    Route::post('/register/add-file', 'HomeController@addFile')->name('addFile');
    Route::post('/receiptupload', 'HomeController@receiptupload')->name('eysiid.receipt');

    Route::get('/uye-bilgilerim', 'HomeController@uyebilgilerim')->name('uyebilgilerim');
    Route::get('/yuklenen-dosyalar', 'HomeController@yuklenendosyalar')->name('yuklenendosyalar');
    Route::get('/odemeler', 'HomeController@odemeler')->name('odemeler');
    Route::get('/sifre-degistir', 'HomeController@sifredegistir')->name('sifredegistir');
    Route::post('/dekont-yukle', 'HomeController@dekontyukle')->name('dekontyukle');
    Route::post('/sifredegistirislemi', 'HomeController@sifredegistirislemi')->name('password_change_progress');
    Route::post('/logout', 'HomeController@logout')->name('logout');

});








