<?php

use App\Http\Controllers\BayiController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Symfony\Component\HttpFoundation\Session\Session;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/





Route::group(['prefix' => 'admin', 'middleware' => ['LoginControl']], function () {

    Route::get('/login', 'adminController@login')->name('login');
    Route::post('/login-progress', 'adminController@loginProgress')->name('loginProgress');
    Route::get('/test', 'adminController@test')->name('test');
    Route::get('/panel', 'adminController@panel')->name('panel');
    Route::get('/menu-duzenle', 'adminController@menuedit')->name('menuedit');
    Route::post('/menu-duzenle-add', 'adminController@menuduzenleadd')->name('menuduzenleadd');
    Route::post('/menu-reorder', 'adminController@menureorder')->name('menureorder');
    Route::post('/menu-duzenle', 'adminController@getMenuElement')->name('menuedit_single');
    Route::patch('/menu-duzenle', 'adminController@editMenuElement')->name('menuedit_single_update');
    Route::post('/menu-sil', 'adminController@deleteMenuElement')->name('menuedit_single_update');
    Route::patch('/kategori-duzenle', 'adminController@editKategoriElement')->name('kategoriedit_single_update');
    Route::post('/kategori-duzenle-add', 'adminController@kategoriduzenleadd')->name('kategoriduzenleadd');
    Route::post('/kategori-duzenle', 'adminController@getKategoriElement')->name('kategoriedit_single');
    Route::get('/kategori-duzenle', 'adminController@kategoriedit')->name('kategoriedit');
    Route::post('/kategori-reorder', 'adminController@kategorireorder')->name('menureorder');
    Route::post('/kategori-sil', 'adminController@deleteKategoriElement')->name('menuedit_single_update');
    Route::get('/static-folder-list', 'adminController@listFolder')->name('ListStaticFolder');
    Route::get('/logout', 'adminController@logout')->name('logout');
   



    Route::prefix('/pages')->group(function () {
        Route::post('ckeditor/upload', 'CKEditorController@upload')->name('ckeditor.image-upload');
        Route::get('category', 'pagesController@page_category_list')->name('page_category');
        Route::post('category', 'pagesController@page_category_list_save')->name('page_category_save');
        Route::put('category', 'pagesController@page_category_edit_save')->name('page_category_edit');
        Route::delete('category', 'pagesController@page_category_delete')->name('page_category_delete');
        Route::get('newpage', 'pagesController@newpage')->name('newpage');
        Route::post('newpage', 'pagesController@newpage_save')->name('page.newpage_save');
        Route::post('status-changer', 'pagesController@statusChanger')->name('page.statusChanger');
        Route::get('list', 'pagesController@list')->name('list');
        Route::get('edit/{id}', 'pagesController@pageEdit')->name('page.Edit');
        Route::post('edit_save/{id}', 'pagesController@pageEdit_save')->name('page.Editsave');
        Route::post('delete', 'pagesController@delete')->name('page.delete');
    });

   




    Route::prefix('/news')->group(function () {
        Route::post('ckeditor/upload', 'CKEditorController@upload')->name('ckeditor.image-upload');
        Route::get('list', 'newsController@list')->name('news.list');
        Route::get('ajaxList', 'newsController@ajaxList')->name('news.ajaxList');
        Route::get('newpage', 'newsController@newpage')->name('newpage');
        Route::post('newpage', 'newsController@newpage_save')->name('news.newpage_save');
        Route::post('ajaxSluq', 'newsController@ajaxSluq')->name('news.ajaxSluq');
        Route::post('delete', 'newsController@delete')->name('news.delete');
        Route::get('edit/{id}', 'newsController@edit')->name('news.edit');
        Route::post('edit_save/{id}', 'newsController@pageEdit_save')->name('news.Editsave');
    });

    Route::prefix('/contactforms')->group(function () {
        Route::get('list', 'formsController@list')->name('contactforms.list');
        Route::post('/deleteforms', 'adminController@deleteForm')->name('deleteForms');
    });

    Route::prefix('/bsarayalimforms')->group(function () {
        Route::get('list', 'formsController@bsarayalimlist')->name('bsarayalim.list');
        Route::post('/deleteforms', 'formsController@bsarayalimdeleteForm')->name('bsarayalimdeleteForms');
    });

    Route::prefix('/bultenforms')->group(function () {
        Route::get('list', 'formsController@bultenformslist')->name('bultenforms.list');
        Route::post('/deleteforms', 'formsController@bultendeleteForm')->name('bultendeleteForms');
    });

   

  
    Route::prefix('/social')->group(function () {
        Route::get('list', 'formsController@sociallist')->name('social.list');
        Route::post('create', 'formsController@socialCreate')->name('socialCreate');
    });

    Route::prefix('/member')->group(function () {
        Route::get('new', 'memberController@new')->name('newMember');
        Route::get('list', 'memberController@list')->name('memberList');
        Route::get('ajaxlist', 'memberController@ajaxList')->name('memberAjaxList');
        Route::post('memberStatusChanger', 'memberController@ajaxList')->name('memberStatusChanger');
        Route::post('memberDelete', 'memberController@ajaxList')->name('memberDelete');
        Route::get('check', 'memberController@check')->name('memberCheck');
        Route::get('edit', 'memberController@edit')->name('member.Edit');
        Route::post('approved-changer', 'memberController@approvedChanger')->name('member.approvedChanger');
        Route::post('isActiveChanger', 'memberController@isActiveChanger')->name('member.isActiveChanger');
        Route::post('receiptList', 'memberController@receiptList')->name('member.receiptList');
        Route::post('register_pay', 'memberController@register_pay')->name('member.register_pay');
        Route::get('odemeler', 'memberController@odemeler')->name('member.odemeler');
        Route::get('odemeler-ajaxList', 'memberController@odemelerajax')->name('odemeler.ajaxList');
        Route::post('odemeler-changePay', 'memberController@changePay')->name('odemeler.changePay');
        Route::post('setAidat', 'memberController@setAidat')->name('member.setAidat');


        // ---------------------------------------------

        Route::get('odeme_olustur', 'memberController@odeme_olustur')->name('member.odeme_olustur');
        Route::POST('odeme_islem', 'memberController@odeme_islem')->name('member.odeme_islem');

        
       
    });

    Route::prefix('/duyurular')->group(function () {
        Route::get('list', 'adminController@duyuruListesi')->name('duyuruListe');
        Route::post('ekle', 'adminController@duyuruEkle')->name('duyuruEkle');
        Route::post('sil', 'adminController@duyuruSil')->name('duyuruDelete');

    });

      Route::prefix('/iletisim-formu')->group(function () {
        Route::get('list', 'adminController@iletisimListesi')->name('iletisimListe');
        Route::post('sil', 'adminController@iletisimSil')->name('iletisimDelete');
    });

   

});
