@extends('layouts.app')
@section('content')


<!-- Ionicons CSS dosyası -->
<link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">

<!-- Ionicons JS dosyası -->
<script src="https://code.ionicframework.com/ionicons/2.0.1/js/ionicons.min.js"></script>


<style>
    .barMenu {
        overflow-x: auto;
        overflow-y: hidden;
    }

    .barMenu a {
        display: block;
        text-decoration: none;
        color: #333;
        height: 60px;
        display: flex;
        align-items: center;
        padding: 0px 6px;
        text-align: center;
        font-size: 14px;
        -webkit-transition: all .5s ease-in-out;
        -moz-transition: all .5s ease-in-out;
        -o-transition: all .5s ease-in-out;
        transition: all .5s ease-in-out;
        border-right: 1px solid #eeeeeec4;
        color: #333;
    }

    .barMenu a:last-child {
        border: none;
    }

    .barMenu a:hover {
        color: #fff;
        background-color: #333;
    }


    .brcrumb {

        height: 250px;
        background-color: #000 !important;
        background-size: cover;

        background-position: center center;
        background-image: url('/assets/images/bread.jpg');
    }

    .brcrumb_content {
        position: absolute;
        bottom: 20px;
        left: 1%;
        height: 30px;
        background-color: #ddd;
        padding: 10px;
        border-radius: 2px;
        display: flex;
        align-items: center;
        font-weight: 700;
        border: 1px solid #ddd;
        -webkit-transition: all .5s ease-in-out;
        -moz-transition: all .5s ease-in-out;
        -o-transition: all .5s ease-in-out;
        transition: all .5s ease-in-out;
    }

    .brcrumb_content:hover {
        background-color: #fff;
        border: 1px solid #fff;
    }

    .brcrumb_content ul {
        padding: 0;
        margin: 0;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .brcrumb_content ul li {
        display: block;
        margin-right: 5px;
        position: relative;
    }

    .brcrumb_content ul li:first-child::after {
        content: ' ';
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24'%3E%3Cpath d='M16.5 13.1L7.6 22c-.8-.8-.8-2 0-2.8l6.1-6.1-6-6.1c-.8-.8-.8-2 0-2.8l8.8 8.9z'/%3E%3C/svg%3E");
        height: 15px;
        width: 20px;
        display: block;
        position: absolute;
        z-index: 2;
        right: -10px;
        top: 5px;


    }

    .brcrumb_content ul li a {
        margin-right: 10px;
        text-decoration: none;
        color: #333;
    }

    .brcrumb_content .active {
        color: #f22613;
    }

    .active-menu {
    background-color: #f22613;
}
</style>

@if(App::getLocale() == 'tr')

<div style="min-height:600px">
    <div class="mb-5">
        <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d7274.038362913563!2d32.523940882049295!3d39.95578389599414!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x14d3252f90764439%3A0xb1ba73aac64e71d0!2sNETELSAN!5e0!3m2!1str!2str!4v1677569130887!5m2!1str!2str" width="100%" height="300" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
        <div class="container-fluid d-flex align-items-center shadow d-none d-md-block mb-4" style="background-color: #fff;height:60px;margin-top:-5px;">
            <div class="container">
                <div class="col-12 d-flex justify-content-start barMenu">
                    <a class="active "
                                style="{{ $page->target == 'servislerimiz' ? 'background-color:red; color:#fff' : '' }}"
                                href="/page/servislerimiz" aria-current="true">
                                Servislerimiz
                            </a>
                            <a class="active "
                                style="{{ $page->target == 'servisKayit' ? 'background-color:red; color:#fff' : '' }}"
                                href="/page/servisKayit" aria-current="true">
                                Servis kayıt Formu
                            </a>
                </div>
            </div>
        </div>




        <div class="container">
            <div class="row mb-5">
                <div class="col-12">
                    <div class="master_title">
                        <h1>{{ (App::getLocale() == 'tr')  ? 'Teknik Servisler Bayi Listesi' : 'Technical Services Dealer List' }}</h1>
                    </div>
                </div>
        
            </div>
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <h3>Netelsan Fabrika</h3>
                        <p><iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d15435.245646576943!2d32.5251581!3d39.9553265!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x14d3252f90764439%3A0xb1ba73aac64e71d0!2sNETELSAN!5e1!3m2!1str!2str!4v1677650215868!5m2!1str!2str" width="100%" height="350" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe></p>
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h3><span style="white-space:pre"> </span>MERKEZ / FABRİKA TÜRKİYE TEKNİK SERVİS MÜDÜRÜ</h3>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>TÜRKİYE GENELİ</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 530 322 57 96</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>CEM DALMIŞ</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>MERKEZ / FABRİKA TÜRKİYE TEKNİK SERVİS YÖNETİCİSİ</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>TÜRKİYE GENELİ</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 530 322 57 96</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>DİLEK BEZEN</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                       
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ADANA BÖLGE SORUMLUSU</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ADANA BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 530 141 68 61</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>EREN ERTAN</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ADANA BÖLGE TEKNİK SERVİS SORUMLUSU</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ADANA BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 533 697 23 39</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>FARUK NAZİK</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ANKARA FABRİKA - MERKEZ(SANTRAL)</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ANKARA BÖLGE SANTRAL</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>444 8 604</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>SANTRAL</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ANKARA BÖLGE TEKNİK SERVİS SORUMLUSU</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ANKARA BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 507 120 14 52</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>AKIN AKPINAR</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ANKARA BÖLGE TEKNİK SERVİS PERSONELİ</h4>
                                <div style="overflow-x:auto;" class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ANKARA BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 541 428 31 06</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>MUSTAFA COŞKUN</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ANTALYA BÖLGE SORUMLUSU</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ANTALYA BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 530 322 48 67</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>SEREN AVŞAR AKIN</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ANTALYA BÖLGE TEKNİK SERVİS SORUMLUSU</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ANTALYA BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 530 322 57 35</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>YASİN AKSOY</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
        
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>BURSA BÖLGE MÜDÜRÜ</h4>
                                <div style="overflow-x:auto;" class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>BURSA BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 533 699 81 36</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>MURAT ERGÜL</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
        
        
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>BURSA BÖLGE TEKNİK SERVİS SORUMLUSU</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>BURSA BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 546 416 66 60</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>RECEP GÜLLER</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>DİYARBAKIR BÖLGE SORUMLUSU</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured                                                                                                     
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>DİYARBAKIR BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 530 322 57 33</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>SAVAŞ ALLAK</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>DİYARBAKIR BÖLGE TEKNİK SERVİS SORUMLUSU</h4>
                                <div style="overflow-x:auto;" class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>DİYARBAKIR BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 549 420 25 30</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>MUSTAFA SEVİM</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ERZURUM BÖLGE SORUMLUSU</h4>
                                <div style="overflow-x:auto;" class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ERZURUM BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 543 668 57 41</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>UFUK ŞİŞECİ</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ERZURUM BÖLGE TEKNİK SERVİS SORUMLUSU</h4>
                                <div style="overflow-x:auto;" class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ERZURUM BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 543 850 62 70</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>ENES UÇAN</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
        
        
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ESKİŞEHİR BÖLGE SORUMLUSU</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ESKİŞEHİR BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 549 517 77 70</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>M. ALİ ESKİ</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ESKİŞEHİR BÖLGE TEKNİK SERVİS SORUMLUSU</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ESKİŞEHİR BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 541 428 33 11</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>GÖKHAN SİVRİ</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>GAZİANTEP BÖLGE SORUMLUSU</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>GAZİANTEP BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 533 699 81 29</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>MEHMET YUNUS KURTULAN</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
        
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>GAZİANTEP BÖLGE TEKNİK SERVİS SORUMLUSU</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>GAZİANTEP BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 544 816 25 08</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>UĞUR YUSUF KANAT</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
        
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <h3>İstanbul Bölge Müdürlüğü</h3>
                        <p><iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d15191.121142240818!2d28.9710376!3d41.0251372!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x14caa0f3dff8f117%3A0x5ae3d2b525d764a1!2sNetelsan!5e1!3m2!1str!2str!4v1677650092427!5m2!1str!2str" width="100%" height="350" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe></p>
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>İSTANBUL BÖLGE MÜDÜRLÜĞÜ</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>İSTANBUL BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 216 572 34 06</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>SANTRAL</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>MARMARA BÖLGE MÜDÜRÜ</h4>
                                <div style="overflow-x:auto;" class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>MARMARA BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 549 796 48 35</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>TANER YILMAZ</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
        
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>İSTANBUL BÖLGE TEKNİK SERVİS SORUMLUSU</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>İSTANBUL BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 530 322 57 95</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>MİTHAT GÜVENÇ</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
        
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>İSTANBUL BÖLGE TEKNİK SERVİS PERSONELİ</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>İSTANBUL BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 543 660 92 15</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>MERT ERGÜL</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
        
        
        
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>İZMİR BÖLGE MÜDÜRÜ</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>İZMİR BÖLGE</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 533 699 81 28</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>SERKAN YANKOL</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        
        
        
        
                <div class="row">
                    <div class="col-12 col-md-4">
                        <div class="page-content-top">
                            <!-- Harite yerleştirme alanı-->
                        </div>
                    </div>
                    <div class="col-12 col-md-8">
                        <div class="page-content-top">
                            <div class="col-xs-12">
                                <div class="aboutus-info-inner" >
                                    <h4><span style="white-space:pre"> </span>İZMİR BÖLGE TEKNİK SERVİS SORUMLUSU</h4>
                                    <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                        <div class="card">
                                            <!-- <div class="card-header">
                                                Featured
                                            </div> -->
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>İZMİR BÖLGE</li>
                                                <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 530 322 48 68</li>
                                                <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>HAYDAR YALÇIN</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="row">
                    <div class="col-12 col-md-4">
                        <div class="page-content-top">
                            <!-- Harite yerleştirme alanı-->
                        </div>
                    </div>
                    <div class="col-12 col-md-8">
                        <div class="page-content-top">
                            <div class="col-xs-12">
                                <div class="aboutus-info-inner" >
                                    <h4><span style="white-space:pre"> </span>MALATYA BÖLGE SORUMLUSU</h4>
                                    <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                        <div class="card">
                                            <!-- <div class="card-header">
                                                Featured
                                            </div> -->
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>MALATYA BÖLGE</li>
                                                <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 549 796 01 69</li>
                                                <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>KEREM ALTUNTOP</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="row">
                    <div class="col-12 col-md-4">
                        <div class="page-content-top">
                            <!-- Harite yerleştirme alanı-->
                        </div>
                    </div>
                    <div class="col-12 col-md-8">
                        <div class="page-content-top">
                            <div class="col-xs-12">
                                <div class="aboutus-info-inner" >
                                    <h4><span style="white-space:pre"> </span>MALATYA BÖLGE TEKNİK SERVİS SORUMLUSU</h4>
                                    <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                        <div class="card">
                                            <!-- <div class="card-header">
                                                Featured
                                            </div> -->
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>MALATYA BÖLGE</li>
                                                <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 549 369 62 01</li>
                                                <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>ERDEM TURCAN</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



                <div class="row">
                    <div class="col-12 col-md-4">
                        <div class="page-content-top">
                            <!-- Harite yerleştirme alanı-->
                        </div>
                    </div>
                    <div class="col-12 col-md-8">
                        <div class="page-content-top">
                            <div class="col-xs-12">
                                <div class="aboutus-info-inner" >
                                    <h4><span style="white-space:pre"> </span>SAMSUN BÖLGE TEKNİK SERVİS SORUMLUSU</h4>
                                    <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                        <div class="card">
                                            <!-- <div class="card-header">
                                                Featured
                                            </div> -->
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>SAMSUN BÖLGE</li>
                                                <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 549 369 62 03</li>
                                                <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>GÖKHAN ATAY</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>




                <div class="row">
                    <div class="col-12 col-md-4">
                        <div class="page-content-top">
                            <!-- Harite yerleştirme alanı-->
                        </div>
                    </div>
                    <div class="col-12 col-md-8">
                        <div class="page-content-top">
                            <div class="col-xs-12">
                                <div class="aboutus-info-inner" >
                                    <h4><span style="white-space:pre"> </span>TRABZON BÖLGE TEKNİK SERVİS SORUMLUSU</h4>
                                    <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                        <div class="card">
                                            <!-- <div class="card-header">
                                                Featured
                                            </div> -->
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>TRABZON BÖLGE</li>
                                                <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 541 428 33 13</li>
                                                <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>HAKAN ÇAKMAKCI</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>




                <div class="row">
                    <div class="col-12 col-md-4">
                        <div class="page-content-top">
                            <!-- Harite yerleştirme alanı-->
                        </div>
                    </div>
                    <div class="col-12 col-md-8">
                        <div class="page-content-top">
                            <div class="col-xs-12">
                                <div class="aboutus-info-inner" >
                                    <h4><span style="white-space:pre"> </span>NİĞDE BÖLGE TEKNİK SERVİS SORUMLUSU</h4>
                                    <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                        <div class="card">
                                            <!-- <div class="card-header">
                                                Featured
                                            </div> -->
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>NİĞDE BÖLGE</li>
                                                <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 530 788 44 29</li>
                                                <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>YASİN BİLİR</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



                <div class="row">
                    <div class="col-12 col-md-4">
                        <div class="page-content-top">
                            <!-- Harite yerleştirme alanı-->
                        </div>
                    </div>
                    <div class="col-12 col-md-8">
                        <div class="page-content-top">
                            <div class="col-xs-12">
                                <div class="aboutus-info-inner" >
                                    <h4><span style="white-space:pre"> </span>DENİZLİ BÖLGE TEKNİK SERVİS SORUMLUSU</h4>
                                    <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                        <div class="card">
                                            <!-- <div class="card-header">
                                                Featured
                                            </div> -->
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>DENİZLİ BÖLGE</li>
                                                <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 532 766 01 61</li>
                                                <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>RAMAZAN AKÇAY</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>




                <div class="row">
                    <div class="col-12 col-md-4">
                        <div class="page-content-top">
                            <!-- Harite yerleştirme alanı-->
                        </div>
                    </div>
                    <div class="col-12 col-md-8">
                        <div class="page-content-top">
                            <div class="col-xs-12">
                                <div class="aboutus-info-inner" >
                                    <h4><span style="white-space:pre"> </span>ŞANLIURFA BÖLGE TEKNİK SERVİS SORUMLUSU</h4>
                                    <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                        <div class="card">
                                            <!-- <div class="card-header">
                                                Featured
                                            </div> -->
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ŞANLIURFA BÖLGE</li>
                                                <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 542 686 59 80</li>
                                                <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>ENVER YILMAZ</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>





            </div>
        </div>
    </div>
</div>

@else

<div style="min-height:600px">
    <div class="mb-5">
        <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d7274.038362913563!2d32.523940882049295!3d39.95578389599414!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x14d3252f90764439%3A0xb1ba73aac64e71d0!2sNETELSAN!5e0!3m2!1str!2str!4v1677569130887!5m2!1str!2str" width="100%" height="300" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
        <div class="container-fluid d-flex align-items-center shadow d-none d-md-block mb-4" style="background-color: #fff;height:60px;margin-top:-5px;">
            <div class="container">
                <div class="col-12 d-flex justify-content-start barMenu">
                    <a class="active"
                    style="{{ $page->target == 'servislerimiz' ? 'background-color:red; color:#fff' : '' }}"
                    href="/page/servislerimiz" aria-current="true">
                    Services
                </a>
                <a class="active "
                    style="{{ $page->target == 'servisKayit' ? 'background-color:red; color:#fff' : '' }}"
                    href="/page/servisKayit" aria-current="true">
                    Service Registration Form
                </a>

                </div>
            </div>
        </div>

        <div class="container">
            <div class="row mb-5">
                <div class="col-12">
                    <div class="master_title">
                        <h1>{{ (App::getLocale() == 'tr')  ? 'Servislerimiz' : 'Services' }}</h1>
                    </div>
                </div>
            </div>



            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <h3>Netelsan Factory</h3>
                        <p><iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d15435.245646576943!2d32.5251581!3d39.9553265!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x14d3252f90764439%3A0xb1ba73aac64e71d0!2sNETELSAN!5e1!3m2!1str!2str!4v1677650215868!5m2!1str!2str" width="100%" height="350" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe></p>
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h3><span style="white-space:pre"> </span>HEADQUARTERS / FACTORY TURKEY TECHNICAL SERVICE MANAGER</h3>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>TURKEY IN GENERAL</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 530 322 57 96</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>CEM DALMIŞ</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>HEADQUARTERS / FACTORYTURKEY TECHNICAL SERVICE MANAGER</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>TURKEY IN GENERAL</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 530 322 57 96</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>DİLEK BEZEN</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                       
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ADANA REGION RESPONSIBLE</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ADANA REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 530 141 68 61</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>EREN ERTAN</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ADANA REGIONAL TECHNICAL SERVICE RESPONSIBLE</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ADANA REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 533 697 23 39</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>FARUK NAZİK</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ANKARA FACTORY - HEADQUARTERS(CENTRAL)</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ANKARA REGION CENTRAL</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>444 8 604</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>CENTRAL</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ANKARA REGIONAL TECHNICAL SERVICE RESPONSIBLE</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ANKARA REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 507 120 14 52</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>AKIN AKPINAR</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ANKARA REGION TECHNICAL SERVICE PERSONNEL</h4>
                                <div style="overflow-x:auto;" class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ANKARA REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 541 428 31 06</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>MUSTAFA COŞKUN</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ANTALYA REGION RESPONSIBLE</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ANTALYA REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 530 322 48 67</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>SEREN AVŞAR AKIN</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ANTALYA REGIONAL TECHNICAL SERVICE RESPONSIBLE</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ANTALYA REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 530 322 57 35</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>YASİN AKSOY</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>BURSA REGION DIRECTOR</h4>
                                <div style="overflow-x:auto;" class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>BURSA REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 533 699 81 36</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>MURAT ERGÜL</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>BURSA REGIONAL TECHNICAL SERVICE RESPONSIBLE</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>BURSA REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 546 416 66 60</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>RECEP GÜLLER</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>DİYARBAKIR REGION RESPONSIBLE</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured                                                                                                     
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>DİYARBAKIR REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 530 322 57 33</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>SAVAŞ ALLAK</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>DİYARBAKIR REGIONAL TECHNICAL SERVICE RESPONSIBLE</h4>
                                <div style="overflow-x:auto;" class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>DİYARBAKIR REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 549 420 25 30</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>MUSTAFA SEVİM</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ERZURUM REGION RESPONSIBLE</h4>
                                <div style="overflow-x:auto;" class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ERZURUM REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 543 668 57 41</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>UFUK ŞİŞECİ</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ERZURUM REGIONAL TECHNICAL SERVICE RESPONSIBLE</h4>
                                <div style="overflow-x:auto;" class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ERZURUM REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 543 850 62 70</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>ENES UÇAN</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ESKİŞEHİR REGION RESPONSIBLE</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ESKİŞEHİR REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 549 517 77 70</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>M. ALİ ESKİ</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>ESKİŞEHİR REGIONAL TECHNICAL SERVICE RESPONSIBLE</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ESKİŞEHİR REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 541 428 33 11</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>GÖKHAN SİVRİ</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>GAZİANTEP REGION RESPONSIBLE</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>GAZİANTEP REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 533 699 81 29</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>MEHMET YUNUS KURTULAN</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>GAZİANTEP REGIONAL TECHNICAL SERVICE RESPONSIBLE</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>GAZİANTEP REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 544 816 25 08</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>UĞUR YUSUF KANAT</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <h3>İSTANBUL REGIONAL DIRECTORATE</h3>
                        <p><iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d15191.121142240818!2d28.9710376!3d41.0251372!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x14caa0f3dff8f117%3A0x5ae3d2b525d764a1!2sNetelsan!5e1!3m2!1str!2str!4v1677650092427!5m2!1str!2str" width="100%" height="350" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe></p>
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>İSTANBUL REGIONAL DIRECTORATE</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>İSTANBUL REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 216 572 34 06</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>CENTRAL</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>MARMARA REGION DIRECTOR</h4>
                                <div style="overflow-x:auto;" class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>MARMARA REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 549 796 48 35</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>TANER YILMAZ</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>İSTANBUL REGIONAL TECHNICAL SERVICE RESPONSIBLE</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>İSTANBUL REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 530 322 57 95</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>MİTHAT GÜVENÇ</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>İSTANBUL REGION TECHNICAL SERVICE PERSONNEL</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>İSTANBUL REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 543 660 92 15</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>MERT ERGÜL</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            
            
            <div class="row">
                <div class="col-12 col-md-4">
                    <div class="page-content-top">
                        <!-- Harite yerleştirme alanı-->
                    </div>
                </div>
                <div class="col-12 col-md-8">
                    <div class="page-content-top">
                        <div class="col-xs-12">
                            <div class="aboutus-info-inner" >
                                <h4><span style="white-space:pre"> </span>İZMİR REGION DIRECTOR</h4>
                                <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                    <div class="card">
                                        <!-- <div class="card-header">
                                            Featured
                                        </div> -->
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>İZMİR REGION</li>
                                            <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 533 699 81 28</li>
                                            <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>SERKAN YANKOL</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
            
            
            
                <div class="row">
                    <div class="col-12 col-md-4">
                        <div class="page-content-top">
                            <!-- Harite yerleştirme alanı-->
                        </div>
                    </div>
                    <div class="col-12 col-md-8">
                        <div class="page-content-top">
                            <div class="col-xs-12">
                                <div class="aboutus-info-inner" >
                                    <h4><span style="white-space:pre"> </span>İZMİR REGIONAL TECHNICAL SERVICE RESPONSIBLE</h4>
                                    <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                        <div class="card">
                                            <!-- <div class="card-header">
                                                Featured
                                            </div> -->
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>İZMİR REGION</li>
                                                <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 530 322 48 68</li>
                                                <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>HAYDAR YALÇIN</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            
            
                <div class="row">
                    <div class="col-12 col-md-4">
                        <div class="page-content-top">
                            <!-- Harite yerleştirme alanı-->
                        </div>
                    </div>
                    <div class="col-12 col-md-8">
                        <div class="page-content-top">
                            <div class="col-xs-12">
                                <div class="aboutus-info-inner" >
                                    <h4><span style="white-space:pre"> </span>MALATYA REGION RESPONSIBLE</h4>
                                    <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                        <div class="card">
                                            <!-- <div class="card-header">
                                                Featured
                                            </div> -->
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>MALATYA REGION</li>
                                                <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 549 796 01 69</li>
                                                <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>KEREM ALTUNTOP</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            
            
                <div class="row">
                    <div class="col-12 col-md-4">
                        <div class="page-content-top">
                            <!-- Harite yerleştirme alanı-->
                        </div>
                    </div>
                    <div class="col-12 col-md-8">
                        <div class="page-content-top">
                            <div class="col-xs-12">
                                <div class="aboutus-info-inner" >
                                    <h4><span style="white-space:pre"> </span>MALATYA REGIONAL TECHNICAL SERVICE RESPONSIBLE</h4>
                                    <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                        <div class="card">
                                            <!-- <div class="card-header">
                                                Featured
                                            </div> -->
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>MALATYA REGION</li>
                                                <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 549 369 62 01</li>
                                                <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>ERDEM TURCAN</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            
            
            
                <div class="row">
                    <div class="col-12 col-md-4">
                        <div class="page-content-top">
                            <!-- Harite yerleştirme alanı-->
                        </div>
                    </div>
                    <div class="col-12 col-md-8">
                        <div class="page-content-top">
                            <div class="col-xs-12">
                                <div class="aboutus-info-inner" >
                                    <h4><span style="white-space:pre"> </span>SAMSUN REGIONAL TECHNICAL SERVICE RESPONSIBLE</h4>
                                    <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                        <div class="card">
                                            <!-- <div class="card-header">
                                                Featured
                                            </div> -->
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>SAMSUN REGION</li>
                                                <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 549 369 62 03</li>
                                                <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>GÖKHAN ATAY</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            
            
            
            
                <div class="row">
                    <div class="col-12 col-md-4">
                        <div class="page-content-top">
                            <!-- Harite yerleştirme alanı-->
                        </div>
                    </div>
                    <div class="col-12 col-md-8">
                        <div class="page-content-top">
                            <div class="col-xs-12">
                                <div class="aboutus-info-inner" >
                                    <h4><span style="white-space:pre"> </span>TRABZON REGIONAL TECHNICAL SERVICE RESPONSIBLE</h4>
                                    <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                        <div class="card">
                                            <!-- <div class="card-header">
                                                Featured
                                            </div> -->
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>TRABZON REGION</li>
                                                <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 541 428 33 13</li>
                                                <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>HAKAN ÇAKMAKCI</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            
            
            
            
                <div class="row">
                    <div class="col-12 col-md-4">
                        <div class="page-content-top">
                            <!-- Harite yerleştirme alanı-->
                        </div>
                    </div>
                    <div class="col-12 col-md-8">
                        <div class="page-content-top">
                            <div class="col-xs-12">
                                <div class="aboutus-info-inner" >
                                    <h4><span style="white-space:pre"> </span>NİĞDE REGIONAL TECHNICAL SERVICE RESPONSIBLE</h4>
                                    <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                        <div class="card">
                                            <!-- <div class="card-header">
                                                Featured
                                            </div> -->
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>NİĞDE REGION</li>
                                                <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 530 788 44 29</li>
                                                <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>YASİN BİLİR</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            
            
            
                <div class="row">
                    <div class="col-12 col-md-4">
                        <div class="page-content-top">
                            <!-- Harite yerleştirme alanı-->
                        </div>
                    </div>
                    <div class="col-12 col-md-8">
                        <div class="page-content-top">
                            <div class="col-xs-12">
                                <div class="aboutus-info-inner" >
                                    <h4><span style="white-space:pre"> </span>DENİZLİ REGIONAL TECHNICAL SERVICE RESPONSIBLE</h4>
                                    <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                        <div class="card">
                                            <!-- <div class="card-header">
                                                Featured
                                            </div> -->
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>DENİZLİ REGION</li>
                                                <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 532 766 01 61</li>
                                                <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>RAMAZAN AKÇAY</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            
            
            
            
                <div class="row">
                    <div class="col-12 col-md-4">
                        <div class="page-content-top">
                            <!-- Harite yerleştirme alanı-->
                        </div>
                    </div>
                    <div class="col-12 col-md-8">
                        <div class="page-content-top">
                            <div class="col-xs-12">
                                <div class="aboutus-info-inner" >
                                    <h4><span style="white-space:pre"> </span>ŞANLIURFA REGIONAL TECHNICAL SERVICE RESPONSIBLE</h4>
                                    <div style="overflow-x:auto; " class="ms-0 ms-md-4 mb-5">
                                        <div class="card">
                                            <!-- <div class="card-header">
                                                Featured
                                            </div> -->
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><em class="ion-ios-home 2x" style="margin-right:10px; color:red; font-size:23px;"></em>ŞANLIURFA REGION</li>
                                                <li class="list-group-item"><em class="ion-android-call" style="margin-right:10px; color:red; font-size:23px;"></em>0 542 686 59 80</li>
                                                <li class="list-group-item"><em class="ion-person" style="margin-right:10px; color:red; font-size:23px;"></em>ENVER YILMAZ</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            
            
            
            
            
            </div>
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            
            




            

        </div>

    </div>

</div>



@endif





@endsection