@extends('layouts.app')
@section('content')
<!-- Ionicons CSS dosyası -->
<link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">

<!-- Ionicons JS dosyası -->
<script src="https://code.ionicframework.com/ionicons/2.0.1/js/ionicons.min.js"></script>


<style>
    .barMenu {
        overflow-x: auto;
        overflow-y: hidden;
    }

    .barMenu a {
        display: block;
        text-decoration: none;
        color: #333;
        height: 60px;
        display: flex;
        align-items: center;
        padding: 0px 6px;
        text-align: center;
        font-size: 14px;
        -webkit-transition: all .5s ease-in-out;
        -moz-transition: all .5s ease-in-out;
        -o-transition: all .5s ease-in-out;
        transition: all .5s ease-in-out;
        border-right: 1px solid #eeeeeec4;
        color: #333;
    }

    .barMenu a:last-child {
        border: none;
    }

    .barMenu a:hover {
        color: #fff;
        background-color: #333;
    }


    .brcrumb {

        height: 250px;
        background-color: #000 !important;
        background-size: cover;

        background-position: center center;
        background-image: url('/assets/images/servis-kayit.jpg');
    }

    .brcrumb_content {
        position: absolute;
        bottom: 20px;
        left: 1%;

        height: 30px;
        background-color: #fff;
        padding: 10px;
        border-radius: 2px;
        display: flex;
        align-items: center;
        font-weight: 500;
        border: 1px solid #ddd;
        -webkit-transition: all .5s ease-in-out;
        -moz-transition: all .5s ease-in-out;
        -o-transition: all .5s ease-in-out;
        transition: all .5s ease-in-out;
    }

    .brcrumb_content:hover {
        background-color: #fff;
        border: 1px solid #fff;
    }

    .brcrumb_content ul {
        padding: 0;
        margin: 0;
        display: flex;
        align-items: center;
        justify-content: center;

    }

    .brcrumb_content ul li {
        display: block;
        margin-right: 5px;
        position: relative;
    }

    .brcrumb_content ul li::after {
        content: '/';
        height: 15px;
        width: 20px;
        display: block;
        position: absolute;
        z-index: 2;
        right: -13px;
        top: 1px;
        background-repeat: no-repeat;
        color: #adadad;

    }

    .brcrumb_content ul li:last-child::after {
        content: ' ';
        background-image: none;
        height: 15px;
        width: 20px;
        display: block;
        position: absolute;
        z-index: 2;
        right: -10px;
        top: 5px;

    }

    .brcrumb_content ul li a {
        margin-right: 10px;
        text-decoration: none;
        color: #333;
        font-weight: 400;
        font-size: 13px
    }


    .brcrumb_content li:last-child a {
        color: #f22613;
    }

    @media only screen and (max-width: 600px) {
        ._icerik {
            min-height: 100px;
        }

        .brcontainer {
            margin-bottom: 120px;
        }

        .brcrumb_content {
            width: 100%;
            height: auto;
            justify-content: center;
            align-items: center;
            bottom: -40%;
            background: transparent;
            border: 1px solid #eee;
            left: 0px;

        }

        .brcrumb_content ul {


            width: 100%;
            align-items: unset;
            flex-wrap: wrap;
            justify-content: flex-start
        }

        .brcrumb_content ul li {}

        .brcrumb_content ul li:last-child {
            border-bottom: none;
        }


        .brcrumb_content ul li::after {
            top: -1px;
            right: -14px;

        }

        ._content {
            margin-top: 120px !important;
        }
    }
</style>

@if (App::getLocale() == 'tr')
<div style="min-height:600px">
    <div class="mb-5">


        <div class="container-fluid">
            <div class="row">
                <div class="col-12 brcrumb">
                    <div class="container" style="position: relative;height:100%;">
                        <div class="brcrumb_content">
                            <div itemscope="" itemtype="http://schema.org/BreadcrumbList" style="width:100%">
                                <ul class="brul">

                                    <li itemprop="itemListElement" itemscope="" itemtype="http://schema.org/ListItem"><a itemprop="item" href="/"><span itemprop="name">{{ __('Anasayfa') }}</span></a>
                                        <meta itemprop="position" content="0">
                                    </li>

                                    <li itemprop="itemListElement" itemscope="" itemtype="http://schema.org/ListItem"><a itemprop="item" href="#"><span itemprop="name">{{ (App::getLocale() == 'tr')  ? 'Servis Kayıt Formu' : '' }}</span></a>
                                        <meta itemprop="position" content="1">
                                    </li>


                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        {{-- <iframe
                    src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d7274.038362913563!2d32.523940882049295!3d39.95578389599414!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x14d3252f90764439%3A0xb1ba73aac64e71d0!2sNETELSAN!5e0!3m2!1str!2str!4v1677569130887!5m2!1str!2str"
                    width="100%" height="300" style="border:0;" allowfullscreen="" loading="lazy"
                    referrerpolicy="no-referrer-when-downgrade"></iframe> --}}

        <div class="_content container-fluid d-flex align-items-center shadow d-none d-md-block mb-4" style="background-color: #fff;height:60px;margin-top:-5px;">
            <div class="container">
                <div class="col-12 d-flex justify-content-start barMenu">
                    <a class="active " style="{{ $page->target == 'servislerimiz' ? 'background-color:red; color:#fff' : '' }}" href="/page/servislerimiz" aria-current="true">
                        Servislerimiz
                    </a>
                    <a class="active " style="{{ $page->target == 'servisKayit' ? 'background-color:red; color:#fff' : '' }}" href="/page/servisKayit" aria-current="true">
                        Servis kayıt Formu
                    </a>


                </div>
            </div>
        </div>




        <div class="_content container">
            <div class="row mb-5">
                <div class="col-12">
                    <div class="master_title">
                        <h1>Servis kayıt Formu</h1>
                    </div>
                </div>

            </div>
        </div>

        <div class="container">
            <div class="row">
                <div class="col-12">
                    <center>
                        <p>Netelsan servis kayıt formunu iletmek için aşağıdaki bilgileri eksiksiz doldurup
                            gönderebilirsiniz.</p>
                    </center>
                </div>
            </div>
        </div>
          

        <div class="row mx-0 px-3 px-md-0 d-flex justify-content-center mt-5">
            <div class="col-12 col-md-6 col-lg-6  mt-5">

                @if (!empty(session('success')))
                    <div class="alert alert-success text-center mb-4">
                        <strong>{{ session('success') }}</strong>
                    </div>
                    @php session(['success' => '']); @endphp
                @endif


                <form id="servisKayit" action="/serviskayit-form-submit" method="post">
                    @csrf
                    <div class="form-group row mb-4 justify-content-center">
                        <div class="col-sm-12 col-md-3"><label class="col-sm-8 col-form-label" for="name" style="text-align:right;"><strong style="color:#f22613;">Ad Soyad(*) : </strong></label></div>
                        <div class="col-sm-12 col-md-5"><input class="form-control" minlength="3" data-cke-saved-name="name" name="adsoyad" placeholder="Adınız soyadınız..." required data-cke-editable="1" contenteditable="false"></div>
                    </div>
                    <div class="form-group row mb-4 justify-content-center">
                        <div class="col-sm-12 col-md-3"><label class="col-sm-8 col-form-label" for="phone" style="text-align:right;"><strong style="color:#f22613;">Telefon(*) :</strong></label></div>
                        <div class="col-sm-12 col-md-5"><input class="form-control" id="phone" maxlength="11" data-cke-saved-name="phone" name="tel" placeholder="0(XXX) XXX XX XX" required type="phone" data-cke-editable="1" contenteditable="false"></div>
                    </div>
                    <div class="form-group row mb-4 justify-content-center">
                        <div class="col-sm-12 col-md-3"><label class="col-sm-8 col-form-label" for="desc" style="text-align:right;"><strong style="color:#f22613;">Adres(*) :</strong></label></div>
                        <div class="col-sm-12 col-md-5">
                            <textarea class="form-control" id="desc" maxlength="600" name="adres" placeholder="Adres bilgilerinizi giriniz..." rows="3" data-cke-editable="1" contenteditable="false" required></textarea>
                        </div>
                    </div>
                    <div class="form-group row mb-4 justify-content-center">
                        <div class="col-sm-12 col-md-3"><label class="col-sm-8 col-form-label" for="desc" style="text-align:right;"><strong style="color:#f22613;">Kategori(*) :</strong></label></div>
                        <div class="col-sm-12 col-md-5"><select aria-label="Default select example" class="form-select" name="talep" required>
                                <option selected="selected" value="0">Lütfen Ana Kategoriyi Seçiniz...</option>
                                <option value="Bina Iletisim Sistemleri">Bina İletişim Sistemleri</option>
                                <option value="Sensorler">Sensörler</option>
                                <option value="Aydinlatma Armaturleri">Aydınlatma Armatürleri</option>
                                <option value="Acil Aydinlatma ve Yonlendirme Sistemleri">Acil Aydınlatma ve Yönlendirme Sistemleri</option>
                            </select></div>
                    </div>
                    <div class="form-group row mb-4 justify-content-center">
                        <div class="col-sm-12 col-md-3"><label class="col-sm-8 col-form-label" for="desc" style="text-align:right;"><strong style="color:#f22613;">Sistem Kuruluş Tarihi(*) :</strong></label></div>
                        <div class="col-sm-12 col-md-5  my-auto">
                            <div class="input-group date" id="datetimepicker5"><input class="form-control" type="date" data-cke-editable="1" contenteditable="false" name="tarih" required> <span class="input-group-addon"> <span class="glyphicon glyphicon-calendar"></span>
                                </span></div>
                        </div>
                    </div>
                    <script type="text/javascript">
                        $(function() {
                            $('#datetimepicker5').datetimepicker({
                                defaultDate: "11/1/2013",
                                disabledDates: [
                                    moment("12/25/2013"),
                                    new Date(2013, 11 - 1, 21),
                                    "11/22/2013 00:53"
                                ]
                            });
                        });
                    </script>
                    <div class="form-group row mb-4 justify-content-center">
                        <div class="col-sm-12 col-md-3"><label class="col-sm-8 col-form-label" for="email" style="text-align:right;"><strong style="color:#f22613;">E-mail(*) :</strong></label></div>
                        <div class="col-sm-12 col-md-5"><input class="form-control" id="exampleInputEmail1" data-cke-saved-name="email" name="eposta" placeholder="E-mail Adresiniz" required type="email" data-cke-editable="1" contenteditable="false">
                        </div>
                    </div>
                    <div class="form-group row mb-4 justify-content-center">
                        <div class="col-sm-12 col-md-3"><label class="col-sm-8 col-form-label" for="desc" style="text-align:right;"><strong style="color:#f22613;">Mesajınız(*) :</strong></label></div>
                        <div class="col-sm-12 col-md-5">
                            <textarea id="mesaj" class="form-control tarea" onkeydown="validatelimit(this,2000)" cols="20" rows="2" name="mesaj" placeholder="Mesajınızı giriniz..." required></textarea>
                            <div class="count">2000 karakter sınırınız var!</div>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-1 offset-md-9" data-n1ed-col-border-right="true"><input class="btn btn-danger" type="submit" value="GÖNDER" data-cke-editable="1" contenteditable="false"></div>
                    </div>
                </form>



            </div>

        </div>
    </div>

</div>
<script>
    function validatelimit(textarea, limit) {
        var remaining = limit - textarea.value.length;
        var count = textarea.parentNode.parentNode.querySelector('.count');
        count.innerHTML = remaining + ' Kalan karakter sayısı';
        if (remaining < 0) {
            count.classList.add('text-danger');
        } else {
            count.classList.remove('text-danger');
        }
    }
</script>
@else
<div style="min-height:600px">
    <div class="mb-5">


        <div class="container-fluid d-flex align-items-center shadow d-none d-md-block mb-4" style="background-color: #fff;height:60px;margin-top:-5px;">
            <div class="container">
                <div class="col-12 d-flex justify-content-start barMenu">
                    <a class="active" style="{{ $page->target == 'servislerimiz' ? 'background-color:red; color:#fff' : '' }}" href="/page/servislerimiz" aria-current="true">
                        Services
                    </a>
                    <a class="active " style="{{ $page->target == 'servisKayit' ? 'background-color:red; color:#fff' : '' }}" href="/page/servisKayit" aria-current="true">
                        Service Registration Form
                    </a>
                </div>
            </div>
        </div>

        <div class="container">
            <div class="row mb-5">
                <div class="col-12">
                    <div class="master_title">
                        <h1>Service Registration Form</h1>
                    </div>
                </div>

            </div>
        </div>

        <div class="container">
            <div class="row">
                <div class="col-12">
                    <center>
                        <p>To submit the Netelsan service registration form, you can fill in the information below
                            and send it.</p>
                    </center>
                </div>
            </div>
        </div>

        <div class="row mx-0 px-3 px-md-0 d-flex justify-content-center mt-5">
            <div class="col-12 col-md-6 col-lg-6  mt-5">

                @if (!empty(session('success')))
                <div class="alert alert-success text-center mb-4">
                    <strong>{{ session('success') }}</strong>
                </div>
                @php session(['success' => '']); @endphp
            @endif
                <form id="servisKayit" action="/serviskayit-form-submit" method="post">
                    @csrf
                    <div class="form-group row mb-4 justify-content-center">
                        <div class="col-sm-12 col-md-3"><label class="col-sm-8 col-form-label" for="name" style="text-align:right;"><strong style="color:#f22613;">Name(*) :</strong></label></div>
                        <div class="col-sm-12 col-md-5"><input class="form-control" minlength="3" data-cke-saved-name="name" name="adsoyad" placeholder="Name Surname" required data-cke-editable="1" contenteditable="false"></div>
                    </div>
                    <div class="form-group row mb-4 justify-content-center">
                        <div class="col-sm-12 col-md-3"><label class="col-sm-8 col-form-label" for="phone" style="text-align:right;"><strong style="color:#f22613;">Phone(*) :</strong></label></div>
                        <div class="col-sm-12 col-md-5"><input class="form-control" id="phone" maxlength="11" data-cke-saved-name="phone" name="tel" placeholder="0(XXX) XXX XX XX" required type="text" data-cke-editable="1" contenteditable="false"></div>
                    </div>
                    <div class="form-group row mb-4 justify-content-center">
                        <div class="col-sm-12 col-md-3"><label class="col-sm-8 col-form-label" for="desc" style="text-align:right;"><strong style="color:#f22613;">Adress(*) :</strong></label></div>
                        <div class="col-sm-12 col-md-5">
                            <textarea class="form-control" id="desc" maxlength="600" name="adres" placeholder="Enter your address information..." rows="3" data-cke-editable="1" contenteditable="false" required></textarea>
                        </div>
                    </div>
                    <div class="form-group row mb-4 justify-content-center">
                        <div class="col-sm-12 col-md-3"><label class="col-sm-8 col-form-label" for="desc" style="text-align:right;"><strong style="color:#f22613;">Category(*) :</strong></label></div>
                        <div class="col-sm-12 col-md-5"><select aria-label="Default select example" class="form-select" name="talep" required>
                                <option selected="selected" value="0">Please Select Main Category...</option>
                                <option value="Building Communication Systems">Building Communication Systems</option>
                                <option value="Motion Sensors">Motion Sensors</option>
                                <option value="Ceiling Lightings">Ceiling Lightings</option>
                                <option value="Emergency Lighting and Guidance Systems">Emergency Lighting and Guidance Systems</option>
                            </select></div>
                    </div>
                    <div class="form-group row mb-4 justify-content-center">
                        <div class="col-sm-12 col-md-3"><label class="col-sm-8 col-form-label" for="desc" style="text-align:right;"><strong style="color:#f22613;">Year Foundation(*) :</strong></label></div>
                        <div class="col-sm-12 col-md-5 my-auto">
                            <div class="input-group date" id="datetimepicker5"><input class="form-control" type="date" data-cke-editable="1" contenteditable="false" name="tarih" required> <span class="input-group-addon" required> <span class="glyphicon glyphicon-calendar"></span>
                                </span></div>
                        </div>
                    </div>
                    <script type="text/javascript">
                        $(function() {
                            $('#datetimepicker5').datetimepicker({
                                defaultDate: "11/1/2013",
                                disabledDates: [
                                    moment("12/25/2013"),
                                    new Date(2013, 11 - 1, 21),
                                    "11/22/2013 00:53"
                                ]
                            });
                        });
                    </script>
                    <div class="form-group row mb-4 justify-content-center">
                        <div class="col-sm-12 col-md-3"><label class="col-sm-8 col-form-label" for="email" style="text-align:right;"><strong style="color:#f22613;">E-mail(*) :</strong></label></div>
                        <div class="col-sm-12 col-md-5"><input class="form-control" id="exampleInputEmail1" data-cke-saved-name="email" name="eposta" placeholder="Your email adress" required type="email" data-cke-editable="1" contenteditable="false">
                        </div>
                    </div>
                    <div class="form-group row mb-4 justify-content-center">
                        <div class="col-sm-12 col-md-3"><label class="col-sm-8 col-form-label" for="desc" style="text-align:right;"><strong style="color:#f22613;">Message(*) :</strong></label></div>
                        <div class="col-sm-12 col-md-5">
                            <textarea id="mesaj" class="form-control tarea" onkeydown="validatelimit(this,2000)" cols="20" rows="2" name="mesaj" placeholder="Enter your message..." required></textarea>
                            <div class="count">2000 characters remaining</div>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-1 offset-md-9" data-n1ed-col-border-right="true"><input class="btn btn-danger" type="submit" value="SEND" data-cke-editable="1" contenteditable="false"></div>
                    </div>
                </form>




            </div>

        </div>

    </div>
</div>
<script>
    function validatelimit(textarea, limit) {
        var remaining = limit - textarea.value.length;
        var count = textarea.parentNode.parentNode.querySelector('.count');
        count.innerHTML = remaining + ' Remaining number of characters';
        if (remaining < 0) {
            count.classList.add('text-danger');
        } else {
            count.classList.remove('text-danger');
        }
    }
</script>
@endif
@endsection