@extends('layouts.app')
@section('content')


<style>
    .barMenu {
        overflow-x: auto;
        overflow-y: hidden;
    }

    .barMenu a {
        display: block;
        text-decoration: none;
        color: #333;
        height: 60px;
        display: flex;
        align-items: center;
        padding: 0px 6px;
        text-align: center;
        font-size: 14px;
        -webkit-transition: all .5s ease-in-out;
        -moz-transition: all .5s ease-in-out;
        -o-transition: all .5s ease-in-out;
        transition: all .5s ease-in-out;
        border-right: 1px solid #eeeeeec4;
        color: #333;
    }

    .barMenu a:last-child {
        border: none;
    }

    .barMenu a:hover {
        color: #fff;
        background-color: #333;
    }


    .brcrumb {

        height: 250px;
        background-color: #000 !important;
        background-size: cover;
        background-position: center center;
        background-image: url('/uploads/bayiler.jpg');
    }


    .brcrumb_content {
        position: absolute;
        bottom: 20px;
        left: 1%;

        height: 30px;
        background-color: #fff;
        padding: 10px;
        border-radius: 2px;
        display: flex;
        align-items: center;
        font-weight: 500;
        border: 1px solid #ddd;
        -webkit-transition: all .5s ease-in-out;
        -moz-transition: all .5s ease-in-out;
        -o-transition: all .5s ease-in-out;
        transition: all .5s ease-in-out;
    }

    .brcrumb_content:hover {
        background-color: #fff;
        border: 1px solid #fff;
    }

    .brcrumb_content ul {
        padding: 0;
        margin: 0;
        display: flex;
        align-items: center;
        justify-content: center;

    }

    .brcrumb_content ul li {
        display: block;
        margin-right: 5px;
        position: relative;
    }

    .brcrumb_content ul li::after {
        content: '/';
        height: 15px;
        width: 20px;
        display: block;
        position: absolute;
        z-index: 2;
        right: -13px;
        top: 1px;
        background-repeat: no-repeat;
        color: #adadad;

    }

    .brcrumb_content ul li:last-child::after {
        content: ' ';
        background-image: none;
        height: 15px;
        width: 20px;
        display: block;
        position: absolute;
        z-index: 2;
        right: -10px;
        top: 5px;

    }

    .brcrumb_content ul li a {
        margin-right: 10px;
        text-decoration: none;
        color: #333;
        font-weight: 400;
        font-size: 13px
    }


    .brcrumb_content li:last-child a {
        color: #f22613;
    }

    @media only screen and (max-width: 600px) {
        ._icerik {
            min-height: 100px;
        }

        .brcontainer {
            margin-bottom: 120px;
        }

        .brcrumb_content {
            width: 100%;
            height: auto;
            justify-content: center;
            align-items: center;
            bottom: -40%;
            background: transparent;
            border: 1px solid #eee;
            left: 0px;

        }

        .brcrumb_content ul {


            width: 100%;
            align-items: unset;
            flex-wrap: wrap;
            justify-content: flex-start
        }

        .brcrumb_content ul li {}

        .brcrumb_content ul li:last-child {
            border-bottom: none;
        }


        .brcrumb_content ul li::after {
            top: -1px;
            right: -14px;

        }

        ._content {
            margin-top: 120px !important;
        }
    }



    .cityName {
        width: 100%;
        border-bottom: 1px solid #ddd;
        padding: 2px 5px;
        margin-bottom: 20px;

    }
</style>
<div class="container-fluid">
    <div class="row">
        <div class="col-12 brcrumb">
            <div class="container" style="position: relative;height:100%;">
                <div class="brcrumb_content">
                    <div itemscope="" itemtype="http://schema.org/BreadcrumbList" style="width:100%">
                        <ul class="brul">

                            <li itemprop="itemListElement" itemscope="" itemtype="http://schema.org/ListItem"><a itemprop="item" href="/"><span itemprop="name">{{ __('Anasayfa') }}</span></a>
                                <meta itemprop="position" content="0">
                            </li>

                            <li itemprop="itemListElement" itemscope="" itemtype="http://schema.org/ListItem"><a itemprop="item" href="#"><span itemprop="name">{{ App::getLocale() == 'tr' ? 'Bayiler' : 'Dealers' }}</span></a>
                                <meta itemprop="position" content="1">
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>


<div class="container mt-5 mb-5 _content">

    <div class="row mb-5">
        <div class="col-12">
            <div class="master_title">
                <h1>{{ App::getLocale() == 'tr' ? 'Bayi Listesi' : 'Dealer List' }}</h1>
            </div>
        </div>
    </div>

    <div class="row">
        <div class=" col-12 ">

            <label for="inputPassword5" class="form-label"><strong>{{ __('Bölge Seçiniz') }}</strong></label>
            <select onchange="ilgetir(this)" class="form-select" id="bolge" aria-label="Default select example">
                <option selected disabled>{{ __('Seçiniz') }}</option>
            </select>
            <label for="inputPassword5" class="form-label mt-3"><strong>{{ __('İl Seçiniz') }}</strong></label>
            <select onchange="il_select(this)" class="form-select mb-3" id="il" aria-label="Default select example">
                <option selected disabled>{{ __('Seçiniz') }}</option>
            </select>
            <hr style="margin-top:20px;display:block">
            <label for="inputPassword5" class="form-label mt-3"><strong>{{ __('Distribütörler') }}</strong></label>
            <select onchange="distributors_select(this)" class="form-select" id="distributors" aria-label="Default select example">
                <option selected disabled>{{ __('Seçiniz') }}</option>
            </select>
            <hr style="margin-top:40px;display:block">
        </div>
        <div class=" col-12  px-3 mt-3 px-md-0  px-md-2">
            <div class="row pt-2" id="dealers_area"></div>
        </div>
    </div>
    <div style="width:100%;height:200px"></div>
</div>

<script>
    function distributors_select(e) {

        if (!e) {

            selectedCounty = "{{@$_GET['distributor']}}";
            selectedText = "{{@$_GET['distText']}}";
        } else {
            selectedCounty = $(e).find('option:selected').val();
            selectedText = $(e).find('option:selected').text();
        }




        $.ajax({
            type: "GET",
            url: "{{ route('getCountryListItem') }}",
            data: {
                selectedCounty
            },
            success: function(response) {

                response = JSON.parse(response);
                $("#dealers_area").empty();
                $("#dealers_area").append(`<div class="cityName col-12 mx-3 text-uppercase"><h3>${selectedText}</h3></div>`);
                 @if(App::getLocale() == 'tr')
                response.forEach(element => {
                    $("#dealers_area").append(`
                            <div class="col-12 col-md-6 mb-4" style="min-height:315px">
                            <div class="card border-0 shadow" style="height:100%">
                                <div class="card-header bg-danger text-white d-flex align-items-center">
                                     <iconify-icon style="font-size:23px" icon="uil-store"></iconify-icon>
                                    <h5 style="font-size:15px" class="card-title mb-0 ms-1 text-capitalize">${element.bayi_adi}</h5>
                                </div>
                                <div class="card-body">
                                  
                                    <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-location-point"></iconify-icon> Adresi:</strong></div>
                                        <div class="col-md-7 text-capitalize">${ typeof element.adres != 'object' ? element.adres : '-' }</div>
                                    </div>
                                      <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="mdi:user"></iconify-icon> Yetkili Adı:</strong></div>
                                        <div class="col-md-7 text-capitalize">${ typeof element.yetkili_adi != 'object' ? element.yetkili_adi : '-' }</div>
                                    </div>
                                    <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-phone"></iconify-icon> Telefon Numarası:</strong></div>
                                        <div class="col-md-7 text-capitalize">${ typeof element.telefon != 'object' ? element.telefon : '-' } ${ typeof element.telefon_2 != 'object' ? ' - ' +element.telefon_2 : ''}</div>
                                    </div>
                                    <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-print"></iconify-icon> Faks Numarası:</strong></div>
                                        <div class="col-md-7 text-capitalize">${ typeof element.faks != 'object' ? element.faks : '-' }</div>
                                    </div>
                                    <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-envelope"></iconify-icon> E-Posta Adresi:</strong></div>
                                        <div class="col-md-7">${ typeof element.email != 'object' ? element.email : '-' }</div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-globe"></iconify-icon> Web Adresi:</strong></div>
                                        <div class="col-md-7">${ typeof element.site != 'object' ? element.site : '-' }</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    `);

                });
                @else

 response.forEach(element => {
                    $("#dealers_area").append(`
                            <div class="col-12 col-md-6 mb-4" style="min-height:315px">
                            <div class="card border-0 shadow">
                               
                                <div class="card-body">
                                    <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="game-icons:modern-city"></iconify-icon> Province:</strong></div>
                                        <div class="col-md-7 text-capitalize">${ typeof element.adres != 'object' ? element.adres : '-' }</div>
                                    </div>
                                    <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-location-point"></iconify-icon> Address:</strong></div>
                                        <div class="col-md-7 text-capitalize">${ typeof element.adres != 'object' ? element.adres : '-' }</div>
                                    </div>
                                      <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="mdi:user"></iconify-icon> Authorized Name:</strong></div>
                                        <div class="col-md-7 text-capitalize">${ typeof element.yetkili_adi != 'object' ? element.yetkili_adi : '-' }</div>
                                    </div>
                                    <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-phone"></iconify-icon> Phone number:</strong></div>
                                        <div class="col-md-7 text-capitalize">${ typeof element.telefon != 'object' ? element.telefon : '-' } ${ typeof element.telefon_2 != 'object' ? ' - ' +element.telefon_2 : ''}</div>
                                    </div>
                                    <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-print"></iconify-icon> Fax Number:</strong></div>
                                        <div class="col-md-7 text-capitalize">${ typeof element.faks != 'object' ? element.faks : '-' }</div>
                                    </div>
                                    <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-envelope"></iconify-icon> E-mail address:</strong></div>
                                        <div class="col-md-7">${ typeof element.email != 'object' ? element.email : '-' }</div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-globe"></iconify-icon> Web address:</strong></div>
                                        <div class="col-md-7 ">${ typeof element.site != 'object' ? element.site : '-' }</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    `);

                });


                @endif


            }
        });








    }


    $(document).ready(function() {
        $.ajax({
            type: "GET",
            url: "{{ route('getBolgeList') }}",
            success: function(response) {
                response = JSON.parse(response);
                response.forEach(element => {
                    $("#bolge").append(
                        `<option value="${element.Id}">${element.BolgeAd}</option>`);

                });

            }
        });


        $.ajax({
            type: "GET",
            url: "{{route('get_ajax_country_list')}}",
            success: function(response) {
                response = JSON.parse(response);
                response.forEach(element => {
                    $("#distributors").append(
                        `<option value="${element.Id}">${element.BolgeAd}</option>`);
                });
            }
        });


        if ("{{@$_GET['distributor']}}" == "") {
            dealers_area();
        } else {
            distributors_select();
        }




    });

    function ilgetir(e) {
        const bolgeID = $(e).find('option:selected').val();
        $("#il").empty();
        $.ajax({
            type: "GET",
            url: "{{ route('getBolgeListIL') }}",
            data: {
                bolgeID
            },
            success: function(response) {
                $("#il").append(`<option selected disabled>Seçiniz</option>`);
                response = JSON.parse(response);
                response.forEach(element => {
                    $("#il").append(`<option value="${element.Id}">${element.SehirAd}</option>`);
                });
            }
        });
    }

    function il_select(e) {
        const il = $(e).find('option:selected').val();
        dealers_area(il);
    }




    function dealers_area(ilID = -1) {

        var _get = "{{@$_GET['il']}}";

        ilID = _get == '' ? ilID : _get;


        $.ajax({
            type: "POST",
            url: "{{ route('getBolgeListILFilter') }}",
            data: {
                ilID,
                "_token": "{{ csrf_token() }}"
            },
            success: function(response) {
                response = JSON.parse(response);
                const groupedData = response.reduce((result, item) => {
                    (result[item.SehirAd] || (result[item.SehirAd] = [])).push(item);
                    return result;
                }, {});
                $("#dealers_area").empty();
                $.map(groupedData, function(elementOrValue, indexOrKey) {
                    sehirName = indexOrKey;
                    $("#dealers_area").append(
                        `<div class="cityName col-12 mx-3 text-uppercase" ><h3>${sehirName}</h3></div>`
                    );
                    elementOrValue.forEach(element => {
                        @if(App::getLocale() == 'tr')


                        $("#dealers_area").append(`
                            <div class="col-12 col-md-6 mb-4" style="min-height:315px">
                            <div class="card border-0 shadow" style="height:100%">
                                <div class="card-header bg-danger text-white d-flex align-items-center">
                                     <iconify-icon style="font-size:23px" icon="uil-store"></iconify-icon>
                                    <h5 style="font-size:15px" class="card-title mb-0 ms-1 text-capitalize">${element.bayi_adi}</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="game-icons:modern-city"></iconify-icon> Şehir:</strong></div>
                                        <div class="col-md-7 text-capitalize">${ typeof element.SehirAd != 'object' ? element.SehirAd : '-' }</div>
                                    </div>
                                    <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-location-point"></iconify-icon> Adresi:</strong></div>
                                        <div class="col-md-7 text-capitalize">${ typeof element.adres != 'object' ? element.adres : '-' }</div>
                                    </div>
                                      <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="mdi:user"></iconify-icon> Yetkili Adı:</strong></div>
                                        <div class="col-md-7 text-capitalize">${ typeof element.yetkili_adi != 'object' ? element.yetkili_adi : '-' }</div>
                                    </div>
                                    <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-phone"></iconify-icon> Telefon Numarası:</strong></div>
                                        <div class="col-md-7 text-capitalize">${ typeof element.telefon != 'object' ? element.telefon : '-' } ${ typeof element.telefon_2 != 'object' ? ' - ' +element.telefon_2 : ''}</div>
                                    </div>
                                    <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-print"></iconify-icon> Faks Numarası:</strong></div>
                                        <div class="col-md-7 text-capitalize">${ typeof element.faks != 'object' ? element.faks : '-' }</div>
                                    </div>
                                    <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-envelope"></iconify-icon> E-Posta Adresi:</strong></div>
                                        <div class="col-md-7">${ typeof element.email != 'object' ? element.email : '-' }</div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-globe"></iconify-icon> Web Adresi:</strong></div>
                                        <div class="col-md-7">${ typeof element.site != 'object' ? element.site : '-' }</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    `);
                        @else

                        $("#dealers_area").append(`
                            <div class="col-12 col-md-6 mb-4" style="min-height:315px">
                            <div class="card border-0 shadow">
                                <div class="card-header bg-danger text-white d-flex align-items-center">
                                     <iconify-icon style="font-size:23px" icon="uil-store"></iconify-icon>
                                    <h5 style="font-size:15px" class="card-title mb-0 ms-1 text-capitalize">${ typeof element.SehirAd != 'object' ? element.SehirAd : '-' }</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="game-icons:modern-city"></iconify-icon> Province:</strong></div>
                                        <div class="col-md-7 text-capitalize">${ typeof element.adres != 'object' ? element.adres : '-' }</div>
                                    </div>
                                    <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-location-point"></iconify-icon> Address:</strong></div>
                                        <div class="col-md-7 text-capitalize">${ typeof element.adres != 'object' ? element.adres : '-' }</div>
                                    </div>
                                      <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="mdi:user"></iconify-icon> Authorized Name:</strong></div>
                                        <div class="col-md-7 text-capitalize">${ typeof element.yetkili_adi != 'object' ? element.yetkili_adi : '-' }</div>
                                    </div>
                                    <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-phone"></iconify-icon> Phone number:</strong></div>
                                        <div class="col-md-7 text-capitalize">${ typeof element.telefon != 'object' ? element.telefon : '-' } ${ typeof element.telefon_2 != 'object' ? ' - ' +element.telefon_2 : ''}</div>
                                    </div>
                                    <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-print"></iconify-icon> Fax Number:</strong></div>
                                        <div class="col-md-7 text-capitalize">${ typeof element.faks != 'object' ? element.faks : '-' }</div>
                                    </div>
                                    <div class="row mb-2">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-envelope"></iconify-icon> E-mail address:</strong></div>
                                        <div class="col-md-7">${ typeof element.email != 'object' ? element.email : '-' }</div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-5"><strong><iconify-icon icon="uil-globe"></iconify-icon> Web address:</strong></div>
                                        <div class="col-md-7 ">${ typeof element.site != 'object' ? element.site : '-' }</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        `);
                        @endif




                    });





                });






            }
        });




    }
</script>
@endsection