@extends('layouts.app')
@section('content')
<?php
function tr_seo($text)
{
    $find = ['Ç', 'Ş', 'Ğ', 'Ü', 'İ', 'Ö', 'ç', 'ş', 'ğ', 'ü', 'ö', 'ı', '+', '#'];
    $replace = ['c', 's', 'g', 'u', 'i', 'o', 'c', 's', 'g', 'u', 'o', 'i', 'plus', 'sharp'];
    $text = strtolower(str_replace($find, $replace, $text));
    $text = preg_replace('@[^A-Za-z0-9\-_\.\+]@i', ' ', $text);
    $text = trim(preg_replace('/\s+/', ' ', $text));
    $text = str_replace(' ', '-', $text);

    return $text;
}
function generateBreadcrumbListMarkup($data)
{
    $markup = '<div itemscope itemtype="http://schema.org/BreadcrumbList" style="width:100%"><ul class="brul">
                        
                        <li itemprop="itemListElement" itemscope="" itemtype="http://schema.org/ListItem"><a itemprop="item" href="/"><span itemprop="name">Anasayfa</span></a><meta itemprop="position" content="0"></li>
                        
                        ';
    $count = count($data);
    foreach ($data as $index => $item) {
        $markup .= '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem">';
        if ($item->url != '#') {
            $markup .= '<a itemprop="item" href="/urun/' . $item->url . '">';
        }
        $markup .= '<span itemprop="name">' . ($index === $count - 1 ? ucfirst($item->menuTitle) : (App::getLocale() == 'tr' ? ucfirst($item->menuTitle) : ucfirst($item->menuTitleEn))) . '</span>';
        if ($item->url !== '#') {
            $markup .= '</a>';
        }
        $markup .= '<meta itemprop="position" content="' . ($index + 1) . '" />';
        $markup .= '</li>';
    }
    $markup .= '</ul></div>';
    return $markup;
}

?>
<style>
    .barMenu {
        overflow-x: auto;
        overflow-y: hidden;
    }

    .barMenu a {
        display: block;
        text-decoration: none;
        color: #333;
        height: 60px;
        display: flex;
        align-items: center;
        padding: 0px 6px;
        text-align: center;
        font-size: 14px;
        -webkit-transition: all .5s ease-in-out;
        -moz-transition: all .5s ease-in-out;
        -o-transition: all .5s ease-in-out;
        transition: all .5s ease-in-out;
        border-right: 1px solid #eeeeeec4;
        color: #333;
    }

    .barMenu a:last-child {
        border: none;
    }

    .barMenu a:hover {
        color: #fff;
        background-color: #333;
    }


    .brcrumb {
        background-image: url('/uploads/urunlerimiz.jpg');
        height: 250px;
        background-color: #000 !important;
        background-size: cover;

        background-position: center center;

    }

    .brcrumb_content {
        position: absolute;
        bottom: 20px;
        left: 1%;

        height: 30px;
        background-color: #fff;
        padding: 10px;
        border-radius: 2px;
        display: flex;
        align-items: center;
        font-weight: 500;
        border: 1px solid #ddd;
        -webkit-transition: all .5s ease-in-out;
        -moz-transition: all .5s ease-in-out;
        -o-transition: all .5s ease-in-out;
        transition: all .5s ease-in-out;
    }

    .brcrumb_content:hover {
        background-color: #fff;
        border: 1px solid #fff;
    }

    .brcrumb_content ul {
        padding: 0;
        margin: 0;
        display: flex;
        align-items: center;
        justify-content: center;

    }

    .brcrumb_content ul li {
        display: block;
        margin-right: 5px;
        position: relative;
    }

    .brcrumb_content ul li::after {
        content: '/';
        height: 15px;
        width: 20px;
        display: block;
        position: absolute;
        z-index: 2;
        right: -13px;
        top: 1px;
        background-repeat: no-repeat;
        color: #ddd;

    }

    .brcrumb_content ul li:last-child::after {
        content: ' ';
        background-image: none;
        height: 15px;
        width: 20px;
        display: block;
        position: absolute;
        z-index: 2;
        right: -10px;
        top: 5px;

    }

    .brcrumb_content ul li a {
        margin-right: 10px;
        text-decoration: none;
        color: #333;
        font-weight: 400;
        font-size: 13px
    }


    .brcrumb_content li:last-child a {
        color: #f22613;
    }

    .card {
        -webkit-transition: all .5s ease-in-out;
        -moz-transition: all .5s ease-in-out;
        -o-transition: all .5s ease-in-out;
        transition: all .5s ease-in-out;
        height: 325px;
        cursor: pointer;
        overflow: hidden;
    }

    .card:hover {
        border: 1px solid transparent;
        box-shadow: rgba(0, 0, 0, 0.16) 0px 10px 36px 0px, rgba(0, 0, 0, 0.06) 0px 0px 0px 1px;
    }

    .card img {
        -webkit-transition: all 1s ease-in-out;
        -moz-transition: all 1s ease-in-out;
        -o-transition: all 1s ease-in-out;
        transition: all 1s ease-in-out;
        height: 200px;
        width: auto !important;
    }

    .card-image {
        height: 200px;
        overflow: hidden;
        text-align: center;
    }

    .card:hover img {
        scale: 1.05;
    }

    .card:hover .card-title {
        color: #333;
    }

    .card:hover button {
        background-color: #f22613;
        color: white;
        border-color: #f22613;
    }

    .product a {
        text-decoration: none;
        color: #333;
    }

    .title-box {
        width: 100%;
        position: relative;
        height: 50px;
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
    }

    .card-title {
        color: #f22613;
        -webkit-transition: all .5s ease-in-out;
        -moz-transition: all .5s ease-in-out;
        -o-transition: all .5s ease-in-out;
        transition: all .5s ease-in-out;
    }

    @media only screen and (max-width: 600px) {
        .brcontainer {
            margin-bottom: 120px;
        }

        .brcrumb_content {
            width: 100%;
            height: auto;
            justify-content: center;
            align-items: center;
            bottom: -40%;
            background: transparent;
            border: 1px solid #eee;
            left: 0px;

        }

        .brcrumb_content ul {


            width: 100%;
            align-items: unset;
            flex-wrap: wrap;
            justify-content: flex-start
        }

        .brcrumb_content ul li {}

        .brcrumb_content ul li:last-child {
            border-bottom: none;
        }


        .brcrumb_content ul li::after {
            top: -1px;
            right: -14px;

        }
    }
</style>
<div class="container-fluid brcontainer">
    <div class="row">
        <div class="col-12 brcrumb">
            <div class="container" style="position: relative;height:100%;">
                <div class="brcrumb_content">
                    {!! generateBreadcrumbListMarkup($parent_categories) !!}
                </div>
            </div>
        </div>
    </div>
</div>
<div class="container" itemscope itemtype="http://schema.org/Product">
    <div class="row mt-5">
        <div class="col-12">
            <div class="master_title">
                <h1 itemprop="name">{{ App::getLocale() == 'tr' ? $data->product_title : $data->product_title_en }}
                </h1>
            </div>

        </div>
    </div>
    <div class="row mt-3 mb-3" style="min-height:600px;">


        <div class="col-12 col-md-4  text-center">
            <img itemprop="image" style="width:100%;border:1px solid #ddd;overflow:hidden;border-radius:4px;" alt="{{$data->product_title}}" src="/uploads/{{ $data->product_images }}" alt="">
        </div>


        <div class="col-12 col-md-8 p-0 mt-4 mt-md-0" itemprop="description">
            @if (App::getLocale() == 'tr')
            {!! $data->content !!}
            @else
            {!! $data->content_en !!}
            @endif
        </div>
    </div>

    <div class="row mb-5">
        <div class="col-12 mb-2">
            <div class="master_title">
                <h1>{{ App::getLocale() == 'tr' ? 'Benzer Ürünler' : 'Similar products' }}</h1>
            </div>

        </div>
        @foreach ($get_category_product as $item)
        <div class="col-md-3 mb-4 col-12 p-4 p-md-2 product">
            <a href="{{ $category_url }}{{ tr_seo($item->product_title_seo) }}">
                <div class="card" style="width: 100%">
                    <div class="card-image">
                        <img src="/uploads/{{ $item->product_images }}" class="card-img-top" alt="{{ $item->product_title }}">
                    </div>

                    <div class="card-body">
                         <div class="title-box">
                            <h7 class="card-title">
                                {{ App::getLocale() == 'tr' ? $item->product_title : $item->product_title_en }}
                            </h7>

                        </div>
                         <button class="btn btn-outline-secondary" style="width:100%">{{ __('Detaylı Bilgi') }}</button>
                    </div>
                </div>
            </a>
        </div>
        @endforeach

    </div>


</div>
@endsection