@extends('layouts.app')
@section('content')
    @php
        function turkce_seo($text)
        {
            $find = ['Ç', 'Ş', 'Ğ', 'Ü', 'İ', 'Ö', 'ç', 'ş', 'ğ', 'ü', 'ö', 'ı', '+', '#'];
            $replace = ['c', 's', 'g', 'u', 'i', 'o', 'c', 's', 'g', 'u', 'o', 'i', 'plus', 'sharp'];
            $text = strtolower(str_replace($find, $replace, $text));
            $text = preg_replace('@[^A-Za-z0-9\-_\.\+]@i', ' ', $text);
            $text = trim(preg_replace('/\s+/', ' ', $text));
            $text = str_replace(' ', '-', $text);
        
            return $text;
        }
        
        function generateMenu($json)
        {
            $menuItems = json_decode($json);
            $groupedItems = [];
        
            // Parenti 0 olanları grupla
            foreach ($menuItems as $menuItem) {
                if ($menuItem->menuParent == 0) {
                    $groupedItems[$menuItem->id] = $menuItem;
                }
            }
        
            $menu = '<ul class="list-group list-group-flush">';
        
            // Başlık olarak parenti 0 olanları listele
            foreach ($groupedItems as $menuItem) {
                $menu .= '<li class="list-group-item"><strong>';
                if (App::getLocale() == 'tr') {
                    $menu .= $menuItem->menuTitle;
                } else {
                    $menu .= $menuItem->menuTitleEn;
                }
                $menu .= '</strong></li>';
        
                // Çocukları listele
                foreach ($menuItems as $childItem) {
                    if ($childItem->menuParent == $menuItem->id) {
                        $menu .=
                            '<li class="list-group-item"> <a class="leftSideLink d-flex align-items-center" href="/urun/' .
                            turkce_seo($childItem->menuTitle) .
                            '">
                    <iconify-icon icon="bx:chevron-right"></iconify-icon>';
                        if (App::getLocale() == 'tr') {
                            $menu .= '<span>' . $childItem->menuTitle . '</span>';
                        } else {
                            $menu .= '<span>' . $childItem->menuTitleEn . '</span>';
                        }
                        $menu .= '</a></li>';
                    }
                }
            }
            $title = (App::getLocale() == 'tr') ? 'Ürün Kategorileri' : 'Product Category';
            $menu .= '</ul>';
            $menu = "<div class='col' style='background-color:#f22613;color:white;height:50px;line-height:50px;text-align:center;font-weight:700'>". $title ."</div>" . $menu;
            return $menu;
        }
        
    @endphp
    <style>
        .three h1 {
            font-size: 28px;
            font-weight: 500;
            letter-spacing: 0;
            line-height: 1.5em;
            padding-bottom: 15px;
            position: relative;

        }

        .three h1:before {
            content: "";
            position: absolute;
            left: 0;
            bottom: 0;
            height: 5px;
            width: 55px;
            background-color: #f22613;
            z-index: 2;

        }


        .three h1:after {
            content: "";
            position: absolute;
            left: 0;
            bottom: 1px;
            height: 2px;
            width: 95%;
            border-bottom: 2px dashed #d1d1d1;
        }

        .brcrumb {
            background-image: url('/uploads/urunlerimiz2.jpg');
            height: 250px;
            background-color: #000 !important;
            background-size: cover;

            background-position: center center;

        }

 
    .brcrumb_content {
        position: absolute;
        bottom: 20px;
        left: 1%;

        height: 30px;
        background-color: #fff;
        padding: 10px;
        border-radius: 2px;
        display: flex;
        align-items: center;
        font-weight: 500;
        border: 1px solid #ddd;
        -webkit-transition: all .5s ease-in-out;
        -moz-transition: all .5s ease-in-out;
        -o-transition: all .5s ease-in-out;
        transition: all .5s ease-in-out;
    }

    .brcrumb_content:hover {
        background-color: #fff;
        border: 1px solid #fff;
    }

    .brcrumb_content ul {
        padding: 0;
        margin: 0;
        display: flex;
        align-items: center;
        justify-content: center;

    }

    .brcrumb_content ul li {
        display: block;
        margin-right: 5px;
        position: relative;
    }

    .brcrumb_content ul li::after {
        content: '/';
        height: 15px;
        width: 20px;
        display: block;
        position: absolute;
        z-index: 2;
        right: -13px;
        top: 1px;
        background-repeat: no-repeat;
        color: #adadad;

    }

    .brcrumb_content ul li:last-child::after {
        content: ' ';
        background-image: none;
        height: 15px;
        width: 20px;
        display: block;
        position: absolute;
        z-index: 2;
        right: -10px;
        top: 5px;

    }

    .brcrumb_content ul li a {
        margin-right: 10px;
        text-decoration: none;
        color: #333;
        font-weight: 400;
        font-size: 13px
    }


    .brcrumb_content li:last-child a {
        color: #f22613;
    }

    @media only screen and (max-width: 600px) {
        ._icerik {
            min-height: 100px;
        }

        .brcontainer {
            margin-bottom: 120px;
        }

        .brcrumb_content {
            width: 100%;
            height: auto;
            justify-content: center;
            align-items: center;
            bottom: -40%;
            background: transparent;
            border: 1px solid #eee;
            left: 0px;

        }

        .brcrumb_content ul {


            width: 100%;
            align-items: unset;
            flex-wrap: wrap;
            justify-content: flex-start
        }

        .brcrumb_content ul li {}

        .brcrumb_content ul li:last-child {
            border-bottom: none;
        }


        .brcrumb_content ul li::after {
            top: -1px;
            right: -14px;

        }

        ._content {
            margin-top: 50px !important;
        }
    }


        .leftSideLink {
            color: #333;
            text-decoration: none
        }
        .card {
            -webkit-transition: all .5s ease-in-out;
            -moz-transition: all .5s ease-in-out;
            -o-transition: all .5s ease-in-out;
            transition: all .5s ease-in-out;
            height: 460px;
            cursor: pointer;
            overflow: hidden;
        }

        .card:hover {
            border: 1px solid transparent;
            box-shadow: rgba(0, 0, 0, 0.16) 0px 10px 36px 0px, rgba(0, 0, 0, 0.06) 0px 0px 0px 1px;
        }

        .card img {
            -webkit-transition: all 1s ease-in-out;
            -moz-transition: all 1s ease-in-out;
            -o-transition: all 1s ease-in-out;
            transition: all 1s ease-in-out;
            height: 200px;
            width: auto !important;
        }

        .card-image {
            height: 200px;
            overflow: hidden;
            text-align: center;
        }

        .card:hover img {
            scale: 1.05;
        }

        .card:hover .card-title {
            color: #333;
        }

        .card:hover button {
            background-color: #f22613;
            color: white;
            border-color: #f22613;
        }

        .product a {
            text-decoration: none;
            color: #333;
        }

        .title-box {
            width: 100%;
            position: relative;
            height: 50px;
            border-bottom: 1px solid #ddd;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
        }

        .card-title {
            color: #f22613;
            -webkit-transition: all .5s ease-in-out;
            -moz-transition: all .5s ease-in-out;
            -o-transition: all .5s ease-in-out;
            transition: all .5s ease-in-out;
            font-size: 0.97em !important;
        }
    </style>

    <div class="container-fluid">
    <div class="row">
        <div class="col-12 brcrumb">
            <div class="container" style="position: relative;height:100%;">
                <div class="brcrumb_content">
                    <div itemscope="" itemtype="http://schema.org/BreadcrumbList" style="width:100%">
                        <ul class="brul">

                            <li itemprop="itemListElement" itemscope="" itemtype="http://schema.org/ListItem"><a itemprop="item" href="/"><span itemprop="name">{{ __('Anasayfa') }}</span></a>
                                <meta itemprop="position" content="0">
                            </li>

                            <li itemprop="itemListElement" itemscope="" itemtype="http://schema.org/ListItem"><a itemprop="item" href="#"><span itemprop="name">{{ App::getLocale() == 'tr' ? $category->menuTitle : $category->menuTitleEn }}</span></a>
                                <meta itemprop="position" content="1">
                            </li>


                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
    <div class="container my-5">
        <div class="row" style="min-height:600px">
            <div class="col-md-3 col-12  order-2 order-md-1 py-3" style="border:1px solid #ddd;">
                {!! generateMenu(json_encode($category_all)) !!}
            </div>
            <div class="col-md-9 ps-0 ps-md-5 col-12 order-1  order-md-2">

                <div class="_content row   p-4 p-md-0">
                    <div class="col-12">
                        <div class="master_title p-0 m-0">
                            <h1>{{ App::getLocale() == 'tr' ? $category->menuTitle : $category->menuTitleEn }}</h1>
                        </div>
                    </div>
                </div>

            <?php
                function productGenerator($item)
                {
                  

                    $html = '<div class="col-md-4 mb-4 col-12 p-4 p-md-2 product">' . PHP_EOL;
                    $html .= '<a href="'. $item->purl . '">' . PHP_EOL;
                    $html .= '<div class="card" style="width: 100%">' . PHP_EOL;
                    $html .= '<div class="card-image">' . PHP_EOL;
                    $html .= '<img src="/uploads/' . $item->product_images . '" class="card-img-top" alt="' . $item->product_title . '">' . PHP_EOL;
                    $html .= '</div>' . PHP_EOL;
                    $html .= '<div class="card-body">' . PHP_EOL;
                    $html .= '<div class="title-box">' . PHP_EOL;
                    $html .= '<h5 class="card-title">' . PHP_EOL;
                    $html .= App::getLocale() == 'tr' ? $item->product_title : $item->product_title_en;
                    $html .= '</h5>' . PHP_EOL;
                    $html .= '</div>' . PHP_EOL;
                    $html .= '<p class="card-text d-block mt-2" style="display: block;height:105px;overflow:hidden;text-align:justify">' . PHP_EOL;
                    $html .= substr(str_replace('&nbsp;', '', strip_tags(App::getLocale() == 'tr' ? $item->content : $item->content_en)), 0, 135);
                    $html .= strlen(strip_tags($item->content)) > 135 ? '...' : '';
                    $html .= '</p>' . PHP_EOL;
                    $html .= '<button class="btn btn-outline-secondary" style="width:100%">' . __('Detaylı Bilgi') . '</button>' . PHP_EOL;
                    $html .= '</div>' . PHP_EOL;
                    $html .= '</div>' . PHP_EOL;
                    $html .= '</a>' . PHP_EOL;
                    $html .= '</div>' . PHP_EOL;
                
                    return $html;
                }
                ?>


                <div class="row">
                    @foreach ($exportData as $data)
                        @if($data['category_id'] != $current_category)
                            <div class="col-12">
                                <div style="height:40px;border-bottom:2px dashed #ddd;color:#333;font-weight:600;borde-radius:4px;"
                                    class="d-flex justify-content-start align-items-center p-4 p-md-0 my-4 col-12">
                                    <iconify-icon style="font-size:50px;color:#f22613;margin-left:-11px;"
                                        icon="ic:baseline-keyboard-double-arrow-right"></iconify-icon>
                                    <h5 class="p-0 m-0">
                                        {{ App::getLocale() == 'tr' ? $data['menuTitle'] : $data['menuTitleEn'] }}</h5>
                                </div>
                            </div>
                        @endif
                        @foreach ($data['urunler'] as $key => $item)
                            @php $item = $item[0] @endphp
                            @if ($item->cat_id != $current_category)
                                {!! productGenerator($item) !!}
                            @endif
                        @endforeach
                    @endforeach
                    @if(array_key_exists($current_category, $exportData))
                        <div class="col-12"></div>
                        @foreach ($exportData[$current_category]['urunler'] as $key => $item)
                            @php $item = $item[0] @endphp
                            {!! productGenerator($item) !!}
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
