@extends('layouts.app')
@section('content')

@php
function formatFileSize($size)
{
    $units = array('B', 'KB', 'MB', 'GB', 'TB');
    $i = 0;
    while ($size >= 1024 && $i < 4) {
        $size /= 1024;
        $i++;
    }
    return round($size, 2) . ' ' . $units[$i];
}

@endphp


    <style>
        .list-group-item {
            border: none;
            background-color: #f5f5f5;
            border-bottom: 1px solid #d6d4d4;
        }
        .list-group-item:hover {
            background-color: #e5e5e5;
        }
        .list-group-item a {
            color: #000;
            display: block;
        }
        .list-group-item a:hover {
            color: #000;
        }
        .list-group-item a:active {
            color: #000;
        }
        .list-group-item a:focus {
            color: #000;
        }
        .list-group-item a:visited {
            color: #000;
        }
        .list-group-item a:link {
            color: #000;
        }
    </style>
     <div class="container my-5">
        <div class="row">
            <div class="col-md-3 col-12 p-0 shadow border text-center" style="min-height:400px; background-color: #f5f5f5;">
                <a hre="/e-ysiid/portal">
                    <h6 class="strong d-flex justify-content-center align-items-center mb-0"
                        style="display:block;background-color:#474747;color:#fff;height:71px;box-shadow: 0 7px 7px -8px;">Üye
                        Paneli</h6>
                </a>
                <ul class="list-group list-group-flush text-start">

                    <li class="list-group-item"><a class="btn-link" href="/e-ysiid/uye-bilgilerim">Üye Bilgilerim</a></li>
                    <li class="list-group-item"><a class="btn-link" href="/e-ysiid/yuklenen-dosyalar">Yüklenen Dosyalar</a>
                    </li>
                    <li class="list-group-item"><a class="btn-link" href="/e-ysiid/odemeler">Ödemeler</a></li>
                      <li class="list-group-item"><a class="btn-link" href="/e-ysiid/sifre-degistir">Şifre Değiştir</a></li>
                       <li class="list-group-item"><a class="btn-link" href="/e-ysiid/logout">Oturumu Kapat</a></li>
                </ul>
            </div>
            <div class="col-md-9 col-12 px-4" style="min-height:400px">
                <div class="w-100   h-100">
                    <div class="border-bottom text-right d-flex justify-content-between mb-2">  
                        <div style="font-weight:600;color:#000">
                        {{ ($uye->isLegal == 'tuzel') ? $uye->corporate_name : $uye->name . ' ' . $uye->surname }}
                        </div> 
                        <div>#{{$uye->id}}</div>
                       

                    </div>
                    
                     <div class="col-12 mt-2   p-5">
                  

                     <div class="col-12">
                        <label class="d-block text-danger w-100 border-bottom pb-2" style="font-size: 23px;">
                        <strong>Yüklenen Dosyalar</strong>
                        </label>
                    </div>

                       

                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th scope="col">Dosya Adı</th>
                                    <th scope="col">Dosya Tipi</th>
                                    <th scope="col">Dosya Boyutu</th>
                                    <th scope="col">Yükleme Tarihi</th>
                                 
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($files as $file)
                              
                              
                                    <tr>
                                        <td><a download style="color:blue !important" href=" {{ $file['relative_path']}}">{{ $file['file_name']}}</a></td>
                                        <td>{{ $file['file_type']}}</td>
                                        <td>{{ formatFileSize($file['file_size'])}}</td>
                                        <td>{{ $file['upload_date']}}</td>
                                      
                                       
                                </tr>


                                @endforeach
                            </tbody>
                            </table>
                     </div>
                </div>
            </div>
        </div>
    </div>
@endsection
