@extends('layouts.app')
@section('content')
    <div class="container mt-5 ">
        <div class="row mt-3">
            <div class="col-12">
                <h1 class="display-6">Duyuru Listesi</h1>
                <hr>
            </div>
        </div>

        <div class="row my-4" style="min-height:700px">
            <div class="col-12">
                <div class="accordion" id="accordionExample">




                    @foreach ($duyurular as $key => $duyuru)
                        @php
                            
                            $tarih_str = $duyuru->date_time;
                            $tarih_unix = strtotime($tarih_str);
                            $tarih_formatli = date('d.m.Y', $tarih_unix);
                           
                        @endphp


                        <div class="accordion-item">
                            <h2 class="accordion-header" id="d_{{ $duyuru->id }}">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapse_{{ $duyuru->id }}" aria-expanded="false"
                                    aria-controls="collapse_{{ $duyuru->id }}">
                                    <span class="text-danger"><strong>{{ $duyuru->title }}</strong></span>&nbsp;-&nbsp;({{$tarih_formatli}})
                                  

                                </button>
                            </h2>
                            <div id="collapse_{{ $duyuru->id }}"
                                class="border-top accordion-collapse collapse {{ $key == 0 ? ' show ' : '' }} "
                                aria-labelledby="d_{{ $duyuru->id }}" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    {{ $duyuru->title_box }}}
                                </div>
                            </div>
                        </div>
                    @endforeach


                    {{-- <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                Accordion Item #2
                            </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <strong>This is the second item's accordion body.</strong> It is hidden by default, until
                                the collapse plugin adds the appropriate classes that we use to style each element. These
                                classes control the overall appearance, as well as the showing and hiding via CSS
                                transitions. You can modify any of this with custom CSS or overriding our default variables.
                                It's also worth noting that just about any HTML can go within the
                                <code>.accordion-body</code>, though the transition does limit overflow.
                            </div>
                        </div>
                    </div>
                    --}}




















                </div>
            </div>

        </div>
    </div>
@endsection
