@extends('layouts.app')
@section('content')
<!-- Ionicons CSS dosyası -->
<link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">


<!-- Ionicons JS dosyası -->
<script src="https://code.ionicframework.com/ionicons/2.0.1/js/ionicons.min.js"></script>


<style>
    .barMenu {
        overflow-x: auto;
        overflow-y: hidden;
    }

    .barMenu a {
        display: block;
        text-decoration: none;
        color: #333;
        height: 60px;
        display: flex;
        align-items: center;
        padding: 0px 6px;
        text-align: center;
        font-size: 14px;
        -webkit-transition: all .5s ease-in-out;
        -moz-transition: all .5s ease-in-out;
        -o-transition: all .5s ease-in-out;
        transition: all .5s ease-in-out;
        border-right: 1px solid #eeeeeec4;
        color: #333;
    }

    .barMenu a:last-child {
        border: none;
    }

    .barMenu a:hover {
        color: #fff;
        background-color: #333;
    }


    .brcrumb {

        height: 250px;
        background-color: #000 !important;
        background-size: cover;

        background-position: center center;
        background-image: url('/assets/images/insan-kaynaklari.jpg');
    }

    .brcrumb_content {
        position: absolute;
        bottom: 20px;
        left: 1%;
        height: 30px;
        background-color: #ddd;
        padding: 10px;
        border-radius: 2px;
        display: flex;
        align-items: center;
        font-weight: 700;
        border: 1px solid #ddd;
        -webkit-transition: all .5s ease-in-out;
        -moz-transition: all .5s ease-in-out;
        -o-transition: all .5s ease-in-out;
        transition: all .5s ease-in-out;
    }

    .brcrumb_content:hover {
        background-color: #fff;
        border: 1px solid #fff;
    }

    .brcrumb_content ul {
        padding: 0;
        margin: 0;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .brcrumb_content ul li {
        display: block;
        margin-right: 5px;
        position: relative;
    }

    .brcrumb_content ul li:first-child::after {
        content: ' ';
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24'%3E%3Cpath d='M16.5 13.1L7.6 22c-.8-.8-.8-2 0-2.8l6.1-6.1-6-6.1c-.8-.8-.8-2 0-2.8l8.8 8.9z'/%3E%3C/svg%3E");
        height: 15px;
        width: 20px;
        display: block;
        position: absolute;
        z-index: 2;
        right: -10px;
        top: 5px;


    }

    .brcrumb_content ul li a {
        margin-right: 10px;
        text-decoration: none;
        color: #333;
    }

    .brcrumb_content .active {
        color: #f22613;
    }

    .active-menu {
        background-color: #f22613;
    }



    .w-5 {
        display: none;
    }

    .news_cover {
        background-repeat: no-repeat;
        background-size: cover;
        background-position: center;
    }


    .background-image {
        width: 100%;
        height: 100%;
        background-size: cover;
        background-position: center;
        position: absolute;
        top: 0;
        left: 0;
        transition: transform 0.7s ease;
    }

    .background-image:hover {
        transform: scale(1.1);
    }









    /* galewri css kısmı */
</style>


{{-- @php  print_r($blog); exit; @endphp --}}
@if (App::getLocale() == 'tr')
<div style="min-height:600px">
    <div class="mb-5">
        <div class="col-12 brcrumb">
            <div class="container" style="position: relative;height:100%;">
                <div class="brcrumb_content">
                    <ul>
                        <li><a href="/">{{ App::getLocale() == 'tr' ? 'Anasayfa' : 'Home' }}</a></li>
                        <li><a class="active" href="javascript:;">{{ App::getLocale() == 'tr' ? 'Blog' : 'Blog' }}</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        {{-- <iframe
                    src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d7274.038362913563!2d32.523940882049295!3d39.95578389599414!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x14d3252f90764439%3A0xb1ba73aac64e71d0!2sNETELSAN!5e0!3m2!1str!2str!4v1677569130887!5m2!1str!2str"
                    width="100%" height="300" style="border:0;" allowfullscreen="" loading="lazy"
                    referrerpolicy="no-referrer-when-downgrade"></iframe> --}}

        <div class="container-fluid d-flex align-items-center shadow d-none d-md-block mb-4" style="background-color: #fff;height:60px;margin-top:-5px;">
            <div class="container">
                <div class="col-12 d-flex justify-content-start barMenu">
                    {{-- <a class="active "
                                style="{{ $page->target == 'haberler' ? 'background-color:red; color:#fff' : '' }}"
                    href="/page/haberler" aria-current="true">
                    Haberler
                    </a> --}}


                </div>
            </div>
        </div>




        <div class="container">
            <div class="row mb-5">
                <div class="col-12">
                    <div class="master_title">
                        <h1>Blog</h1>
                    </div>
                </div>

            </div>






            <div class="col-md-12 ps-2 col-12  ps-0 ps-md-4" style="margin-bottom: 100px">


                {{-- @php print_r($news2[0]);  @endphp --}}


                <div class="container mb-5">
                    <div class="swiper mySwiperblog">
                        <div class="swiper-wrapper">
                            @foreach ($blog2 as $vitrin)

                            @php
                            $thumb_blog = '/uploads/thumb_'.$vitrin['image_path'];
                            if(!file_exists(public_path('uploads/thumb_'.$vitrin['image_path']))){
                            $thumb_blog = '/uploads/'.$vitrin['image_path'];
                            };
                            @endphp



                            <div class="swiper-slide">
                                <div class="card" style="width: 100%; height:440px;">
                                    <div style="background-image:url({{$thumb_blog}}); min-height:200px; background-repeat:no-repeat; background-size:cover; background-position:center center"></div>

                                    <div class="card-body d-flex flex-column">
                                        <h5 class="card-title">
                                            {{ App::getLocale() == 'tr' ? $vitrin->title : $vitrin->title_en }}
                                        </h5>
                                        <p class="card-text">
                                            {{ substr(str_replace('&nbsp;', '', strip_tags(App::getLocale() == 'tr' ? $vitrin->content : $vitrin->content_en)), 0, 100) }}{{ '...' }}
                                        </p>
                                        <a href="/blog/{{$vitrin->slug}}" class="btn btn-danger mt-auto">Daha Fazla</a>
                                    </div>
                                </div>

                            </div>
                            @endforeach



                        </div>
                        <div class="swiper-button-next"></div>
                        <div class="swiper-button-prev"></div>
                    </div>
                </div>




                <div class="container">
                <div class="row justify-content-center mt-5">



                    @foreach ($blog as $key => $newsItem)

                    @php
                    $thumb_blog = '/uploads/thumb_'.$newsItem['image_path'];
                    if(!file_exists(public_path('uploads/thumb_'.$newsItem['image_path']))){
                    $thumb_blog = '/uploads/'.$newsItem['image_path'];
                    };
                    @endphp



                    <div class="col-6">
                        <a href="/blog/{{ $newsItem['slug'] }}" style="text-decoration:none!important;">

                            <div class="card mx-2 mx-md-0 mb-4 wow fadeInUp" style="max-width: 100%; box-shadow: rgba(0, 0, 0, 0.16) 0px 10px 36px 0px, rgba(0, 0, 0, 0.06) 0px 0px 0px 1px;">
                                <div class="row g-0 overflow-hidden">
                                    <div class="col-12 col-md-4 news_cover " style="background-image:url({{ $thumb_blog }}); min-height:200px;">
                                    </div>
                                    <div class="col-12 col-md-8">
                                        <div class="card-body" style="min-height:200px;">
                                            <h5 class="card-title text-capitalize" style="color:#f22613; ">
                                                {{ App::getLocale() == 'tr' ? $newsItem['title'] : $newsItem['title_en'] }}
                                            </h5>
                                            <hr style="color:#ddd;">
                                            <p class="card-text" style="color:#000;">
                                                {{ substr(str_replace('&nbsp;', '', strip_tags(App::getLocale() == 'tr' ? $newsItem['content'] : $newsItem['content_en'])), 0, 135) }}{{ '...' }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                    @endforeach



                    <center> {{ $blog->onEachSide(0)->links() }} </center>
                </div>
                </div>

            </div>








        </div>

    </div>





</div>
@else
<div style="min-height:600px">
    <div class="mb-5">
        <div class="col-12 brcrumb">
            <div class="container" style="position: relative;height:100%;">
                <div class="brcrumb_content">
                    <ul>
                        <li><a href="/">{{ App::getLocale() == 'tr' ? 'Anasayfa' : 'Home' }}</a></li>
                        <li><a class="active" href="javascript:;">{{ App::getLocale() == 'tr' ? 'İnsan Kaynakları' : 'Human Resources' }}</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="container-fluid d-flex align-items-center shadow d-none d-md-block mb-4" style="background-color: #fff;height:60px;margin-top:-5px;">
            <div class="container">
                <div class="col-12 d-flex justify-content-start barMenu">
                    {{-- <a class="active"
                                style="{{ $page->target == 'haberler' ? 'background-color:red; color:#fff' : '' }}"
                    href="/page/haberler" aria-current="true">
                    News
                    </a> --}}
                </div>
            </div>
        </div>

        <div class="container">
            <div class="row mb-5">
                <div class="col-12">
                    <div class="master_title">
                        <h1>News</h1>
                    </div>
                </div>

            </div>
        </div>








    </div>
</div>
@endif


@endsection