@extends('admin.layouts.app')
@section('content')

<link href="/assets/node_modules/switchery/dist/switchery.min.css" rel="stylesheet" />
<script src="/assets/node_modules/switchery/dist/switchery.min.js"></script>
<div class="row page-titles">
    <div class="col-md-12">
        <h4 class="text-white">YSİİD</h4>
    </div>
    <div class="col-md-6">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Anasayfa</a></li>
            <li class="breadcrumb-item active">Menü Düzenle</li>
        </ol>
    </div>
    <div class="col-md-6 text-right">
        <form class="app-search d-none d-md-block d-lg-block">
            <input type="text" class="form-control" placeholder="Search &amp; enter">
        </form>
    </div>
</div>
@if(session()->has('success'))
    <div class="alert alert-success">
        {{ session()->get('success') }}
    </div>
@endif
<div class="card">
    <div class="card-header d-flex justify-content-between">
        <h4 class="card-title mt-2">Menü Düzenle</h4>
        <button type="button" class="btn btn-success" data-toggle="modal" data-target=".bd-example-modal-lg">Yeni Resim Ekle</button>
    </div>
    <div class="card-body">



        <div class="table-responsive">
            <table class="table color-table danger-table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Resim</th>
                        <th>Link</th>
                        <th>Sıralama</th>
                        <th>Aktif</th>
                        <th>Sil</th>
                    </tr>
                </thead>
                <tbody>
                    @php



                    @endphp
                    @foreach($sliders as $slider)

                    <tr>
                        <td>{{$slider->id}}</td>
                        <td><img src="../uploads/{{$slider->tr_path}}" alt="user" width="80" class="img-thumbnail"></td>
                        <td><a href="{{env('APP_URL')}}{{'/public/uploads/'}}{{$slider->tr_path}}">{{env('APP_URL')}}/public/uploads/{{$slider->tr_path}}</a></td>
                        <td width="20"><input class="form-control" type="number" value="{{$slider->order}}" id="example-number-input"></td>
                        <td width="20">
                            <input onchange="statusChanger(this)" data-id="{{$slider->id}}" type="checkbox" {{ ($slider->isActive == 1) ? ' checked="true" ' : '' }} class="js-switch" data-size="small" data-color="#009efb" style="display: none;" data-switchery="true">

                        </td>
                        <th><button class="mdi mdi-delete" onclick="del(this)" data-id="{{$slider->id}}" style="color:#cf1140;border: 0px !important;" type="button" title="Sil"></button></th>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>


    </div>
</div>

<!-- modal başlangıç -->



<!-- Large modal -->


<div class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content" style="background-color:#edebeb;">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Resim Bilgileri</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="{{ route('slider.Edit') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group row">
                        <label class="col-sm-3" for="url">URL</label>
                        <div class="col-sm-9">
                            <input type="text" id="url" name="url" placeholder="http://ornek.com/" class="form-control" required="">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-3" for="mobilurl">Resim Sırası</label>
                        <div class="col-sm-9">
                            <input class="form-control" name="order" style="width:60px;" type="number" value="1" id="example-number-input1">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-sm-3">
                            <label class="control-label">Slider Görüntüleri</label>
                            <strong>(850px*315px)</strong>
                        </div>
                        <div class="col-sm-9">
                            <div class="form-group">
                                <label for="exampleFormControlFile1">Resim Yükleyiniz...</label>
                                <input type="file" name="file" class="form-control-file" id="exampleFormControlFile1">
                            </div>
                        </div>
                    </div>
                    <!-- ingilizce resim yükleme yeri -->
                    <div class="form-group row">
                        <div class="col-sm-3">
                            <label class="control-label">İngilizce Slider Görüntüleri</label>
                            <strong>(850px*315px)</strong>
                        </div>
                        <div class="col-sm-9">
                            <div class="form-group">
                                <label for="exampleFormControlFile1">Resim Yükleyiniz...</label>
                                <input type="file" name="enfile" class="form-control-file" id="exampleFormControlFile2">
                            </div>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary">Yükle</button>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Kapat</button>

            </div>
        </div>
    </div>
</div>





<script>
    $('#myModal').on('shown.bs.modal', function() {
        $('#myInput').trigger('focus')
    });


    $(document).ready(function() {
        var elems = Array.prototype.slice.call(document.querySelectorAll('.js-switch'));
        $('.js-switch').each(function() {
            new Switchery($(this)[0], $(this).data());
        });
    });



    function del(e){
         var id  = $(e).attr('data-id');
  
            if (confirm('Silmek istediğinize emin misiniz?')) {
                $.ajax({
                    type: 'DELETE',
                    url: "{{ route('slider.Delete') }}",
                    data: {
                        '_token': $('meta[name="csrf-token"]').attr('content'),
                        'id': id
                    },
                    success: function (data) {
                        location.reload();
                    }
                });
            }
    
 

}
</script>








@endsection