@extends('admin.layouts.app')
@section('content')
<link rel="stylesheet" href="//cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
<script src="//cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<div class="row page-titles">
    <div class="col-md-12">
        <h4 class="text-white">YSİİD</h4>
    </div>
    <div class="col-md-6">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Anasayfa</a></li>
            <li class="breadcrumb-item active">YSİİD</li>
        </ol>
    </div>
    <div class="col-md-6 text-right">
        <form class="app-search d-none d-md-block d-lg-block">
            <input type="text" class="form-control" placeholder="Search &amp; enter">
        </form>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <table id="myTable" class="display">
                    <thead>
                        <tr>
                            <th>Log ID</th>
                            <th>İşlem</th>
                            <th>Yetkili Adı</th>
                            <th>Yetkili Soyadı</th>
                            <th>Firma Adı</th>
                            <th>IP Numarası</th>
                            <th>Zaman Damgası</th>
                            <th>İncele</th>
                        </tr>
                    </thead>
                    <tbody>
                    @foreach($log as $item)
                       <tr>
                            <th>{{$item->id}}</th>
                            <th>{{$item->islem}}</th>
                            <th>{{$item->name}}</th>
                            <th>{{$item->surname}}</th>
                            <th>{{$item->corporate_name}}</th>
                            <th>{{$item->ip}}</th>
                            <th>{{$item->created_at}}</th>
                            <th><a href="/admin/member/edit?id={{$item->user}}">Üyeyi İncele</a></th>
                          
                        </tr>
                    @endforeach
                        
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>

let oTable = $('#myTable').dataTable({
        "responsive": true,
        "dom": '<"html5buttons"B>lTfgitp',
        "language": {
        "url":"//cdn.datatables.net/plug-ins/1.13.4/i18n/tr.json"
         }
    });

    oTable.fnSort( [ [0,'desc'] ] );
</script>
@endsection