@extends('admin.layouts.app')
@section('content')
<link href="/assets/node_modules/switchery/dist/switchery.min.css" rel="stylesheet" />
<div class="row page-titles">
    <div class="col-md-12">
        <h4 class="text-white">YSİİD</h4>
    </div>
    <div class="col-md-6">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Anasayfa</a></li>
            <li class="breadcrumb-item active">YSİİD</li>
        </ol>
    </div>
    <div class="col-md-6 text-right">
        <form class="app-search d-none d-md-block d-lg-block">
            <input type="text" class="form-control" placeholder="Search &amp; enter">
        </form>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                @if(session('status'))
                <script>
                    $(document).ready(function() {
                        Swal.fire({
                            position: 'center-center',
                            type: 'success',
                            title: '{{session("status")}}',
                            showConfirmButton: false,
                            timer: 3000
                        })
                    });
                </script>

                @endif


                <div class="table-responsive">
                    <table class="table color-bordered-table red-bordered-table">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Sayfa Adı</th>
                                <th>Seo Adresi</th>
                                <th>Son Düzenlenme Tarihi</th>
                                <th>Aktif/Pasif</th>
                                <th>İşlem</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($pages as $page)
                            <tr>
                                <td><strong>{{$page->page_id}}</strong></td>
                                <td><strong>{{$page->page_title}}</strong></td>
                                <td><a target="_blank" href="{{ url('/') }}/page/{{$page->page_title_seo}}">/page/{{$page->page_title_seo}}</a></td>
                                <td>{{$page->updated_at}}</td>
                                <td>
                                    <input onchange="statusChanger(this)" data-id="{{$page->page_id}}" type="checkbox" {{ ($page->page_status == "on") ? ' checked="true" ' : '' }} class="js-switch" data-size="small" data-color="#009efb" style="display: none;" data-switchery="true">

                                </td>
                                <td>
                                    <a href="{{route('page.Edit',['id' => $page->page_id])}}" class="btn btn-info" data-id="{{$page->page_id}}">Düzenle</a>
                                    <button class="btn btn-danger" onclick="del(this)" data-id="{{$page->page_id}}">Sil</button>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>
</div>

<script src="/assets/node_modules/switchery/dist/switchery.min.js"></script>
<script>
    function statusChanger(e) {
        var id = $(e).attr('data-id');
        $.ajax({
            type: "POST",
            url: "{{Route('page.statusChanger')}}",
            data: {
                id
            },
            success: function(response) {
                console.log(response);
            }
        });
    }

    $(document).ready(function() {
        var elems = Array.prototype.slice.call(document.querySelectorAll('.js-switch'));
        $('.js-switch').each(function() {
            new Switchery($(this)[0], $(this).data());
        });
    });

function del(e) {
        var id = $(e).attr('data-id');
        if (confirm("Silmek istiyor musunuz?") === true) {


            $.ajax({
                type: "POST",
                url: "{{Route('page.delete')}}",
                data: {
                    id
                },
                success: function(response) {
                    let res = JSON.parse(response);
                    if (res.status) {

                        Swal.fire({
                            position: 'center-center',

                            timer: 3000,
                            type: 'success',
                            title: 'Silme işlemi başarılı',
                            showConfirmButton: false,
                        }).then(function() {
                            window.location.reload();
                        })

                    } else {
                        Swal.fire({
                            position: 'center-center',
                            type: 'error',
                            title: 'Silme işlemi başarısız.',
                            showConfirmButton: false,
                            timer: 3000,
                            function() {
                                location.reload();
                            }
                        });
                    }
                }
            });


        } else {


                  Swal.fire({
                            position: 'center-center',

                            timer: 3000,
                        
                            title: 'İşlem iptal edildi!',
                            showConfirmButton: false,
                        })


        }





    }


</script>
@endsection