@extends('admin.layouts.app')
@section('content')

<style>
    table.dataTable.no-footer {
        border-bottom: none !important;
    }


    .color-bordered-table.red-bordered-table {
        border: none !important;
    }

    .newButton {
        background-color: #00c292 !important;
    }
</style>
<link href="/assets/node_modules/switchery/dist/switchery.min.css" rel="stylesheet" />
<link rel="stylesheet" href="//cdn.datatables.net/1.13.2/css/jquery.dataTables.min.css">
<div class="row page-titles">
    <div class="col-md-12">
        <h4 class="text-white">YSİİD</h4>
    </div>
    <div class="col-md-6">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/admin/panel">Anasayfa</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Haber Yönetimi </a></li>
            <li class="breadcrumb-item active">Haber Listesi</li>
        </ol>
    </div>
    <div class="col-md-6 text-right">
        <form class="app-search d-none d-md-block d-lg-block">
            <input type="text" class="form-control" placeholder="Search &amp; enter">
        </form>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                @if(session('status'))
                <script>
                    $(document).ready(function() {
                        Swal.fire({
                            position: 'center-center',
                            type: 'success',
                            title: '{{session("status")}}',
                            showConfirmButton: false,
                            timer: 3000
                        })
                    });
                </script>

                @endif


                <table style="width: 100% !important;" id="myTable" class="table color-bordered-table red-bordered-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Kapak</th>
                            <th>Haber Adı</th>
                            <th>Seo Adresi</th>
                            <th>Oluşturma Zamanı</th>
                            <th>Güncelleme Zamanı</th>


                            <th>Aktif/Pasif</th>
                            <th>islem</th>

                        </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>


            </div>
        </div>
    </div>
</div>




<script src="//cdn.datatables.net/1.13.2/js/jquery.dataTables.min.js"></script>
<script src="/assets/node_modules/switchery/dist/switchery.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.html5.min.js"></script>
<script>
    const sehirListesi = [];
    let table = null;

    function regenerateTable() {

        Swal.fire({
            position: 'center-center',
            timer: 3000,
            type: 'success',
            title: 'İşlem başarılı',
            showConfirmButton: false,
        }).then(function() {
            table.ajax.reload(null, false);
        })
    }
    $(function() {
        table = $('#myTable').DataTable({
            "responsive": true,
            "dom": '<"html5buttons"B>lTfgitp',
             "order": [
                [0, "desc"]
            ],
            "language": {
                "url": "https://cdn.datatables.net/plug-ins/1.13.2/i18n/tr.json"
            },
            buttons: [{
                text: 'Yeni Ekle',
                className: "newButton",
                action: function(e, dt, node, config) {
                    _new();
                }
            }, 'copy', 'csv', 'excel', 'pdf'],
            processing: true,
            serverSide: true,
            ajax: "{{ route('news.ajaxList') }}",

            "drawCallback": function(settings) {
                $('.js-switch').each(function() {
                    new Switchery($(this)[0], $(this).data());
                });
            },

            "columnDefs": [{
                    "targets": [0],
                    "visible": false,
                    "searchable": false
                },
                {
                    "render": createManageBtn,
                    "data": 1,
                    "id": 1,
                    "targets": [7]
                }, {
                    "render": createStatusSwitcher,
                    "data": 1,
                    "id": 1,
                    "targets": [6]
                }, {
                    "render": createImage,
                    "data": 1,
                    "id": 1,
                    "targets": [1]
                }
            ],
            columns: [{
                    data: 'page_id'
                },
                {
                    data: 'cover'
                },
                {
                    data: 'page_title'
                },
                {
                    data: 'page_title_seo'
                },
                {
                    data: 'created_at'
                },
                {
                    data: 'updated_at'
                },
                {
                    data: 'page_status'
                },
                {
                    data: 'id'
                }
            ],

        });

    });

    function _new() {
        window.location.href = "/admin/news/newpage";
    }

    function save() {
        let data = $("#form").serialize();
        data += "&_token={{ csrf_token() }}",

            $.ajax({
                type: "POST",
                url: "{124{ route('bayi.save')}awdawd}",
                data: data,
                success: function(response) {
                    $('#staticBackdrop').modal('hide');
                    regenerateTable();
                }
            });
    }

    function edit(data) {


        $.ajax({
            type: "POST",
            url: "{wad{route('bayi.getSingle')}awd}",
            data: {
                id: data,
                _token: "{{ csrf_token() }}"
            },

            success: function(response) {
                response = JSON.parse(response);
                response = response[0];
                $('#staticBackdrop').modal('show');
                let optionSehirList = "";
                sehirListesi.forEach(element => {
                    if (element.Id == response.il) {
                        optionSehirList = optionSehirList + `<option selected value="${element.Id}">${element.SehirAd}</option>`;
                    } else {
                        optionSehirList = optionSehirList + `<option value="${element.Id}">${element.SehirAd}</option>`;

                    }
                });

                $(".modal-title").html("<strong>Bayi Düzenle</strong>");


                const html = `
                    <form method="post" action="return false;" id="form">
                        <div class="row">
                            <div class="col-6">
                                <div class="form-group">
                                    <label for="bayi_adi">Bayi Adı</label>
                                    <input type="text" value="${response.bayi_adi}" placeholder="Buraya bayi adı girmelisiniz" class="form-control" name="bayi_adi" id="bayi_adi" aria-describedby="emailHelp">
                                </div>
                                <div class="form-group">
                                    <label for="tel_1">Telefon</label>
                                    <input type="text"  value="${response.telefon}"  placeholder="Buraya bayi telefonunu girmelisiniz" class="form-control" name="telefon" id="telefon" aria-describedby="emailHelp">
                                </div>
                                <div class="form-group">
                                    <label for="tel_1">Telefon 2</label>
                                    <input type="text"  value="${response.telefon_2}"  placeholder="İkinci bir telefon yoksa boş bırakınız" class="form-control" name="telefon_2" id="telefon_2" aria-describedby="emailHelp">
                                </div>
                                <div class="form-group">
                                    <label for="tel_1">Faks</label>
                                    <input type="text"  value="${response.faks}"  placeholder="Buraya faks numarasını girmelisiniz" class="form-control" name="faks" id="faks" aria-describedby="emailHelp">
                                </div>
                            </div>
                            <div class="col-6">
                            
                                <div class="form-group">
                                    <label for="tel_1">E-Posta</label>
                                    <input type="text"  value="${response.email}"  placeholder="Buraya bayi mail adresini girmelisiniz" class="form-control" name="email" id="email" aria-describedby="emailHelp">
                                </div>
                                <div class="form-group">
                                    <label for="tel_1">Web Site</label>
                                    <input type="text"  value="${response.site}"  placeholder="Buraya varsa web sitesini girmelisiniz" class="form-control" name="site" id="site" aria-describedby="emailHelp">
                                </div>
                                <div class="form-group">
                                    <label for="tel_1">Yetkili Adı</label>
                                    <input type="text"  value="${response.yetkili_adi}"  placeholder="Buraya yetkili adı girmelisiniz" class="form-control" name="yetkili_adi" id="site" aria-describedby="emailHelp">
                                </div>

                                <div class="form-group">
                                    <label for="tel_1">Bayi İli</label>
                                    <select name="il" class="form-control">
                                    ${optionSehirList}
                                    </select>
                                </div>
                            
                            </div>
                        <div class="col-12">
                        <div class="form-group">
                                <label>Adres</label>
                                <textarea name="adres" id="adres" class="form-control" placeholder="Adres giriniz">${response.adres}</textarea>
                            </div>
                        </div>

                        </form>
                    
                    <input type="text" class="form-control d-none" value="${response.id}" name="update_id" id="update_id" >
                    `;

                $("#m_content").html(html);





            }
        });


    }

    function createStatusSwitcher(x, y, data) {

        return `<input onchange="statusChanger(this)" data-id="${data.id}" type="checkbox"${data.page_status == "on"  ? ' checked="true" ' : '' } class="js-switch" data-size="small" data-color="#009efb" style="display: none;" data-switchery="true">`;
    }

    function createImage(x, y, data) {

        return `<img class="img" style="height:50px" src="/uploads/${data.cover}" />`;
    }

    function createManageBtn(data) {
        let html = `
                <a id="manageBtn" type="button" href="/admin/news/edit/${data}"  class="btn btn-success btn-xs">Düzenle</a>
                <button id="manageBtn" type="button" href="" onclick="del(${data})" class="btn btn-danger btn-xs">Sil</button>
             `;
        return html;
    }




    function statusChanger(e) {
        var id = $(e).attr('data-id');
        $.ajax({
            type: "POST",
            url: "{dawd{Route('bayi.statusChanger')}awd}",
            data: {
                id
            },
            success: function(response) {
                console.log(response);
            }
        });
    }



    function del(id) {

        if (confirm("Silmek istiyor musunuz?") === true) {
            $.ajax({
                type: "POST",
                url: "{{route('news.delete')}}",
                data: {
                    id: id,
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    let res = JSON.parse(response);
                    if (res.status) {

                        Swal.fire({
                            position: 'center-center',

                            timer: 2000,
                            type: 'success',
                            title: 'Silme işlemi başarılı',
                            showConfirmButton: false,
                        }).then(function() {
                            table.ajax.reload(null, false);
                        })

                    } else {
                        Swal.fire({
                            position: 'center-center',
                            type: 'error',
                            title: 'Silme işlemi başarısız.',
                            showConfirmButton: false,
                            timer: 2000,
                            function() {
                                table.ajax.reload(null, false);
                            }
                        });
                    }
                }
            });


        } else {


            Swal.fire({
                position: 'center-center',

                timer: 3000,

                title: 'İşlem iptal edildi!',
                showConfirmButton: false,
            })


        }

    }
</script>
@endsection