@extends('admin.layouts.app')
@section('content')
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <style>
        table.dataTable.no-footer {
            border-bottom: none !important;
        }


        .color-bordered-table.red-bordered-table {
            border: none !important;
        }

        .newButton {
            background-color: #00c292 !important;
        }
    </style>
    <link href="/assets/node_modules/switchery/dist/switchery.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="//cdn.datatables.net/1.13.2/css/jquery.dataTables.min.css">
    <div class="row page-titles">
        <div class="col-md-12">
            <h4 class="text-white">YSİİD</h4>
        </div>
        <div class="col-md-6">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Anasayfa</a></li>
                <li class="breadcrumb-item active">Üye Görüntüleme/Düzenleme</li>
            </ol>
        </div>
        <div class="col-md-6 text-right">
            <form class="app-search d-none d-md-block d-lg-block">
                <input type="text" class="form-control" placeholder="Search &amp; enter">
            </form>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <div class="col">


                        <div class="row">
                            <div class="col-12">
                                <label class="d-block text-danger w-100 border-bottom pb-2"
                                    style="font-size: 23px;"><strong>Şirket
                                        Bilgileri</strong></label><br>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="exampleInputEmail1" class="form-label"><strong>Şirket Adı</strong></label>
                                    <input type="text" class="form-control" maxlength="30" id="corporate_name"
                                        value="{{ $uye->corporate_name }}" aria-describedby="emailHelp">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="exampleInputEmail1" class="form-label"><strong>Tüzel/Gerçek</strong></label>
                                    <select class="form-select" id="isLegal">
                                        <option {{ $uye->isLegal == 'tuzel' ? ' selected ' : '' }} value="tuzel">Tüzel
                                        </option>
                                        <option {{ $uye->isLegal == 'sahis' ? ' selected ' : '' }} value="sahis">Gerçek
                                        </option>
                                    </select>
                                </div>
                            </div>






                            <div class="col-md-6 mt-3 d-flex flex-wrap">
                                <label for="exampleInputEmail1" class="form-label d-block w-100 "><strong>Yıllık Ciro
                                        Miktarınız(Milyon TL)</strong></label>
                                <div class="form-check me-4">
                                    <input class="form-check-input" type="radio"
                                        {{ $uye->ciro_miktari == '' || $uye->ciro_miktari == '0-3' ? ' checked ' : '' }}
                                        name="ciro" id="radio1" value="0-3">
                                    <label class="form-check-label" for="radio1">
                                        3 ve daha az
                                    </label>
                                </div>

                                <div class="form-check me-4">
                                    <input class="form-check-input" type="radio" name="ciro" id="radio2"
                                        value="4-25" {{ $uye->ciro_miktari == '4-25' ? ' checked ' : '' }}>
                                    <label class="form-check-label" for="radio2">
                                        4-25
                                    </label>
                                </div>

                                <div class="form-check me-4">
                                    <input class="form-check-input" type="radio" name="ciro" id="radio3"
                                        value="26-125" {{ $uye->ciro_miktari == '26-125' ? ' checked ' : '' }}>
                                    <label class="form-check-label" for="radio3">
                                        26-125
                                    </label>
                                </div>

                                <div class="form-check me-4">
                                    <input class="form-check-input" type="radio" name="ciro" id="radio4"
                                        value="126+" {{ $uye->ciro_miktari == '126+' ? ' checked ' : '' }}>
                                    <label class="form-check-label" for="radio4">
                                        126 ve daha fazla
                                    </label>
                                </div>


                            </div>
                          

 <div class="col-md-6 mt-3 d-flex flex-wrap">
                        <label class="d-block w-100"><strong>Personel Sayısı:</strong></label><br>
                        <div class="form-check me-4">
                            <input class="form-check-input" checked type="radio" name="personel_sayisi" id="personel-1"
                                {{ $uye->personel_sayisi == '' || $uye->personel_sayisi == '<50' ? ' checked ' : '' }}
                                value="<50" required>
                            <label class="form-check-label" for="personel-1">
                                50 ve daha az </label>
                        </div>
                        <div class="form-check me-4">
                            <input class="form-check-input" type="radio" name="personel_sayisi" id="personel-2"
                                {{ $uye->personel_sayisi == '<250' ? ' checked ' : '' }} value="<250" required>
                            <label class="form-check-label" for="personel-2">
                                <250
                            </label>
                        </div>
                        <div class="form-check me-4">
                            <input class="form-check-input" type="radio" name="personel_sayisi" id="personel-3"
                                {{ $uye->personel_sayisi == '250>' ? ' checked ' : '' }} value="250>" required>
                            <label class="form-check-label" for="personel-3">
                               250>
                            </label>
                        </div>
                       
                    </div>





















                            <div class="col-md-6 mt-3">
                                <div class="mb-3">
                                    <label for="exampleInputEmail1" class="form-label"><strong>Kurum
                                            Telefonu</strong></label>
                                    <input type="number"  class="form-control" id="sirketTel"
                                        value="{{ $uye->sirketTel }}" aria-describedby="emailHelp">
                                </div>
                            </div>


                            <div class="col-md-6 mt-3">
                                <div class="mb-3">
                                    <label for="exampleInputEmail1" class="form-label"><strong>Faks
                                            Numarası</strong></label>
                                    <input type="number" class="form-control" id="faks"
                                        value="{{ $uye->faks }}" aria-describedby="emailHelp">

                                </div>
                            </div>




                            <div class="col-12 mt-1">
                                <div class="mb-3">
                                    <label for="exampleInputEmail1" class="form-label"><strong>Şehir</strong></label>
                                    <select class="form-control" id="sehir">
                                        <option disabled selected value="">Seçiniz</option>
                                        @foreach ($sehirler as $sehir)
                                            <option {{ $sehir == $uye->sehir ? ' selected ' : '' }}
                                                value="{{ $sehir }}">
                                                {{ $sehir }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="exampleInputEmail1" class="form-label"><strong>Adres</strong></label>
                                    <textarea name="" id="adres" class="form-control" cols="30" rows="3">{{ $uye->adres }}</textarea>
                                </div>
                            </div>





                            <div class="col-md-6 mt-3">
                                <div class="mb-3">
                                    <label for="exampleInputEmail1" class="form-label"><strong>Web Sitesi</strong></label>
                                    <input type="text" class="form-control" id="website"
                                        value="{{ $uye->website }}" aria-describedby="emailHelp">

                                </div>
                            </div>

                            <div class="col-md-6  mt-3">
                                <div class="mb-3">
                                    <label for="exampleInputEmail1" class="form-label"><strong>Kurum
                                            Logosu</strong></label>


                                    <br>
                                    <a href="/uploads/sra/{{ md5(session('uye_id') . 'MB') }}/docs/{{ $uye->logo }}"
                                        target="_blank" download>
                                        <img src="/uploads/sra/{{ md5(session('uye_id') . 'MB') }}/docs/{{ $uye->logo }}"
                                            style="height:200px;" alt="">
                                    </a>
                                    <br>
                                </div>
                            </div>

                        </div>


                        <div class="row mt-2">
                            <div class="col-12">
                                <label class="d-block text-danger w-100 border-bottom pb-2"
                                    style="font-size: 23px;"><strong>Yetkili Bilgileri</strong></label><br>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="exampleInputEmail1" class="form-label"><strong>Adı</strong></label>
                                    <input type="text" class="form-control" maxlength="30" id="name"
                                        value="{{ $uye->name }}" aria-describedby="emailHelp">

                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="exampleInputEmail1" class="form-label"><strong>Soyadı</strong></label>
                                    <input type="text" class="form-control" maxlength="30" id="surname"
                                        value="{{ $uye->surname }}" aria-describedby="emailHelp">

                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="exampleInputEmail1" class="form-label"><strong>T.C. Kimlik
                                            No</strong></label>
                                    <input type="number" maxlength="11" minlength="11" class="form-control"
                                        id="tc" value="{{ $uye->tck }}" aria-describedby="emailHelp">

                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="exampleInputEmail1" class="form-label"><strong>Doğum
                                            Tarihi</strong></label>
                                    <input type="date" class="form-control" id="dtarih"
                                        value="{{ $uye->d_tarih }}" aria-describedby="emailHelp">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="exampleInputEmail1" class="form-label"><strong>E-Posta</strong></label>
                                    <input type="text" class="form-control" id="email"
                                        value="{{ $uye->email }}" aria-describedby="emailHelp">

                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="exampleInputEmail1" class="form-label"><strong>Telefon</strong></label>
                                    <input type="number" class="form-control" id="phone"
                                        value="{{ $uye->phone }}" aria-describedby="emailHelp">
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="exampleInputEmail1" class="form-label"><strong>Göreviniz</strong></label>
                                    <input type="text" class="form-control" id="corporate_role"
                                        value="{{ $uye->corporate_role }}" aria-describedby="emailHelp">
                                </div>
                            </div>


                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label for="exampleInputEmail1" class="form-label"><strong>Kimlik
                                            Fotokopisi</strong></label>
                                    <br>
                                    <a href="/uploads/sra/{{ md5(session('uye_id') . 'MB') }}/docs/{{ $uye->kimfoto }}"
                                        target="_blank" download>
                                        <img src="/uploads/sra/{{ md5(session('uye_id') . 'MB') }}/docs/{{ $uye->kimfoto }}"
                                            style="height:200px;" alt="">
                                    </a>
                                    <br>
                                </div>
                            </div>




                            <div class="mt-3 d-flex flex-wrap">
                                <label class="d-block w-100 mb-2"><strong>İrtibat Kişisi(Asistan):</strong></label><br>
                                <div class="mb-3 col-12 col-md-4 pe-2">
                                    <label for="exampleInputEmail1" class="form-label"><strong>Adı ve
                                            Soyadı</strong></label>
                                    <input type="text" class="form-control" maxlength="30" id="asistanNameSurname"
                                        value="{{ $uye->asistanNameSurname }}" aria-describedby="emailHelp">

                                </div>

                                <div class="mb-3 col-12 col-md-4 pe-2">
                                    <label for="exampleInputEmail1" class="form-label"><strong>E-Posta
                                            Adresi</strong></label>
                                    <input type="text" class="form-control" maxlength="30" id="asistanMail"
                                        value="{{ $uye->asistanMail }}" aria-describedby="emailHelp">

                                </div>

                                <div class="mb-3 col-12 col-md-4 pe-2">
                                    <label for="exampleInputEmail1" class="form-label"><strong>Telefon
                                            Numarası</strong></label>
                                    <input type="number" class="form-control" maxlength="30" id="asistanTel"
                                        value="{{ $uye->asistanTel }}" aria-describedby="emailHelp">

                                </div>
                            </div>
                        </div>
                        <div class="row mt-5">
                            <div class="col-12">
                                <ul class="list-group">
                                </ul>
                            </div>
                        </div>
                        <div id="buttons" style="min-height:400px;" class="row pt-4">
                            <div class="col-2 mt-4 border-right text-center">
                                <label for="exampleInputEmail1" class="form-label" style="font-size:20px;"><strong>Üyelik
                                        Durumu</strong></label><br>
                                <span>Pasif durumu seçtiğinizde <br> sisteme girişi engellenecektir.</span>

                                <div class="form-check mt-3">
                                    <input onclick="isActive(this)" class="form-check-input" type="radio"
                                        name="isActive" id="approved" value="1"
                                        {{ (int) $uye->isActive == 1 ? ' checked ' : '' }}>
                                    <label class="form-check-label" for="approved"
                                        style="color:green;font-weight:700">Aktif</label>
                                </div>

                                <div class="form-check">
                                    <input onclick="isActive(this)" class="form-check-input" type="radio"
                                        name="isActive" id="rejecte2d" value="0"
                                        {{ (int) $uye->isActive == 0 ? ' checked ' : '' }}>
                                    <label class="form-check-label" for="rejecte2d"
                                        style="color:red;font-weight:700">Pasif</label>
                                </div>
                            </div>

                            <div class="col-2 mt-4 border-right text-center">
                                <label for="exampleInputEmail1" class="form-label" style="font-size:20px;"><strong>Evrak
                                        Onay
                                        Durumu</strong></label><br>
                                <span>Onaylandığı durumda üye olan kişi hesap <br>bilgilerinin yer aldığı sayfaya
                                    yönlendirilecektir.</span>

                                <div class="form-check mt-4">
                                    <input onclick="approved(this)" class="form-check-input" type="radio"
                                        name="approved" id="rejected1" value="0"
                                        {{ (int) $uye->approved == 0 ? ' checked ' : '' }}>
                                    <label class="form-check-label" for="rejected1"
                                        style="color:orange;font-weight:700">Beklemede</label>
                                </div>

                                <div class="form-check">
                                    <input onclick="approved(this)" class="form-check-input" type="radio"
                                        name="approved" id="rejected2" value="2"
                                        {{ (int) $uye->approved == 2 ? ' checked ' : '' }}>
                                    <label class="form-check-label" for="rejected2"
                                        style="color:red;font-weight:700">Reddet</label>
                                </div>

                                <div class="form-check">
                                    <input onclick="approved(this)" class="form-check-input" type="radio"
                                        name="approved" id="rejected3" value="1"
                                        {{ (int) $uye->approved == 1 ? ' checked ' : '' }}>
                                    <label class="form-check-label" for="rejected3"
                                        style="color:green;font-weight:700">Onayla</label>
                                </div>
                            </div>
                                <div class="col-2 mt-4 border-right text-center">
                                <label for="exampleInputEmail1" class="form-label" style="font-size:20px;"><strong>Kayıt Ücreti</strong></label><br>
                                <span>Kayıt ücretini onayladığınızda kullanıcı paneli görüntüleyebilir.</span>




                                <div class="form-check">
                                    <input onclick="register_pay(this)" class="form-check-input" type="radio"
                                        name="register_pay" id="onay2" value="0"
                                        {{ (int) $uye->register_pay == 0 ? ' checked ' : '' }}>
                                    <label class="form-check-label" for="onay2"
                                        style="color:red;font-weight:700">Reddet</label>
                                </div>

                                <div class="form-check">
                                    <input onclick="register_pay(this)" class="form-check-input" type="radio"
                                        name="register_pay" id="onay3" value="1"
                                        {{ (int) $uye->register_pay == 1 ? ' checked ' : '' }}>
                                    <label class="form-check-label" for="onay3"
                                        style="color:green;font-weight:700">Onayla</label>
                                </div>





                            </div>
                            <div class="col-2 mt-4 border-right text-center">
                                <label for="exampleInputEmail1" class="form-label" style="font-size:20px;"><strong>Dekont
                                        Listesi</strong></label><br>
                                <span>Yüklenen dekontları görmek<br> için buraya tıklayınız.</span>
                                <br>
                                <button onclick="getReceipt()" class=" btn btn-primary mt-3">Dekont Listesi</button>
                            </div>
                            <div class="col-2 mt-4 border-right text-center">
                                <label for="exampleInputEmail1" class="form-label" style="font-size:20px;"><strong>Üyelik Aidatı</strong></label><br>
                                 <span>Yıllık aidat ücretini bu alana yazabilirsiniz. Aidat Güncelle butonuna tıklamadığınız sürece kayıt olmayacaktır.</span>
                                <input type="number" class="form-control" id="aidat" name="aidat" value="{{$uye->aidat}}"/>
                               
                                <button onclick="setAidat(this)" data-id="{{$uye->id}}" class=" btn btn-danger mt-3">Aidat Güncelle</button>
                            </div>

                            <div class="col-2 mt-4 border-right text-center">
                                <label for="exampleInputEmail1" class="form-label"
                                    style="font-size:20px;"><strong>Bilgileri Güncelle</strong></label><br>
                                <span>Üye bilgilerini güncellemek için<br> aşağıdaki butona tıklayabilirsiniz.<br> Önceki
                                    verilerin geri dönüşü olmayacaktır.</span>
                                <br>
                                <button onclick="saveMyForm()" class=" btn btn-success mt-3">Güncelle</button>
                            </div>




                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Dekont Listesi</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div id="modal-body" class="modal-body">

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous">
    </script>
    <script src="//cdn.datatables.net/1.13.2/js/jquery.dataTables.min.js"></script>
    <script src="/assets/node_modules/switchery/dist/switchery.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.html5.min.js"></script>
    <script defer src="https://use.fontawesome.com/releases/v5.15.4/js/all.js" integrity="sha384-rOA1PnstxnOBLzCLMcre8ybwbTmemjzdNlILg8O7z1lUkLXozs4DHonlDtnE7fpc" crossorigin="anonymous"></script>
    <script>
        function setAidat(e){
            var id = $(e).data("id");
            var aidat = $("#aidat").val();

              $.ajax({
                type: "POST",
                url: "{{ route('member.setAidat') }}",
                data: {
                    "_token": "{{ csrf_token() }}",
                    "id": id,
                    "aidat" : aidat
                },
                success: function(response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Başarılı',
                        text: 'Bilgileriniz başarılı bir şekilde kayıt edildi.',
                    });
                }
            });
        }



        function getReceipt() {
            var myModal = new bootstrap.Modal(document.getElementById('myModal'));

            link = '{{ $upload_folder = "uploads/sra/" . md5(session("uye_id") . "MB") . "/receipt"}}/';
            myModal.show();
            $.ajax({
                type: "POST",
                url: "{{ route('member.receiptList') }}",
                data: {
                    "_token": "{{ csrf_token() }}",
                    "id": "{{ $uye->id }}",
                },
                success: function(response) {
                    $("#modal-body").html(`
                    <div class="list-group ">

                    `);
                    response.forEach(element => {
                            $("#modal-body").append(`
                             
                             <a href="/${link+element.name}" download class="list-group-item list-group-item-action " aria-current="true"><i class="fas fa-download"></i> ${element.upload_date+'-'+element.name} </a>
                            `);
                    });

                    $("#modal-body").append(`</div>`);
                }
            });



        }

        function saveMyForm() {

            var data = [];
            var corporate_name = $('#corporate_name').val();
            var isLegal = $('#isLegal').find('option:selected').val();
            var ciro = $("input[name='ciro']:checked").val();
            var personel_sayisi = $("input[name='personel_sayisi']:checked").val();
            var website = $('#website').val();
            var faks = $('#faks').val();
            var sehir = $('#sehir').find('option:selected').val();
            var adres = $('#adres').val();
            var name = $('#name').val();
            var surname = $('#surname').val();
            var tck = $('#tc').val();
            var d_tarih = $('#dtarih').val();
            var phone = $('#phone').val();
            var corporate_role = $('#corporate_role').val();
            var asistanNameSurname = $('#asistanNameSurname').val();
            var asistanMail = $('#asistanMail').val();
            var asistanTel = $('#asistanTel').val();
            var email = $('#email').val();
            var sirketTel = $('#sirketTel').val();
            var kimfoto = document.getElementById('kimfoto');
            var logo = document.getElementById('logo');
            var formDatax = new FormData();

            if (name == '') {
                Swal.fire({
                    icon: 'error',
                    title: 'Eksik Bilgi',
                    text: 'Adınızı giriniz',
                });
                return false;
            } else if (adres == '') {
                Swal.fire({
                    icon: 'error',
                    title: 'Eksik Bilgi',
                    text: 'Adresinizi giriniz',
                });
                return false;
            } else if (adres == '') {
                Swal.fire({
                    icon: 'error',
                    title: 'Eksik Bilgi',
                    text: 'Adresinizi giriniz',
                });
                return false;
            } else if (phone == '') {
                Swal.fire({
                    icon: 'error',
                    title: 'Eksik Bilgi',
                    text: 'Telefon numaranızı giriniz',
                });
                return false;
            } else if (email == '') {
                Swal.fire({
                    icon: 'error',
                    title: 'Eksik Bilgi',
                    text: 'E-posta adresinizi giriniz',
                });
                return false;
            } else if (corporate_name == '') {
                Swal.fire({
                    icon: 'error',
                    title: 'Eksik Bilgi',
                    text: 'Kurum adını giriniz',
                });
                return false;
            } else if (isLegal == '') {
                Swal.fire({
                    icon: 'error',
                    title: 'Eksik Bilgi',
                    text: 'Kurumun yasal statüsünü seçiniz',
                });
                return false;
            } else if (ciro == "") {
                Swal.fire({
                    icon: 'error',
                    title: 'Eksik Bilgi',
                    text: 'Cironuzu seçiniz',
                });
                return false;
            } else if (personel_sayisi == "") {
                Swal.fire({
                    icon: 'error',
                    title: 'Eksik Bilgi',
                    text: 'Personel sayınızı seçiniz',
                });
                return false;
            } else if (sehir == '') {
                Swal.fire({
                    icon: 'error',
                    title: 'Eksik Bilgi',
                    text: 'Şehir seçiniz',
                });
                return false;
            } else if (tck == '') {
                Swal.fire({
                    icon: 'error',
                    title: 'Eksik Bilgi',
                    text: 'TC kimlik numaranızı giriniz',
                });
                return false;
            } else if (d_tarih == '') {
                Swal.fire({
                    icon: 'error',
                    title: 'Eksik Bilgi',
                    text: 'Doğum tarihinizi giriniz',
                });
                return false;
            } else {
                // formDatax.append("logo", $('#logo').files[0]);
                formDatax.append("_token", '{{ csrf_token() }}');
                formDatax.append("corporate_name", corporate_name);
                formDatax.append("isLegal", isLegal);
                formDatax.append("ciro", ciro);
                formDatax.append("personel_sayisi", personel_sayisi);
                formDatax.append("website", website);
                formDatax.append("faks", faks);
                formDatax.append("sehir", sehir);
                formDatax.append("adres", adres);
                formDatax.append("name", name);
                formDatax.append("surname", surname);
                formDatax.append("tck", tck);
                formDatax.append("d_tarih", d_tarih);
                formDatax.append("phone", phone);
                formDatax.append("corporate_role", corporate_role);
                formDatax.append("asistanNameSurname", asistanNameSurname);
                formDatax.append("asistanMail", asistanMail);
                formDatax.append("asistanTel", asistanTel);
                formDatax.append("email", email);
                formDatax.append("sirketTel", sirketTel);
                formDatax.append("uye_id", '{{ $uye->id }}');




                $.ajax({
                    url: '{{ route('saveMyForm') }}',
                    type: 'post',
                    data: formDatax,
                    contentType: false,
                    processData: false,
                    success: function(response) {
                        if (response.status == 'success') {
                            Swal.fire({
                                icon: 'success',
                                title: 'İnceleme İsteği Başarılı',
                                text: 'Bilgileriniz başarılı bir şekilde kayıt edildi.',
                            });


                        }
                    }
                });
            }
        }

        function approved(e) {
            let appdata = $(e).val();

            $.ajax({
                type: "POST",
                url: "{{ Route('member.approvedChanger') }}",
                data: {
                    "_token": "{{ csrf_token() }}",
                    "uyeid": "{{ $uye->id }}",
                    "appdata": appdata
                },
                success: function(response) {
                    Swal.fire({
                        position: 'center-center',
                        icon: 'success',
                        title: 'Evrak durumu güncellendi',
                        showConfirmButton: false,
                        timer: 1500
                    })
                }
            });




        }

         function register_pay(e) {
            let rpay = $(e).val();

            $.ajax({
                type: "POST",
                url: "{{ Route('member.register_pay') }}",
                data: {
                    "_token": "{{ csrf_token() }}",
                    "uyeid": "{{ $uye->id }}",
                    "appdata": rpay
                },
                success: function(response) {
                    Swal.fire({
                        position: 'center-center',
                        icon: 'success',
                        title: 'Kayıt ücreti durumu güncellendi',
                        showConfirmButton: false,
                        timer: 1500
                    })
                }
            });




        }

        function isActive(e) {
            let isdata = $(e).val();
            $.ajax({
                type: "POST",
                url: "{{ Route('member.isActiveChanger') }}",
                data: {
                    "_token": "{{ csrf_token() }}",
                    "uyeid": "{{ $uye->id }}",
                    "isdata": isdata
                },
                success: function(response) {
                    Swal.fire({
                        position: 'center-center',
                        icon: 'success',
                        title: 'Üyelik durumu güncellendi',
                        showConfirmButton: false,
                        timer: 1500
                    })
                }
            });
        }
        $.ajax({
            url: '{{ route('listFiles') }}',
            type: 'post',
            data: {
                "_token": '{{ csrf_token() }}'
            },
            success: function(response) {

                const list = document.querySelector('.list-group');
                response.forEach((item) => {
                    const li = document.createElement('li');
                    const a = document.createElement('a');
                    a.setAttribute('href', item.path);
                    a.setAttribute('download', item.name);
                    a.textContent = `${item.name} (${formatBytes(item.size)})`;
                    li.classList.add('list-group-item');
                    li.appendChild(a);
                    list.appendChild(li);
                });

                function formatBytes(bytes, decimals = 2) {
                    if (bytes === 0) return '0 Bytes';
                    const k = 1024;
                    const dm = decimals < 0 ? 0 : decimals;
                    const sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
                    const i = Math.floor(Math.log(bytes) / Math.log(k));
                    return parseFloat((bytes / Math.pow(k, i)).toFixed(dm)) + ' ' + sizes[i];
                }

            }
        });
    </script>
@endsection
