@extends('admin.layouts.app')
@section('content')

<link href="/assets/node_modules/switchery/dist/switchery.min.css" rel="stylesheet" />
<div class="row page-titles">
    <div class="col-md-12">
        <h4 class="text-white">YSİİD</h4>
    </div>
    <div class="col-md-6">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Anasayfa</a></li>
            <li class="breadcrumb-item active">YSİİD</li>
        </ol>
    </div>
    <div class="col-md-6 text-right">
        <form class="app-search d-none d-md-block d-lg-block">
            <input type="text" class="form-control" placeholder="Search &amp; enter">
        </form>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                @if(session('status'))
                <script>
                    $(document).ready(function() {
                        Swal.fire({
                            position: 'center-center',
                            type: 'success',
                            title: '{{session("status")}}',
                            showConfirmButton: false,
                            timer: 3000
                        })
                    });
                </script>

                @endif


                <div class="table-responsive">
                    <table class="table color-bordered-table red-bordered-table">
                        <thead>
                            <tr>
                                <th>Üye ID</th>
                                <th>Şirket Adı</th>
                                <th>Yetkili Ad Soyad</th>
                                <th>Gönderilme Tarihi</th>
                                <th>İncele</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($data as $item)
                            <tr>
                                <td><strong>{{$item->id}}</strong></td>
                                <td><strong>{{$item->corporate_name}}</strong></td>
                                <td><strong>{{$item->name}} {{$item->surname}}</strong></td>
                                <td>{{date('d-m-Y H:i:s',strtotime($item->updated_at))}}</td>
                      
                                <td>
                                    <a href="{{route('member.Edit',['id' => $item->id])}}" class="btn btn-success">İncele</a>
                                  
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>
</div>

<script src="/assets/node_modules/switchery/dist/switchery.min.js"></script>
<script>
    function statusChanger(e) {
        var id = $(e).attr('data-id');
        $.ajax({
            type: "POST",
            url: "{{Route('page.statusChanger')}}",
            data: {
                id
            },
            success: function(response) {
                console.log(response);
            }
        });
    }

    $(document).ready(function() {
        var elems = Array.prototype.slice.call(document.querySelectorAll('.js-switch'));
        $('.js-switch').each(function() {
            new Switchery($(this)[0], $(this).data());
        });
    });

function del(e) {
        var id = $(e).attr('data-id');
        if (confirm("Silmek istiyor musunuz?") === true) {


            $.ajax({
                type: "POST",
                url: "{{Route('page.delete')}}",
                data: {
                    id
                },
                success: function(response) {
                    let res = JSON.parse(response);
                    if (res.status) {

                        Swal.fire({
                            position: 'center-center',

                            timer: 3000,
                            type: 'success',
                            title: 'Silme işlemi başarılı',
                            showConfirmButton: false,
                        }).then(function() {
                            window.location.reload();
                        })

                    } else {
                        Swal.fire({
                            position: 'center-center',
                            type: 'error',
                            title: 'Silme işlemi başarısız.',
                            showConfirmButton: false,
                            timer: 3000,
                            function() {
                                location.reload();
                            }
                        });
                    }
                }
            });


        } else {


                  Swal.fire({
                            position: 'center-center',

                            timer: 3000,
                        
                            title: 'İşlem iptal edildi!',
                            showConfirmButton: false,
                        })


        }





    }


</script>
@endsection