@extends('admin.layouts.app')
@section('content')
    <style>
        table.dataTable.no-footer {
            border-bottom: none !important;
        }


        .color-bordered-table.red-bordered-table {
            border: none !important;
        }

        .newButton {
            background-color: #00c292 !important;
        }
    </style>
    <link href="/assets/node_modules/switchery/dist/switchery.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="//cdn.datatables.net/1.13.2/css/jquery.dataTables.min.css">
    <div class="row page-titles">
        <div class="col-md-12">
            <h4 class="text-white">YSİİD</h4>
        </div>
        <div class="col-md-6">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Anasayfa</a></li>
                <li class="breadcrumb-item active">Ekspertiz Formları Listesi</li>
            </ol>
        </div>
        <div class="col-md-6 text-right">
            <form class="app-search d-none d-md-block d-lg-block">
                <input type="text" class="form-control" placeholder="Search &amp; enter">
            </form>
        </div>
    </div>
    {{-- @php 
      print_r($contactForms);
      exit;
      @endphp --}}
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if (session('status'))
                        <script>
                            $(document).ready(function() {
                                Swal.fire({
                                    position: 'center-center',
                                    type: 'success',
                                    title: '{{ session('status') }}',
                                    showConfirmButton: false,
                                    timer: 3000
                                })
                            });
                        </script>
                    @endif


                    <div class="table-responsive">
                        <table id="myTable" class="table color-bordered-table red-bordered-table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Adı</th>
                                    <th>Soyadı</th>
                                    <th>Telefon</th>
                                    <th>Adres</th>
                                    <th>Talep</th>
                                    <th>Daire Sayısı</th>
                                    <th>Blok Sayısı</th>
                                    <th>E-Posta</th>
                                    <th>Mesaj</th>
                                    <th>silme</th>
                                </tr>
                            </thead>
                            <tbody>

                                @foreach($ekspertizForms as $forms)
                                <tr>
                                    <td>{{$forms->Id}}</td>
                                    <td>{{$forms->ad}}</td>
                                    <td>{{$forms->soyad}}</td>
                                    <td>{{$forms->telefon}}</td>
                                    <td>{{$forms->adres}}</td>
                                    <td>{{$forms->talep}}</td>
                                    <td>{{$forms->dsayisi}}</td>
                                    <td>{{$forms->bsayisi}}</td>
                                    <td>{{$forms->eposta}}</td>
                                    <td>{{$forms->mesaj}}</td>
                                    
                                    <td>
                                        <button class="btn btn-danger btn-xs" onclick="del('{{$forms->Id}}')">Sil</button>
                                    </td>
                                    @endforeach
                                </tr>


                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <script src="//cdn.datatables.net/1.13.2/js/jquery.dataTables.min.js"></script>
    <script src="/assets/node_modules/switchery/dist/switchery.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.html5.min.js"></script>
    <script>
        $(function() {
            table = $('#myTable').DataTable({
                "responsive": true,
                "dom": '<"html5buttons"B>lTfgitp',
                "language": {
                    "url": "https://cdn.datatables.net/plug-ins/1.13.2/i18n/tr.json"
                },
                buttons: ['copy', 'csv', 'excel', 'pdf'],
            
            });

        });

        function createSeoLink(data) {
            return data;
        }


       

        function del(e) {
            var id = e;
            if (confirm("Silmek istiyor musunuz?") === true) {


                $.ajax({
                    type: "POST",
                    url: "{{ Route('ekspertizdeleteForms') }}",
                    data: {
                        id
                    },
                    success: function(response) {
                        let res = JSON.parse(response);
                        if (res.status) {

                            Swal.fire({
                                position: 'center-center',

                                timer: 3000,
                                type: 'success',
                                title: 'Silme işlemi başarılı',
                                showConfirmButton: false,
                            }).then(function() {
                                window.location.reload();
                            })

                        } else {
                            Swal.fire({
                                position: 'center-center',
                                type: 'error',
                                title: 'Silme işlemi başarısız.',
                                showConfirmButton: false,
                                timer: 3000,
                                function() {
                                    location.reload();
                                }
                            });
                        }
                    }
                });


            } else {


                Swal.fire({
                    position: 'center-center',

                    timer: 3000,

                    title: 'İşlem iptal edildi!',
                    showConfirmButton: false,
                })
            }
        }
    </script>
@endsection
