@extends('admin.layouts.app')
@section('content')
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js" integrity="sha512-8QFTrG0oeOiyWo/VM9Y8kgxdlCryqhIxVeRpWSezdRRAvarxVtwLnGroJgnVW9/XBRduxO/z1GblzPrMQoeuew==" crossorigin="anonymous"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.css" integrity="sha512-In/+MILhf6UMDJU4ZhDL0R0fEpsp4D3Le23m6+ujDWXwl3whwpucJG1PEmI3B07nyJx+875ccs+yX2CqQJUxUw==" crossorigin="anonymous" />
<link href="/assets/node_modules/bootstrap-tagsinput/dist/bootstrap-tagsinput.css" rel="stylesheet" />
<script src="/assets/node_modules/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js"></script>
<style>
    .bootstrap-tagsinput {
        width: 100% !important;
        height: 38px !important;
        background-color: #fff;
        background-clip: padding-box;
        border: 1px solid #e9ecef;
        border-radius: 0.25rem;
        display: flex;
        justify-content: flex-start;
        align-items: flex-start;
    }

    .bootstrap-tagsinput input {
        margin-top: 3px !important;
    }

    .label-info {
        margin-top: 6px !important;
    }
</style>

<div class="row page-titles">
    <div class="col-md-12">
        <h4 class="text-white">YSİİD</h4>
    </div>
    <div class="col-md-6">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/admin/panel">Anasayfa</a></li>
            <li class="breadcrumb-item active"><a href="{{route('blog.list')}}">Blog Listesi</a></li>
            <li class="breadcrumb-item active">Blog Düzenle</li>
        </ol>
    </div>
    <div class="col-md-6 text-right">
        <form class="app-search d-none d-md-block d-lg-block">
            <input type="text" value="{{$page->asd}}" class="form-control" placeholder="Search &amp; enter">
        </form>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Blog Düzenle</h4>
                <h6 class="card-subtitle">Yeni oluşturulan blog yazıları direkt olarak sitede yayınlanacaktır. </h6>
                <hr class="hr">


                  
                <form id="prForm" method="POST" action="{{ route('blog.Editsave', $page->id) }}" enctype="multipart/form-data">
                    @csrf
                    <button type=submit onclick="return false;" style="display:none;"></button>
                    <div class="row mt-4">
                        <div class="col-6">
                            <div class="form-group">
                                <label for="title" class="form-label">Haber Başlığı</label>
                                <input type="text" value="{{$page->title}}" onkeyup="slugGenerator(this)" class="form-control" name="title" id="title" placeholder="Bir başlık giriniz...">
                            </div>

                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <label for="title" class="form-label">Haber Başlığı İngilizce</label>
                                <input type="text" value="{{$page->title_en}}"  class="form-control" name="title_en" id="title_en" placeholder="İngilizce başlık giriniz...">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <div class="form-group seo_input">
                                <label for="title" class="form-label">Slug</label>
                                <input type="text" readonly value="{{$page->slug}}" onkeyup="slugGenerator(this)" class="form-control" name="slug" id="slug" placeholder="Bu alana girilen değer türkçe karakter boşluk ve - dışında sembol içermemelidir.">
                                <span style="color:red;font-weight:700;display:block;display:none" class="">Bu url kullanımda, bu url kullanılamaz. Bu alanı değiştirmeniz gerekmektedir.</span>
                                <small id="emailHelp" class="form-text text-muted">Buraya girilen adres https://netelsan.com/haber/[XXX] alanını temsil etmektedir.</small>

                            </div>

                            <div class="col-12">
                                <div class="form-group">
                                    <label for="title" class="form-label">Seo Description</label>
                                    <input type="text" value="{{$page->page_description}}" class="form-control" maxlength="160" name="page_description" id="slug" placeholder="">
                                    <small id="emailHelp" class="form-text text-muted">Bu alana eklemiş olduğunuz bilgiler
                                        google'ın arama sonuçlarında gözükecektir. 160 karakter ile sınırlıdır.</small>

                                </div>
                            </div>
                            <div class="col-12">
                                <div class="tags-default" style="width:100% !important;">
                                    <label for="title" class="form-label">Etiket Ekleyin</label><br>
                                    <input type="text" value="{{$page->page_keywords}}" style="width:100% !important;height:40px"  name="page_keywords" data-role="tagsinput" placeholder="Etiket Ekleyin" class="form-control" style="display: none;" />
                                </div>
                            </div>
                        </div>

                        <div class="col-6">
                            <label for="title" class="form-label">Kapak Fotoğrafı</label>
                            <input type="file" name="BreadcrumbBG" data-default-file="/uploads/{{$page->image_path}}" class="dropify" data-allowed-file-extensions="png jpg jpeg">

                        </div>
                    </div>
                    <div class="row mt-4">
                    </div>
                    <hr>
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="title" class="form-label">Türkçe İçerik</label>
                                <textarea class="ckeditor form-control" name="content">{{$page->content}}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="title" class="form-label">İngilizce İçerik</label>
                                <textarea class="ckeditor form-control" name="content_en">{{$page->content_en}}</textarea>
                            </div>
                        </div>
                    </div>






                    <div class="row">
                        <div class="col-12 text-right">
                            <input type="submit" value="Kaydet" title="Kaydet" class="btn btn-primary">
                        </div>
                    </div>

                </form>



            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    function blockSubmit() {
        return;
        Swal.fire({
            position: 'center-center',
            type: 'error',
            title: 'Kaydetmek için slug alanını düzenlemeniz gerekmektedir.',
            showConfirmButton: false,
            timer: 3000,
            function() {

            }
        });
        return false;
    }

    function slugGenerator(e) {
        return;
        var text = $(e).val();
        var trMap = {
            'çÇ': 'c',
            'ğĞ': 'g',
            'şŞ': 's',
            'üÜ': 'u',
            'ıİ': 'i',
            'öÖ': 'o'
        };
        for (var key in trMap) {
            text = text.replace(new RegExp('[' + key + ']', 'g'), trMap[key]);
        }


        let seo_data = {
            "seo_data": text.replace(/[^-a-zA-Z0-9\s]+/ig, '').replace(/\s/gi, "-").replace(/[-]+/gi, "-").toLowerCase(),
            "_token": "{{ csrf_token() }}"
        }

        $.ajax({
            type: "POST",
            url: "{{route('blog.ajaxSluq')}}",
            data: seo_data,
            success: function(response) {
                response = JSON.parse(response);
                if (response.status) {
                    $(".seo_input").find('input').css('border', '1px solid #e9ecef');
                    $(".seo_input").find('span').css('display', 'none');
                    $("#prForm").removeAttr('onsubmit');
                } else {
                    $(".seo_input").find('input').css('border', '1px solid red');
                    $(".seo_input").find('span').css('display', 'block');
                    $("#prForm").attr('onsubmit', 'return blockSubmit()');
                }

            }
        });



        $("#slug").val(text.replace(/[^-a-zA-Z0-9\s]+/ig, '').replace(/\s/gi, "-").replace(/[-]+/gi, "-").toLowerCase());
    }



    CKEDITOR.plugins.addExternal('BootstrapEditor', '/ckeditor/bootstrap/plugins/BootstrapEditor/plugin.js');

    CKEDITOR.replace('content', {
        filebrowserUploadUrl: "{{ route('ckeditor.image-upload', ['_token' => csrf_token()]) }}",
        filebrowserUploadMethod: 'form',
        allowedContent: true,
        extraPlugins: 'BootstrapEditor',
        apiKey: "EZAODFLT",

        removePlugins: "iframe"
    });
    CKEDITOR.replace('content_en', {
        filebrowserUploadUrl: "{{ route('ckeditor.image-upload', ['_token' => csrf_token()]) }}",
        filebrowserUploadMethod: 'form',
        allowedContent: true,
        extraPlugins: 'BootstrapEditor',
        apiKey: "EZAODFLT",

        removePlugins: "iframe"
    });




    $(document).ready(function() {
        $('.dropify').dropify({
            "messages": {
                'default': 'Bir dosyayı buraya sürükleyip bırakın veya tıklayın',
                'replace': 'Değiştirmek için sürükleyip bırakın veya tıklayın',
                'remove': 'Kaldır',
                'error': 'Hay aksi, yanlış bir şey oldu.'
            },
            "error": {
                'fileSize': 'Dosya boyutu çok büyük).',
                'minWidth': 'Görüntü genişliği çok küçük ).',
                'maxWidth': 'Görüntü genişliği çok büyük ).',
                'minHeight': 'Görüntü yüksekliği çok küçük ).',
                'maxHeight': 'Görüntü yüksekliği çok büyük ).',
                'imageFormat': 'Görüntü formatına izin verilmiyor ).'
            }
        });
        //   $('.dropify-clear').click(function(e){
        //      e.preventDefault();
        //      alert('Remove Hit');
        //   });
    });
</script>
@endsection