@extends('admin.layouts.app')
@section('content')

<style>
    table.dataTable.no-footer {
        border-bottom: none !important;
    }


    .color-bordered-table.red-bordered-table {
        border: none !important;
    }

    .newButton {
        background-color: #00c292 !important;
    }
</style>
<link href="/assets/node_modules/switchery/dist/switchery.min.css" rel="stylesheet" />
<link rel="stylesheet" href="//cdn.datatables.net/1.13.2/css/jquery.dataTables.min.css">
<div class="row page-titles">
    <div class="col-md-12">
        <h4 class="text-white">YSİİD</h4>
    </div>
    <div class="col-md-6">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="/admin/panel">Anasayfa</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Blog Yönetimi </a></li>
            <li class="breadcrumb-item active">Blog Listesi</li>
        </ol>
    </div>
    <div class="col-md-6 text-right">
        <form class="app-search d-none d-md-block d-lg-block">
            <input type="text" class="form-control" placeholder="Search &amp; enter">
        </form>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                @if(session('status'))
                <script>
                    $(document).ready(function() {
                        Swal.fire({
                            position: 'center-center',
                            type: 'success',
                            title: '{{session("status")}}',
                            showConfirmButton: false,
                            timer: 3000
                        })
                    });
                </script>

                @endif


                <table style="width: 100% !important;" id="myTable" class="table color-bordered-table red-bordered-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Kapak resmi</th>
                            <th>Blog Adı</th>
                            <th>Blog içerik</th>
                            <th>Blog slug</th>
                            <th>Güncelleme Zamanı</th>


                            <th>Aktif/Pasif</th>
                            <th>islem</th>

                        </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>


            </div>
        </div>
    </div>
</div>




<script src="//cdn.datatables.net/1.13.2/js/jquery.dataTables.min.js"></script>
<script src="/assets/node_modules/switchery/dist/switchery.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.html5.min.js"></script>
<script>
    const sehirListesi = [];
    let table = null;

   

    function regenerateTable() {

        Swal.fire({
            position: 'center-center',
            timer: 3000,
            type: 'success',
            title: 'İşlem başarılı',
            showConfirmButton: false,
        }).then(function() {
            table.ajax.reload(null, false);
        })
    }
    $(function() {
        table = $('#myTable').DataTable({
            "responsive": true,
            "dom": '<"html5buttons"B>lTfgitp',
             "order": [
                [0, "desc"]
            ],
            "language": {
                "url": "https://cdn.datatables.net/plug-ins/1.13.2/i18n/tr.json"
            },
            buttons: [{
                text: 'Yeni Ekle',
                className: "newButton",
                action: function(e, dt, node, config) {
                    _new();
                }
            }, 'copy', 'csv', 'excel', 'pdf'],
            processing: true,
            serverSide: true,
            ajax: "{{ route('blog.ajaxList') }}",

            "drawCallback": function(settings) {
                $('.js-switch').each(function() {
                    new Switchery($(this)[0], $(this).data());
                });
            },

            "columnDefs": [{
                    "targets": [0],
                    "visible": false,
                    "searchable": false
                },
                {
                    "render": createManageBtn,
                    "data": 1,
                    "id": 1,
                    "targets": [7]
                }, {
                    "render": createStatusSwitcher,
                    "data": 1,
                    "id": 1,
                    "targets": [6]
                }, {
                    "render": createImage,
                    "data": 1,
                    "id": 1,
                    "targets": [1]
                }
            ],
            columns: [{
                    data: 'id'
                },
                {
                    data: 'image_path',
    render: function(data, type, full, meta) {
       
data = `<img src="/uploads/${data}" style="height:50px;">`;

return data;
                }
                },
                {
                    data: 'title'
                },
                {
                    data: 'content',
    render: function(data, type, full, meta) {
        data=$("<div/>").html(data).text();
data = data.replace(/<[^>]*>/g, '');
if (data.length > 255) {
            data = data.substring(0, 255) + '...';
        }

return data;
                }},
                {
                    data: 'slug'
                },
                {
                    data: 'updated_at',
    render: function(data, type, full, meta) {
        const date = new Date(data);
        const formattedDate = date.toLocaleString('tr-TR', {
            year: 'numeric',
            month: '2-digit',
            day: '2-digit',
            hour: '2-digit',
            minute: '2-digit',
            second: '2-digit'
        });
        return formattedDate;
    }
                },
                {
                    data: 'b_status'
                },
                {
                    data: 'id'
                }
            ],

        });

    });

    function _new() {
        window.location.href = "/admin/blog/newpage";
    }

    function save() {
        let data = $("#form").serialize();
        data += "&_token={{ csrf_token() }}",

            $.ajax({
                type: "POST",
                url: "{{ route('bayi.save')}}",
                data: data,
                success: function(response) {
                    $('#staticBackdrop').modal('hide');
                    regenerateTable();
                }
            });
    }

    

    function createStatusSwitcher(x, y, data) {

        return ``;
    }

    function createImage(x, y, data) {

        return `<img class="img" style="height:50px" src="/uploads/${data.cover}" />`;
    }

    function createManageBtn(data) {
        let html = `
                <a id="manageBtn" type="button" href="/admin/blog/edit/${data}"  class="btn btn-success btn-xs">Düzenle</a>
                <button id="manageBtn" type="button" href="" onclick="del(${data})" class="btn btn-danger btn-xs">Sil</button>
             `;
        return html;
    }






    function del(id) {

        if (confirm("Silmek istiyor musunuz?") === true) {
            $.ajax({
                type: "POST",
                url: "{{route('blog.delete')}}",
                data: {
                    id: id,
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    let res = JSON.parse(response);
                    if (res.status) {

                        Swal.fire({
                            position: 'center-center',

                            timer: 2000,
                            type: 'success',
                            title: 'Silme işlemi başarılı',
                            showConfirmButton: false,
                        }).then(function() {
                            table.ajax.reload(null, false);
                        })

                    } else {
                        Swal.fire({
                            position: 'center-center',
                            type: 'error',
                            title: 'Silme işlemi başarısız.',
                            showConfirmButton: false,
                            timer: 2000,
                            function() {
                                table.ajax.reload(null, false);
                            }
                        });
                    }
                }
            });


        } else {


            Swal.fire({
                position: 'center-center',

                timer: 3000,

                title: 'İşlem iptal edildi!',
                showConfirmButton: false,
            })


        }

    }
</script>
@endsection