<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class uyeLoginControl
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if ($request->route()->uri != 'e-ysiid' && $request->route()->uri != 'e-ysiid/logout' && $request->route()->uri != 'e-ysiid/register'  && $request->route()->uri != 'e-ysiid/register-step-two') {
            if (!$request->session()->get('uye_login', false)) {
                header('Location:/e-ysiid');
                exit;
            }
        }
        return $next($request);
    }
}