<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class LoginControl
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if ($request->route()->uri != 'admin/login' && $request->route()->uri != 'admin/login-progress') {
           if (!$request->session()->get('login', false)) {
                header('Location:/admin/login');
                exit;
           }
        }
        return $next($request);
    }
}
