<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class Locale
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
    */
    public function handle(Request $request, Closure $next)
    {
        if($request->session()->has('locale')){
           $lng =  $request->session()->get('locale');
            app()->setLocale($lng);
        }else{

            $lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2);
            if($lang === "tr"){
                 app()->setLocale("tr");
            }else{
                 app()->setLocale("en");
            }
           
        }
        return $next($request);
    }
}
