<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use App\Models\Products;
use Illuminate\Support\Facades\DB;
use stdClass;
use Yajra\DataTables\DataTables;
use App;
use Intervention\Image\Facades\Image;

class productsController extends Controller



{

    function slugify($text)
    {
        $find = array('Ç', 'Ş', 'Ğ', 'Ü', 'İ', 'Ö', 'ç', 'ş', 'ğ', 'ü', 'ö', 'ı', '+', '#');
        $replace = array('c', 's', 'g', 'u', 'i', 'o', 'c', 's', 'g', 'u', 'o', 'i', 'plus', 'sharp');
        $text = strtolower(str_replace($find, $replace, $text));
        $text = preg_replace("@[^A-Za-z0-9\-_\.\+]@i", ' ', $text);
        $text = trim(preg_replace('/\s+/', ' ', $text));
        $text = str_replace(' ', '-', $text);

        return $text;
    }


    function getFrontedCategoryProducts(Request $request)
    {
        $category_all = DB::select('select * from products_category');
        foreach ($category_all as $cat)
            if ($this->slugify($cat->menuTitle) == $request->category) {
                $categoryID = $cat->id;
                $category = $cat;
            }
        if (empty($categoryID)) return abort(404);
        $current_category = $categoryID;


        $childCategories = DB::select('select id from products_category where menuParent = ' . $categoryID);
        $sql = "select products.*,products_category.menuTitle,products_category.menuTitleEn from products left join products_category on products_category.id =  products.cat_id where  ";
        $sqlWhere = "";
        foreach ($childCategories as $child) {
            $sqlWhere .= " or cat_id = " . $child->id;
        }
        $sqlWhere .= " or cat_id = " . $categoryID;
        $sqlWhere = trim($sqlWhere, " or");


        $data = DB::select($sql . $sqlWhere);
        $exportData = [];
        $title = $category->menuTitle . " | " . "Netelsan Güvenli Yaşam Teknolojileri";






        foreach ($data as $item) {
            $parent = DB::select("SELECT t1.id, t1.menuTitle, t1.menuParent, t2.menuTitle AS parentTitle, t2.menuParent, t3.menuTitle AS grandparentTitle FROM products_category AS t1 JOIN products_category AS t2 ON t1.menuParent = t2.id JOIN products_category AS t3 ON t2.menuParent = t3.id WHERE t1.id = $item->cat_id UNION SELECT t1.id, t1.menuTitle, t1.menuParent, t2.menuTitle AS parentTitle, t2.menuParent, t3.menuTitle AS grandparentTitle FROM products_category AS t1 JOIN ( SELECT t3.menuParent, t3.id FROM products_category AS t3 WHERE t3.id = $item->cat_id ) AS t4 ON t1.id = t4.id JOIN products_category AS t2 ON t4.menuParent = t2.id JOIN products_category AS t3 ON t2.menuParent = t3.id");
            if (!empty($parent)) {
                $pUrl = "/urun/" . $this->slugify($parent[0]->grandparentTitle) . "/" . $this->slugify($parent[0]->parentTitle) . "/" . $this->slugify($parent[0]->menuTitle) . "/" . $item->product_title_seo;
            } else {
                $pUrl = "/urun/" . $this->slugify($item->menuTitle) . "/" . $item->product_title_seo;
            }
            $item->purl = $pUrl;

            $exportData[$item->cat_id]['category_id'] = $item->cat_id;
            $exportData[$item->cat_id]['menuTitle'] = $item->menuTitle;
            $exportData[$item->cat_id]['menuTitleEn'] = $item->menuTitleEn;

            $exportData[$item->cat_id]['urunler'][] = [$item];
        }



        return view('pages.getProductCategory', compact('exportData', 'category', 'category_all', 'current_category', 'title'));
    }









    function getCategoryAndParents($categoryId)
    {
        $category = DB::table('products_category')->select('id', 'menuTitle', 'menuTitleEn', 'menuParent')->find($categoryId);
        $result = array();

        while ($category) {
            $result[] = $category;
            $category = DB::table('products_category')->select('id', 'menuTitle', 'menuTitleEn', 'menuParent')->find($category->menuParent);
        }

        return array_reverse($result);
    }




    function getProductsDetail(Request $request)
    {

        $page_category  = str_replace('.', '', $request->category);
        $data = Products::where('product_title_seo', '=', $request->urun)->where('product_status', '=', 'on')->first();
        $categoryCheck = DB::select('select * from products_category where id = ' . $data->cat_id);
        $category = $categoryCheck[0];
        if (!$data) {
            return abort(404);
        } else {
            $parent = DB::select("SELECT t1.id, t1.menuTitle, t1.menuParent, t2.menuTitle AS parentTitle, t2.menuParent, t3.menuTitle AS grandparentTitle FROM products_category AS t1 JOIN products_category AS t2 ON t1.menuParent = t2.id JOIN products_category AS t3 ON t2.menuParent = t3.id WHERE t1.id = $category->id UNION SELECT t1.id, t1.menuTitle, t1.menuParent, t2.menuTitle AS parentTitle, t2.menuParent, t3.menuTitle AS grandparentTitle FROM products_category AS t1 JOIN ( SELECT t3.menuParent, t3.id FROM products_category AS t3 WHERE t3.id = $category->id ) AS t4 ON t1.id = t4.id JOIN products_category AS t2 ON t4.menuParent = t2.id JOIN products_category AS t3 ON t2.menuParent = t3.id");
            if (!empty($parent)) {
                $category_url = "/urun/" . $this->slugify($parent[0]->grandparentTitle) . "/" . $this->slugify($parent[0]->parentTitle) . "/" . $this->slugify($parent[0]->menuTitle) . "/";
            } else {
                $category_url = "/urun/" . $this->slugify($category->menuTitle) . "/" . $this->slugify($category->menuTitle) . "/";
            }
            $get_category_product = Products::where('cat_id', '=', $category->id)->get();

            $parent_categories = $this->getCategoryAndParents($category->id);
            foreach ($parent_categories as $item) {
                $item->url = $this->slugify($item->menuTitle);
            }
            $current_items = new \stdClass();
            $current_items->id = $data->product_id;
            $current_items->menuTitle = $data->product_title;
            $current_items->menuTitleEn = $data->product_title_en;
            $current_items->menuParent = "#";
            $current_items->url = $this->slugify($data->product_title);
            array_push($parent_categories, $current_items);
            $title = App::getLocale() == 'tr' ? $data->product_title . " - " . "Netelsan Güvenli Yaşam Teknolojileri" : $data->product_title_en . " - " . "Netelsan a better way of secure life";
            $dc = $data->product_description;
            $keywords = $data->product_keywords;
            return view('pages.showProduct', compact('data', 'category', 'get_category_product', 'category_url', 'parent_categories', 'title', 'dc','keywords'));
        }
    }





    // ================================= Admin =======================================
    function getproducts(Request $request)
    {
        $pages = Products::where('product_title_seo', '=', "$request->slug")->where('product_status', '=', 'on')->first();
        $categoryPages = Products::where('cat_id', '=', $pages->cat_id)->orderBy('product_order', 'desc')->where('product_status', '=', 'on')->get();
        $title = $pages->product_title;
        return view('pages.pages', compact('title', 'pages', 'categoryPages'));
    }

    function product_category_list(Request $request)
    {
        $menu = DB::select('select * from products_category');
        return view('admin.pages.products_categories', compact('menu'));
    }

    function product_category_list_save(Request $request)
    {
        $response = new \stdClass();
        $category_name_tr = $request->category_name_tr;
        $category_name_en = $request->category_name_en;
        $data = DB::table('products_category')->insert([
            'kategori_adi' => $category_name_tr,
            'kategori_adi_en' => $category_name_en
        ]);
        $response->status = ($data) ? true : false;
        print_r(json_encode($response));
    }

    function product_category_edit_save(Request $request)
    {
        $response = new \stdClass();
        $category_name_tr = $request->category_name_tr;
        $category_name_en = $request->category_name_en;
        $data = DB::table('products_category')->where(['id' => $request->id])->update([
            'kategori_adi' => $category_name_tr,
            'kategori_adi_en' => $category_name_en
        ]);
        $response->status = ($data) ? true : false;
        print_r(json_encode($response));
    }
    function product_category_delete(Request $request)
    {
        $response = new \stdClass();
        $data = DB::table('products_category')->where(['id' => $request->id])->delete();
        $response->status = ($data) ? true : false;
        print_r(json_encode($response));
    }

    function delete(Request $request)
    {
        $id = $request->id;
        $response = new \stdClass();
        $new_product = new Products;
        $data = $new_product::where(['product_id' => $id])->delete();
        $response->status = ($data) ? true : false;
        print_r(json_encode($response));
    }

    public function newproduct()
    {
        $category = DB::select('select * from products_category');
        return view('admin.pages.newProduct', compact('category'));
    }

    public function newproduct_save(Request $request)
    {
        $new_product = new Products;
        if ($request->hasFile('BreadcrumbBG')) {
            $originName = $request->file('BreadcrumbBG')->getClientOriginalName();
            $fileName = pathinfo($originName, PATHINFO_FILENAME);
            $extension = $request->file('BreadcrumbBG')->getClientOriginalExtension();
            $fileName = $fileName . '_' . time() . '.' . $extension;
            $request->file('BreadcrumbBG')->move(public_path('uploads'), $fileName);







            $image = Image::make(public_path('uploads/') . $fileName)->encode('jpg', 90);
            $image->save(public_path('uploads/') . $fileName);

            $new_product->BreadcrumbBG = $fileName;
        }
        if ($request->hasFile('product_images')) {
            $originName = $request->file('product_images')->getClientOriginalName();
            $fileName = pathinfo($originName, PATHINFO_FILENAME);
            $extension = $request->file('product_images')->getClientOriginalExtension();
            $fileName = $fileName . '_' . time() . '.' . $extension;
            $request->file('product_images')->move(public_path('uploads'), $fileName);
            $new_product->product_images = $fileName;

            
            $image = Image::make(public_path('uploads/') . $fileName)->resize(250, null, function ($constraint) {
                $constraint->aspectRatio();
            })->encode('jpg', 90);
            $image->save(public_path('uploads/thumb_') . $fileName);




            $imageFull = Image::make(public_path('uploads/') . $fileName)->resize(800, null, function ($constraint) {
                $constraint->aspectRatio();
            })->encode('jpg', 90);
            $imageFull->save(public_path('uploads/') . $fileName);






        }
        $new_product->product_title = $request->product_title;
        $new_product->product_title_en = $request->product_title_en;
        $new_product->product_title_seo = $request->product_title_seo;
        $new_product->content = $request->content;
        $new_product->content_en = $request->content_en;
        $new_product->product_keywords = $request->product_keywords;
        $new_product->product_description = $request->product_description;
        $new_product->cat_id = $request->cat_id;
        if ($new_product->save()) {
            $request->session()->flash('status', 'Ekleme işlemi başarılı');
        } else {
            $request->session()->flash('status', 'Bir hata oluştu. Sistem yöneticisine haber veriniz.');
        }
        return redirect()->route('product.list');
    }
    public function list(Request $request)
    {
        $products = Products::all()->sortByDesc("product_id");
        return view('admin.pages.product_list', compact('products'));
    }

    public function statusChanger(Request $request)
    {
        $response = new \stdClass();
        $check = Products::where(['product_id' => $request->id])->first();
        $product_status = ($check->product_status == "on") ? "off" : "on";
        $update = Products::where(['product_id' => $request->id])->update(["product_status" => $product_status]);
        $response->status =  ($update) ? true : false;
        print_r(json_encode($response));
    }

    public function productEdit(Request $request)
    {
        $page = Products::where(['product_id' => $request->id])->first();
        $category = DB::select('select * from products_category');
        return view('admin.pages.editProduct', compact('category', 'page'));
    }

    public function productEdit_save(Request $request)
    {
        $id = $request->id;
        $new_product = Products::findOrFail($id);
        if ($request->hasFile('BreadcrumbBG')) {
            $originName = $request->file('BreadcrumbBG')->getClientOriginalName();
            $fileName = pathinfo($originName, PATHINFO_FILENAME);
            $extension = $request->file('BreadcrumbBG')->getClientOriginalExtension();
            $fileName = $fileName . '_' . time() . '.' . $extension;
            $request->file('BreadcrumbBG')->move(public_path('uploads'), $fileName);

            $image = Image::make(public_path('uploads/') . $fileName)->encode('jpg', 90);
            $image->save(public_path('uploads/') . $fileName);

            $new_product->BreadcrumbBG = $fileName;
        }
        if ($request->hasFile('product_images')) {
            $originName = $request->file('product_images')->getClientOriginalName();
            $fileName = pathinfo($originName, PATHINFO_FILENAME);
            $extension = $request->file('product_images')->getClientOriginalExtension();
            $fileName = $fileName . '_' . time() . '.' . $extension;
            $request->file('product_images')->move(public_path('uploads'), $fileName);

            
            $image = Image::make(public_path('uploads/') . $fileName)->resize(250, null, function ($constraint) {
                $constraint->aspectRatio();
            })->encode('jpg', 90);
            $image->save(public_path('uploads/thumb_') . $fileName);



            $imageFull = Image::make(public_path('uploads/') . $fileName)->resize(800, null, function ($constraint) {
                $constraint->aspectRatio();
            })->encode('jpg', 90);
            $imageFull->save(public_path('uploads/') . $fileName);


            $new_product->product_images = $fileName;
        }
        $new_product->product_title = $request->product_title;
        $new_product->product_title_en = $request->product_title_en;
        $new_product->product_title_seo = $request->product_title_seo;
        $new_product->content = $request->content;
        $new_product->content_en = $request->content_en;
        $new_product->product_keywords = $request->product_keywords;
        $new_product->product_description = $request->product_description;
        $new_product->cat_id = $request->cat_id;
        if ($new_product->update()) {
            $request->session()->flash('status', 'Güncelleme işlemi başarılı');
        } else {
            $request->session()->flash('status', 'Bir hata oluştu. Sistem yöneticisine haber veriniz.');
        }
        return redirect()->route('product.list');
    }

    public function ajaxList()
    {
        $query =  DB::Select("SELECT product_id, product_title,product_title_seo,product_status,updated_at,product_id as id
         from products ");
        return DataTables::of($query)->toJson();
    }
    public function ajaxSluq(Request $request)
    {
        $response = new \stdClass();
        if (Products::where(['product_title_seo' => $request->seo_data])->count() != 0) {
            $response->status = false;
        } else {
            $response->status = true;
        }
        print_r(json_encode($response));
    }

    public function uniq_seo()
    {
        // $unique_product_title_seos = DB::table('products')->select('product_title_seo')->distinct()->get();
        // foreach ($unique_product_title_seos as $unique_product_title_seo) {
        // $unique_product_title_seos = DB::table('products')
        //     ->select('product_title_seo')
        //     ->distinct()
        //     ->get();

        //     foreach ($unique_product_title_seos as $unique_product_title_seo) {
        //         $product_title_seo = $unique_product_title_seo->product_title_seo;
        //         $product_count = DB::table('products')
        //             ->where('product_title_seo', $product_title_seo)
        //             ->count();
        //         if ($product_count > 1) {
        //             $random_str = "_" . substr(str_shuffle('0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'), 0, 6);
        //             $original_product = DB::table('products')
        //                 ->where('product_title_seo', $product_title_seo)
        //                 ->orderBy('product_id')
        //                 ->first();
        //             DB::table('products')
        //                 ->where('product_title_seo', $product_title_seo)
        //                 ->where('product_id', '<>', $original_product->product_id)
        //                 ->update(['product_title_seo' => $product_title_seo . $random_str]);
        //         }
        //     }
        // }


    }
}
