<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use App\Models\Pages;
use Illuminate\Support\Facades\DB;
use App;
use Intervention\Image\Facades\Image;

class pagesController extends Controller
{
    //
    function getPage(Request $request)
    {
      

       
            $pages = Pages::where('page_title_seo', '=', "$request->slug")->where('page_status', '=', 'on')->first();
            if (empty($pages)) {
                return abort(404);
                exit;
            }
            if ($pages->cat_id) {
                $categoryPages = Pages::where('cat_id', '=', $pages->cat_id)->orderBy('page_order', 'desc')->where('page_status', '=', 'on')->get();
            } else {
                $categoryPages = null;
            }
            
            $title = $pages->page_title;
            $keyword = $pages->page_keywords;
            $description = $pages->page_description;

            return view('pages.pages', compact('title', 'pages', 'categoryPages','keyword', 'description'));
      
    }

    function page_builder($page){
        $pageName = "pages.static.".$page->target;
   
        if(App::getLocale() == "tr"){
            $title = $page->menuTitle." | Netelsan Güvenli Yaşam Teknolojileri";
        }else{
            $title = $page->menuTitleEn." | Netelsan A Better Way Of Secure Life";
        }
    
        return view($pageName,compact('title', 'page'));
    }




    // ----------------  Aşağıdaki fonksiyonları admin panel kullanır ------------------

    function page_category_list(Request $request)
    {
       
        $data = DB::select('select * from page_category');
        return view('admin.pages.page_categories', compact('data'));
    }

    function page_category_list_save(Request $request)
    {
        $response = new \stdClass();
        $category_name_tr = $request->category_name_tr;
        $category_name_en = $request->category_name_en;
        $data = DB::table('page_category')->insert([
            'kategori_adi' => $category_name_tr,
            'kategori_adi_en' => $category_name_en
        ]);
        $response->status = ($data) ? true : false;
        print_r(json_encode($response));
    }

    function page_category_edit_save(Request $request)
    {
        $response = new \stdClass();
        $category_name_tr = $request->category_name_tr;
        $category_name_en = $request->category_name_en;
        $data = DB::table('page_category')->where(['id' => $request->id])->update([
            'kategori_adi' => $category_name_tr,
            'kategori_adi_en' => $category_name_en
        ]);
        $response->status = ($data) ? true : false;
        print_r(json_encode($response));
    }

    function page_category_delete(Request $request)
    {
        $response = new \stdClass();
        $data = DB::table('page_category')->where(['id' => $request->id])->delete();
        $response->status = ($data) ? true : false;
        print_r(json_encode($response));
    }

    public function newpage()
    {
        $category = DB::select('select * from page_category');
        return view('admin.pages.newPage', compact('category'));
    }

    public function newpage_save(Request $request)
    {
        $new_page = new Pages;

        if ($request->hasFile('BreadcrumbBG')) {
            $originName = $request->file('BreadcrumbBG')->getClientOriginalName();
            $fileName = pathinfo($originName, PATHINFO_FILENAME);
            $extension = $request->file('BreadcrumbBG')->getClientOriginalExtension();
            $fileName = $fileName . '_' . time() . '.' . $extension;
            $request->file('BreadcrumbBG')->move(public_path('uploads'), $fileName);

            $imageFull = Image::make(public_path('uploads/').$fileName)->resize(1920, null, function ($constraint) {
                $constraint->aspectRatio();
                })->encode('jpg', 90);
            $imageFull->save(public_path('uploads/').$fileName);



            $new_page->BreadcrumbBG = $fileName;
        }

        $new_page->page_title = $request->page_title;
        $new_page->page_title_en = $request->page_title_en;
        $new_page->page_title_seo = $request->page_title_seo;
        $new_page->content = $request->content;
        $new_page->content_en = $request->content_en;
        $new_page->page_keywords = $request->page_keywords;
        $new_page->page_description = $request->page_description;
        $new_page->cat_id = $request->cat_id;
        $new_page->page_order = $request->page_order;



        if ($new_page->save()) {
            $request->session()->flash('status', 'Ekleme işlemi başarılı');
        } else {
            $request->session()->flash('status', 'Bir hata oluştu. Sistem yöneticisine haber veriniz.');
        }

        return redirect()->route('list');
    }

    public function delete(Request $request)
    {
        $id = $request->id;
        $response = new \stdClass();
        $new_product = new Pages;
        $data = $new_product::where(['page_id' => $id])->delete();
        $response->status = ($data) ? true : false;
        print_r(json_encode($response));
    }



    public function list(Request $request)
    {
        //TODO Order by nasıl ekleniyor??
        $pages = Pages::all()->sortByDesc("page_id");
        return view('admin.pages.page_list', compact('pages'));
    }

    public function statusChanger(Request $request)
    {

        $response = new \stdClass();
        $check = Pages::where(['page_id' => $request->id])->first();
        $page_status = ($check->page_status == "on") ? "off" : "on";
        $update = Pages::where(['page_id' => $request->id])->update(["page_status" => $page_status]);
        $response->status =  ($update) ? true : false;
        print_r(json_encode($response));
    }

    public function pageEdit(Request $request)
    {
        $page = Pages::where(['page_id' => $request->id])->first();
        $category = DB::select('select * from page_category');
        return view('admin.pages.editPage', compact('category', 'page'));
    }

    public function pageEdit_save(Request $request)
    {
        $id = $request->id;


        $new_page = Pages::findOrFail($id);

        if ($request->hasFile('BreadcrumbBG')) {
            $originName = $request->file('BreadcrumbBG')->getClientOriginalName();
            $fileName = pathinfo($originName, PATHINFO_FILENAME);
            $extension = $request->file('BreadcrumbBG')->getClientOriginalExtension();
            $fileName = $fileName . '_' . time() . '.' . $extension;
            $request->file('BreadcrumbBG')->move(public_path('uploads'), $fileName);

            $imageFull = Image::make(public_path('uploads/').$fileName)->resize(1920, null, function ($constraint) {
                $constraint->aspectRatio();
            })->encode('jpg', 90);
            $imageFull->save(public_path('uploads/').$fileName);


            $new_page->BreadcrumbBG = $fileName;
        }

        $new_page->page_title = $request->page_title;
        $new_page->page_title_en = $request->page_title_en;
        $new_page->page_title_seo = $request->page_title_seo;
        $new_page->content = $request->content;
        $new_page->content_en = $request->content_en;
        $new_page->page_keywords = $request->page_keywords;
        $new_page->page_description = $request->page_description;
        $new_page->cat_id = $request->cat_id;
        $new_page->page_order = $request->page_order;
        if ($new_page->update()) {
            $request->session()->flash('status', 'Güncelleme işlemi başarılı');
        } else {
            $request->session()->flash('status', 'Bir hata oluştu. Sistem yöneticisine haber veriniz.');
        }

        return redirect()->route('list');
    }
}
