<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\News;
use Illuminate\Support\Facades\DB;
use App;
use Yajra\DataTables\DataTables;
use Intervention\Image\Facades\Image;



class newsController extends Controller
{



    public function haberler(Request $request)
    {

        $news = News::orderBy('page_id', 'desc')->paginate(10);
        $news2 = News::orderBy('page_id', 'desc')->take(3)->get();

        return view('pages.haberler', compact('news', 'news2'));
    }

    public function singleNews(Request $request)
    {
        $singleNews =   News::where(['page_title_seo' => $request->slug])->first();
        $otherNews = News::where('page_id', '<>', $singleNews->page_id)->orderByDesc('page_id')->take(6)->get();
        return view('pages.singleNews', compact('singleNews', 'otherNews'));
        print_r($otherNews);
    }



    // ----------------------- Admin -------------------------------
    function list()
    {
        return view('admin.pages.newsListe');
    }

    public function ajaxList()
    {
        $query =  DB::Select("SELECT page_id, cover, page_title, page_title_seo ,created_at ,updated_at, page_status , page_id as id from news");
        return DataTables::of($query)->toJson();
    }
    public function newpage()
    {
        return view('admin.pages.newNews');
    }
    public function newpage_save(Request $request)
    {
        $new_page = new News;
        if ($request->hasFile('BreadcrumbBG')) {
            $originName = $request->file('BreadcrumbBG')->getClientOriginalName();
            $fileName   = pathinfo($originName, PATHINFO_FILENAME);
            $extension  = $request->file('BreadcrumbBG')->getClientOriginalExtension();
            $fileName   = $fileName . '_' . time() . '.' . $extension;
            $request->file('BreadcrumbBG')->move(public_path('uploads'), $fileName);

            $imageThumbFull = Image::make(public_path('uploads/') . $fileName)->resize(180, null, function ($constraint) {
                $constraint->aspectRatio();
            })->encode('jpg', 90);
            $imageThumbFull->save(public_path('uploads/thumb_') . $fileName);


            $imageFull = Image::make(public_path('uploads/') . $fileName)->resize(800, null, function ($constraint) {
                $constraint->aspectRatio();
            })->encode('jpg', 90);
            $imageFull->save(public_path('uploads/') . $fileName);




            $new_page->cover = $fileName;
        }

        $new_page->page_title = $request->page_title;
        $new_page->page_title_en = $request->page_title_en;
        $new_page->page_title_seo = $request->page_title_seo;
        $new_page->content = $request->content;
        $new_page->content_en = $request->content_en;
        $new_page->page_keywords = $request->page_keywords;
        $new_page->page_description = $request->page_description;
        $new_page->page_order = $request->page_order;
        if ($new_page->save()) {
            $request->session()->flash('status', 'Ekleme işlemi başarılı');
        } else {
            $request->session()->flash('status', 'Bir hata oluştu. Sistem yöneticisine haber veriniz.');
        }
        return redirect()->route('news.list');
    }
    public function ajaxSluq(Request $request)
    {
        $response = new \stdClass();
        if (News::where(['page_title_seo' => $request->seo_data])->count() != 0) {
            $response->status = false;
        } else {
            $response->status = true;
        }
        print_r(json_encode($response));
    }
    public function delete(Request $request)
    {
        $response = new \stdClass();
        $id = $request->id;
        $Bayi = News::find($id);
        $response->status = ($Bayi->delete()) ? true : false;
        echo json_encode($response);
    }
    public function edit(Request $request)
    {
        $page = News::where(['page_id' => $request->id])->first();
        return view('admin.pages.editNews', compact('page'));
    }
    public function pageEdit_save(Request $request)
    {
        $id = $request->id;
        $new_page = News::findOrFail($id);

        if ($request->hasFile('BreadcrumbBG')) {
            $originName = $request->file('BreadcrumbBG')->getClientOriginalName();
            $fileName = pathinfo($originName, PATHINFO_FILENAME);
            $extension = $request->file('BreadcrumbBG')->getClientOriginalExtension();
            $fileName = $fileName . '_' . time() . '.' . $extension;
            $request->file('BreadcrumbBG')->move(public_path('uploads'), $fileName);

            $imageThumbFull = Image::make(public_path('uploads/') . $fileName)->resize(180, null, function ($constraint) {
                $constraint->aspectRatio();
            })->encode('jpg', 90);
            $imageThumbFull->save(public_path('uploads/thumb_') . $fileName);
            $imageFull = Image::make(public_path('uploads/') . $fileName)->resize(800, null, function ($constraint) {
                $constraint->aspectRatio();
            })->encode('jpg', 90);
            $imageFull->save(public_path('uploads/') . $fileName);





            $new_page->cover = $fileName;
        }

        $new_page->page_title = $request->page_title;
        $new_page->page_title_en = $request->page_title_en;
        $new_page->page_title_seo = $request->page_title_seo;
        $new_page->content = $request->content;
        $new_page->content_en = $request->content_en;
        $new_page->page_keywords = $request->page_keywords;
        $new_page->page_description = $request->page_description;
        $new_page->cat_id = $request->cat_id;
        $new_page->page_order = $request->page_order;
        if ($new_page->update()) {
            $request->session()->flash('status', 'Güncelleme işlemi başarılı');
        } else {
            $request->session()->flash('status', 'Bir hata oluştu. Sistem yöneticisine haber veriniz.');
        }
        return redirect()->route('news.list');
    }
}
