<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use stdClass;
use Yajra\DataTables\DataTables;
use App;
use App\Models\log;

class memberController extends Controller
{
    function list()
    {
        return view('admin.pages.member.list');
    }
    public function ajaxList()
    {
        $query = DB::Select("SELECT id, name, surname, isLegal,corporate_name,approved,phone,email,isActive,id as 'islem'
         from uye ");
        return DataTables::of($query)->toJson();
    }

    public function check()
    {

        $data = DB::select('select check_list.id as cID,check_list.updated_at, uye.* from check_list left join uye on check_list.uye_id = uye.id where uye.corporate_name <> "" order by id desc');


        return view('admin.pages.member.check_list', compact('data'));
    }
    public function edit(Request $request)
    {

        $id = (int) $_GET['id'];

       


        DB::delete('delete from check_list where uye_id = ?', [$id]);
 
        $sehirler = ["Adana", "Adıyaman", "Afyon", "Ağrı", "Amasya", "Ankara", "Antalya", "Artvin", "Aydın", "Balıkesir", "Bilecik", "Bingöl", "Bitlis", "Bolu", "Burdur", "Bursa", "Çanakkale", "Çankırı", "Çorum", "Denizli", "Diyarbakır", "Edirne", "Elazığ", "Erzincan", "Erzurum", "Eskişehir", "Gaziantep", "Giresun", "Gümüşhane", "Hakkari", "Hatay", "Isparta", "İçel (Mersin)", "İstanbul", "İzmir", "Kars", "Kastamonu", "Kayseri", "Kırklareli", "Kırşehir", "Kocaeli", "Konya", "Kütahya", "Malatya", "Manisa", "Kahramanmaraş", "Mardin", "Muğla", "Muş", "Nevşehir", "Niğde", "Ordu", "Rize", "Sakarya", "Samsun", "Siirt", "Sinop", "Sivas", "Tekirdağ", "Tokat", "Trabzon", "Tunceli", "Şanlıurfa", "Uşak", "Van", "Yozgat", "Zonguldak", "Aksaray", "Bayburt", "Karaman", "Kırıkkale", "Batman", "Şırnak", "Bartın", "Ardahan", "Iğdır", "Yalova", "Karabük", "Kilis", "Osmaniye", "Düzce"];
        $uye = DB::select('select * from uye where id = ? limit 1', [$id])[0];
   
       
        $settings = DB::select('select * from settings limit 1')[0];
        return view('admin.pages.member.edit', compact('settings', 'uye', 'sehirler'));


    }


    public function approvedChanger(Request $request)
    {
        $id = $request->uyeid;
        DB::table('uye')->where('id', $id)->update(['approved' => $request->appdata]);
        return response()->json(['status' => true]);
    }


    public function isActiveChanger(Request $request)
    {
        $id = $request->uyeid;
        DB::table('uye')->where('id', $id)->update(['isActive' => $request->isdata]);
        return response()->json(['status' => true]);
    }

    public function register_pay(Request $request)
    {
        $id = $request->uyeid;
        DB::table('uye')->where('id', $id)->update(['register_pay' => $request->appdata]);
        return response()->json(['status' => true]);
    }



    public function receiptList(Request $request)
    {
        $id = $request->id;
        $upload_folder = "uploads/sra/" . md5($id . 'MB') . "/receipt";

        if (file_exists($upload_folder)) {
            $files = array_diff(scandir($upload_folder), array('.', '..')); 
            $sorted_files = array();
            foreach ($files as $file) {
                $sorted_files[$file] = filemtime($upload_folder . '/' . $file);
            }
            arsort($sorted_files); 
            $sorted_files = array_keys($sorted_files); 

            $file_objects = array();
            foreach ($sorted_files as $file) {
                $file_obj = new stdClass();
                $file_obj->name = $file;
                $file_obj->upload_date = date("d.m.Y H:i:s", filemtime($upload_folder . '/' . $file));
                $file_objects[] = $file_obj;
            }
            return response()->json($file_objects);
        }

    }

    public function odemeler(Request $request){
      
                return view('admin.pages.member.odemeler');
    }
    

    public function odemelerajax(Request $request){
            $query = DB::Select("SELECT 
            pay_detail.id as 'id',
            uye.corporate_name as 'corporate_name',
            uye.name as 'name',
            uye.surname as 'surname',
            pay_detail.amount as 'amount',
            pay_detail.start_date as 'start_date',
            pay_detail.dateTime as 'dateTime',
            pay_detail.file_path as 'file_path',
            pay_detail.pay as 'islem'
            from pay_detail left join uye on pay_detail.uyeid = uye.id");
        return DataTables::of($query)->toJson();
    }

    public function changePay (Request $request){
        $id = $request->id;
        $value = $request->value;

        DB::table('pay_detail')->where('id', $id)->update(['pay' => $request->value]);
        return response()->json(['status' => true]);
    }

    public function setAidat(Request $request){
        $id = $request->id;
        $value = ceil($request->aidat);

        DB::table('uye')->where('id', $id)->update(['aidat' => $value]);
        return response()->json(['status' => true]);
    }


    public function odeme_olustur(Request $request){
       return view('admin.pages.member.odeme_olustur');
    }

    public function odeme_islem(Request $request){
        $donem = $request->donem;
        $uyeler = DB::select('select * from uye where register_pay = "1" ');
        $uyelist = [];
        foreach($uyeler as $uye){

            $kontrol = DB::select('select * from pay_detail where uyeid = ? and dateTime = ?', [$uye->id,$donem]);
            if(count($kontrol) > 0){
                continue;
            }

            DB::insert('insert into pay_detail (uyeid,amount,start_date,pay,dateTime) values (?,?,?,?,?)', 
            [$uye->id,$uye->aidat,$donem,'0',$donem]);
        
            array_push($uyelist,$uye->corporate_name);
        
        }

        

        return response()->json($uyelist);



    }

}