<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use App;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\URL;




class formsController extends Controller
{
    /* Contact forms başlangıç */
    public function contactForm(Request $request)
    {

        $ad = $request->input('ad');
        $soyad = $request->input('soyad');
        $firma = $request->input('firma');
        $sehir = $request->input('sehir');
        $adres = $request->input('adres');
        $tel = $request->input('tel');
        $fax = $request->input('fax');
        $eposta = $request->input('eposta');
        $mesaj = $request->input('mesaj');


        DB::table('contact_forms')->insert([
            'ad' => $ad,
            'soyad' => $soyad,
            'firma' => $firma,
            'sehir' => $sehir,
            'adres' => $adres,
            'telefon' => $tel,
            'fax' => $fax,
            'eposta' => $eposta,
            'mesaj' => $mesaj


        ]);
        Session::start();
        Session::put('success', (App::getLocale() == 'tr') ? 'Form başarıyla gönderildi.': 'The form has been successfully submitted.');
        return redirect()->back();
    }

    public function list(Request $request)
    {

        $contactForms = DB::table('contact_forms')->orderBy('id', 'desc')->get();
        return view('admin.pages.contactformsList', compact('contactForms'));
    }

    public function deleteForm(Request $request)
    {

        $response = new \stdClass();
        $id = $request->id;
        $response->status = (DB::delete('DELETE from contact_forms where Id  = ?', [$id])) ? true : false;
        echo json_encode($response);
    }
    /* Contact forms son */






    /* Ekspertiz forms başlangıç */
    public function ekspertizForm(Request $request)
    {

        $ad = $request->input('ad');
        $soyad = $request->input('soyad');
        $tel = $request->input('tel');
        $adres = $request->input('adres');
        $talep = $request->input('talep');
        $dsayisi = $request->input('dsayisi');
        $bsayisi = $request->input('bsayisi');
        $eposta = $request->input('eposta');
        $mesaj = $request->input('mesaj');








        DB::table('ekspetiz_forms')->insert([
            'ad' => $ad,
            'soyad' => $soyad,
            'telefon' => $tel,
            'adres' => $adres,
            'talep' => $talep,
            'dsayisi' => $dsayisi,
            'bsayisi' => $bsayisi,
            'eposta' => $eposta,
            'mesaj' => $mesaj


        ]);
        Session::start();
        Session::put('success', (App::getLocale() == 'tr') ? 'Form başarıyla gönderildi.': 'The form has been successfully submitted.');
        return redirect()->back();
    }

    public function ekspertizlist(Request $request)
    {

        $ekspertizForms = DB::table('ekspetiz_forms')->orderBy('id', 'desc')->get();
        return view('admin.pages.ekspertizformsList', compact('ekspertizForms'));
    }

    public function ekspertizdeleteForm(Request $request)
    {

        $response = new \stdClass();
        $id = $request->id;
        $response->status = (DB::delete('DELETE from ekspetiz_forms where Id  = ?', [$id])) ? true : false;
        echo json_encode($response);
    }


    /* Ekspertiz forms son */




    /* serviskayit forms başlangıç */
    public function serviskayitForm(Request $request)
    {

        $adsoyad = $request->input('adsoyad');
        $tel = $request->input('tel');
        $adres = $request->input('adres');
        $talep = $request->input('talep');
        $tarih = $request->input('tarih');
        $eposta = $request->input('eposta');
        $mesaj = $request->input('mesaj');



        DB::table('serviskayit_forms')->insert([
            'adsoyad' => $adsoyad,
            'tel' => $tel,
            'adres' => $adres,
            'talep' => $talep,
            'tarih' => $tarih,
            'email' => $eposta,
            'mesaj' => $mesaj


        ]);
        Session::start();
        Session::put('success', (App::getLocale() == 'tr') ? 'Form başarıyla gönderildi.': 'The form has been successfully submitted.');
        return redirect()->back();
    }

    public function serviskayitlist(Request $request)
    {

        $serviskayitForms = DB::table('serviskayit_forms')->orderBy('id', 'desc')->get();
        return view('admin.pages.serviskayitformsList', compact('serviskayitForms'));
    }

    public function serviskayitdeleteForm(Request $request)
    {

        $response = new \stdClass();
        $id = $request->id;
        $response->status = (DB::delete('DELETE from serviskayit_forms where Id  = ?', [$id])) ? true : false;
        echo json_encode($response);
    }
    /* serviskayit forms son */



    /* biz sizi arayalım forms başlangıç */
    public function bsarayalimForm(Request $request)
    {

        $eposta = $request->input('eposta');
        $tel = $request->input('tel');
        $mesaj = $request->input('mesaj');



        DB::table('bsarayalim_forms')->insert([
            'eposta' => $eposta,
            'tel' => $tel,
            'mesaj' => $mesaj


        ]);

        Session::start();
            Session::put('successb', (App::getLocale() == 'tr') ? 'Form başarıyla gönderildi.': 'The form has been successfully submitted.');
            return redirect()->back();
        
    }



    public function bsarayalimlist(Request $request)
    {

        $bsarayalimforms = DB::table('serviskayit_forms')->orderBy('id', 'desc')->get();
        return view('admin.pages.bsarayalimformsList', compact('bsarayalimforms'));
    }


    public function bsarayalimdeleteForm(Request $request)
    {

        $response = new \stdClass();
        $id = $request->id;
        $response->status = (DB::delete('DELETE from serviskayit_forms where Id  = ?', [$id])) ? true : false;
        echo json_encode($response);
    }
    /* biz sizi arayalım forms son */




/* bulten forms başlangıç*/

    public function bultenForm(Request $request)
    {

        $eposta = $request->input('eposta');

        DB::table('bulten_forms')->insert([
            'eposta' => $eposta,
        ]);

        Session::start();
            Session::put('success', (App::getLocale() == 'tr') ? 'Form başarıyla gönderildi.': 'The form has been successfully submitted.');
            return redirect()->back();
    }


    public function bultenformslist(Request $request)
    {

        $bultenforms = DB::table('bulten_forms')->orderBy('id', 'desc')->get();
        return view('admin.pages.bultenformsList', compact('bultenforms'));
    }

    public function bultendeleteForm(Request $request)
    {

        $response = new \stdClass();
        $id = $request->id;
        $response->status = (DB::delete('DELETE from bulten_forms where Id  = ?', [$id])) ? true : false;
        echo json_encode($response);
    }
    /* bulten forms son */



   /* insan kaynakları forms başlangıç*/
    public function ikForm(Request $request)
    {


        $ad = $request->input('ad');
        $soyad = $request->input('soyad');
        $eposta = $request->input('eposta');
        $tel = $request->input('tel');
        $mesaj = $request->input('mesaj');




        if ($request->hasFile('dosya')) {
            $file = $request->file('dosya');
            $extension = $file->getClientOriginalExtension();
            if ($extension == 'pdf' || $extension == 'docx') {

                $fileName = $file->getClientOriginalName();
                $fileName = $file->hashName();
                $file->move(public_path('uploads/cv'), $fileName);

                DB::table('ik_forms')->insert([
                    'ad' => $ad,
                    'soyad' => $soyad,
                    'eposta' => $eposta,
                    'tel' => $tel,
                    'mesaj' => $mesaj,
                    'dosya' => $fileName
                ]);



            Session::start();
            Session::put('success', (App::getLocale() == 'tr') ? 'Tebrikler, CV\'niz başarıyla yüklenmiştir. En kısa sürede size dönüş sağlanacaktır.': 'Congratulations, your CV has been uploaded successfully. You will be returned as soon as possible.');
           
            
                return redirect()->back();
                

            } else {

                
                Session::start();
                Session::put('error', (App::getLocale() == 'tr') ? 'Yüklemiş olduğunuz dosya formatı uygun değildir. Uygun formatlar PDF ve DOCX dosyalarıdır.': 'The file format you uploaded is not suitable. Suitable formats are PDF and DOCX files.');
            
                return redirect()->back();

                
            }
        }

    }

    public function ikformslist(Request $request)
    {

        $ikforms = DB::table('ik_forms')->orderBy('id', 'desc')->get();
        return view('admin.pages.ikformsList', compact('ikforms'));
    }

    public function ikdeleteForm(Request $request)
    {

        $response = new \stdClass();
        $id = $request->id;
        $response->status = (DB::delete('DELETE from ik_forms where Id  = ?', [$id])) ? true : false;
        echo json_encode($response);
    }


    /* insan kaynakları forms son*/


    /* sosyal medya forms başlangıç*/

    public function sociallist(Request $request){

        $socialforms = DB::table('settings')->get();


        return view('admin.pages.socialfomsList', compact('socialforms'));
    }

    public function socialCreate(Request $request){

        $facebook = $request->input('facebook');
        $twitter = $request->input('twitter');
        $linkedn = $request->input('linkedn');
        $instagram = $request->input('instagram');
        $home_mail = $request->input('home_mail');
        $fax = $request->input('fax');
        $tel = $request->input('tel');
        $adres = $request->input('adres');



        $count = DB::table('settings')
        ->where('facebook', $facebook)
        ->orWhere('twitter', $twitter)
        ->orWhere('linkedIn', $linkedn)
        ->orWhere('Instagram', $instagram)
        ->orWhere('home_mail', $home_mail)
        ->orWhere('fax', $fax)
        ->orWhere('home_phone', $tel)
        ->orWhere('home_address', $adres)
        ->count();

                if($count > 0){
                    DB::table('settings')
                        ->where('facebook', $facebook)
                        ->orWhere('twitter', $twitter)
                        ->orWhere('linkedIn', $linkedn)
                        ->orWhere('Instagram', $instagram)
                        ->orWhere('home_mail', $home_mail)
                        ->orWhere('fax', $fax)
                        ->orWhere('home_phone', $tel)
                        ->orWhere('home_address', $adres)
                        ->update([
                            'facebook' => $facebook,
                            'twitter' => $twitter,
                            'linkedIn' => $linkedn,
                            'Instagram' => $instagram,
                            'home_mail' => $home_mail,
                            'fax'       => $fax,  
                            'home_phone' => $tel,
                            'home_address' => $adres
                        ]);
                } else {
                    DB::table('settings')->insert([
                        'facebook' => $facebook,
                        'twitter' => $twitter,
                        'linkedIn' => $linkedn,
                        'Instagram' => $instagram,
                        'home_mail' => $home_mail,
                        'fax'       => $fax,  
                        'home_phone' => $tel,
                        'home_address' => $adres
                    ]);
                }


                    
        // Session::start();
        // Session::put('success', (App::getLocale() == 'tr') ? 'Form başarıyla güncellendi.': 'The form has been successfully updated.');
        return redirect()->back();
    }


    
     


    /* sosyal medya forms son*/
}
