<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\DataTables;
use App\Models\Distributor;

class distributorController extends Controller
{
	function get_bolge()
    {
        $bolge = json_encode(DB::select('select * from distributorler'));
        print_r($bolge);
    }
    function get_bolge_il(Request $request)
    {
        $bolge  =  $request->bolgeID;
        $il = DB::select('select DISTINCT(Sehirler.SehirAd),Sehirler.Id from bayi LEFT JOIN Sehirler on Sehirler.Id = bayi.il where Sehirler.BolgeId = ? and bayi.page_status = "on"', [$bolge]);
        print_r(json_encode($il));
    }
    function filter(Request $request)
    {
        if ($request->ilID != -1) {
            print_r(json_encode(DB::select('select bayi.*, Sehirler.SehirAd from bayi left join Sehirler on Sehirler.Id = bayi.il where page_status ="on" and bayi.il = ?', [$request->ilID])));
        } else {
            print_r(json_encode(DB::select('select bayi.*, Sehirler.SehirAd from bayi left join Sehirler on Sehirler.Id = bayi.il where page_status = "on" order by bayi.il asc')));
        }
    }
    function ajaxCountryList()
    {
        return json_encode(DB::select('select * from distributorler'));
    }

    function ajaxCountrySave(Request $request)
    {
        $response = new \stdClass();
        $country = $request->country;
        $save =  DB::insert('insert into distributorler (BolgeAd) values (?)', [$country]);
        $response->status = ($save) ? true : false;

        print_r(json_encode($response));
    }
    function ajaxCountryDelete(Request $request)
    {
        $response = new \stdClass();
        $id = $request->id;

        $delete = DB::delete('delete from distributorler where Id = ?', [$id]);
        if ($delete) {
            DB::delete('delete from distributor_bayi where il = ?', [$id]);
        }
        $response->status = ($delete) ? true : false;

        print_r(json_encode($response));
    }

    function ajaxCountryUpdate(Request $request)
    {
        $response = new \stdClass();
        $id = $request->id;
        $newName = $request->newName;
        $save = DB::update('update distributorler set BolgeAd = ? where Id = ?', [$newName, $id]);
        $response->status = ($save) ? true : false;
        print_r(json_encode($response));
    }

    function getCountryListItem(Request $request){
        $id = $request->selectedCounty;
        if(!empty($id)){
            $getList = DB::select('select * from distributor_bayi where il = ?', [$id]);
            print_r(json_encode($getList));
        }
    }
	// --------------------------- Admin -------------------------
    public function list()
    {
        $distributorler = json_encode(DB::select('select * from distributorler'));
        return view('admin.pages.distibutorListe', compact('distributorler'));
    }
    public function ajaxList()
    {
        $query =  DB::Select("SELECT distributor_bayi.*, distributorler.BolgeAd as il, distributorler.BolgeAd as bolge FROM distributor_bayi LEFT JOIN distributorler ON distributorler.Id = distributor_bayi.il GROUP BY distributor_bayi.id ");
        return DataTables::of($query)->toJson();
    }
    public function ajaxsave(Request $request)
    {
        $response = new \stdClass();
        $id = $request->update_id;
        $bayi = new Distributor;
        if (!empty($id)) $bayi = $bayi::find($id);
        $bayi->bayi_adi = $request->bayi_adi;
        $bayi->telefon = $request->telefon;
        $bayi->telefon_2 = $request->telefon_2;
        $bayi->faks = $request->faks;
        $bayi->email = $request->email;
        $bayi->site = $request->site;
        $bayi->yetkili_adi = $request->yetkili_adi;
        $bayi->adres = $request->adres;
        $bayi->il = $request->il;
        $response->status = ($bayi->save()) ? true : false;
        echo json_encode($response);
    }

    public function getSingle(Request $request)
    {
        $id = $request->id;

        $bayi = Distributor::where('id', '=', $id)->get();
        echo json_encode($bayi);
    }
    public function ajaxDelete(Request $request)
    {
        $response = new \stdClass();
        $id = $request->id;
        $Bayi = Distributor::find($id);
        $response->status = ($Bayi->delete()) ? true : false;
        echo json_encode($response);
    }
    public function statusChanger(Request $request)
    {
        $id = $request->id;
        $bayiCheck = Distributor::where('id', '=', $id)->get();
        $response = new \stdClass();


        $bayi = Distributor::find($id);

        if ($bayiCheck[0]->page_status != 'on') {
            $bayi->page_status = 'on';
        } else {
            $bayi->page_status = 'off';
        }
        $response->status = ($bayi->save()) ? true : false;
        echo json_encode($response);
    }
}
