<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Blog;
use Illuminate\Support\Facades\DB;
use App;
use Yajra\DataTables\DataTables;
use Intervention\Image\Facades\Image;



class blogController extends Controller
{



    public function bloglar(Request $request)
    {

        $blog = Blog::orderBy('id', 'desc')->paginate(10);
        $blog2 = Blog::orderBy('id', 'desc')->take(5)->get();

        return view('pages.bloglar', compact('blog', 'blog2'));
    }

    public function singleBlogs(Request $request)
    {
        $singleBlog =   Blog::where(['slug' => $request->slug])->first();
        $otherBlog = Blog::where('id', '<>', $singleBlog->id)->orderByDesc('id')->take(6)->get();
        return view('pages.singleBlog', compact('singleBlog', 'otherBlog'));
    }












    // ----------------------- Admin -------------------------------
    function list()
    {
        return view('admin.pages.blogListe');
    }

    public function ajaxList()
    {
        $blogs = Blog::select('id', 'title', 'title_en', 'content', 'content_en', 'slug', 'b_status', 'cat_id', 'image_path', 'create_user', 'update_user', 'deleted_at', 'updated_at', 'origin_id', 'lang', 'created_at', 'id as DT_RowId')->get();
        return DataTables::of($blogs)->toJson();
    }

    public function newpage()
    {
        return view('admin.pages.newBlogs');
    }
    public function newpage_save(Request $request)
    {
        $new_page = new Blog;
        if ($request->hasFile('BreadcrumbBG')) {
            $originName = $request->file('BreadcrumbBG')->getClientOriginalName();
            $fileName   = pathinfo($originName, PATHINFO_FILENAME);
            $extension  = $request->file('BreadcrumbBG')->getClientOriginalExtension();
            $fileName   = $fileName . '_' . time() . '.' . $extension;
            $request->file('BreadcrumbBG')->move(public_path('uploads'), $fileName);
            $new_page->image_path = $fileName;

            $imageThumbFull = Image::make(public_path('uploads/') . $fileName)->resize(303, null, function ($constraint) {
                $constraint->aspectRatio();
            })->encode('jpg', 90);
            $imageThumbFull->save(public_path('uploads/thumb_') . $fileName);


            $imageFull = Image::make(public_path('uploads/') . $fileName)->resize(800, null, function ($constraint) {
                $constraint->aspectRatio();
            })->encode('jpg', 90);
            $imageFull->save(public_path('uploads/') . $fileName);
        }

        $new_page->title = $request->title;
        $new_page->title_en = $request->title_en;
        $new_page->slug = $request->slug;
        $new_page->content = $request->content;
        $new_page->content_en = $request->content_en;
        $new_page->page_keywords = $request->page_keywords;
        $new_page->page_description = $request->page_description;
        $new_page->page_order = $request->page_order;
        if ($new_page->save()) {
            $request->session()->flash('status', 'Ekleme işlemi başarılı');
        } else {
            $request->session()->flash('status', 'Bir hata oluştu. Sistem yöneticisine haber veriniz.');
        }
        return redirect()->route('blog.list');
    }
    public function ajaxSluq(Request $request)
    {
        $response = new \stdClass();
        if (Blog::where(['slug' => $request->seo_data])->count() != 0) {
            $response->status = false;
        } else {
            $response->status = true;
        }
        print_r(json_encode($response));
    }
    public function delete(Request $request)
    {
        $response = new \stdClass();
        $id = $request->id;
        $Bayi = Blog::find($id);
        $response->status = ($Bayi->delete()) ? true : false;
        echo json_encode($response);
    }
    public function edit(Request $request)
    {
        $page = Blog::where(['id' => $request->id])->first();


        return view('admin.pages.editBlog', compact('page'));
    }
    public function blogEdit_save(Request $request)
    {

        $id = $request->id;
        $new_page = Blog::findOrFail($id);

        if ($request->hasFile('BreadcrumbBG')) {
            $originName = $request->file('BreadcrumbBG')->getClientOriginalName();
            $fileName = pathinfo($originName, PATHINFO_FILENAME);
            $extension = $request->file('BreadcrumbBG')->getClientOriginalExtension();
            $fileName = $fileName . '_' . time() . '.' . $extension;
            $request->file('BreadcrumbBG')->move(public_path('uploads'), $fileName);

            $imageThumbFull = Image::make(public_path('uploads/') . $fileName)->resize(330, null, function ($constraint) {
                $constraint->aspectRatio();
            })->encode('jpg', 90);
            $imageThumbFull->save(public_path('uploads/thumb_') . $fileName);

            $imageFull = Image::make(public_path('uploads/') . $fileName)->resize(800, null, function ($constraint) {
                $constraint->aspectRatio();
            })->encode('jpg', 90);
            $imageFull->save(public_path('uploads/') . $fileName);



            $new_page->image_path = $fileName;
        }

        $new_page->title = $request->title;
        $new_page->title_en = $request->title_en;
        $new_page->slug = $request->slug;
        $new_page->content = $request->content;
        $new_page->content_en = $request->content_en;
        $new_page->page_keywords = $request->page_keywords;
        $new_page->page_description = $request->page_description;
        $new_page->page_order = $request->page_order;
        if ($new_page->update()) {
            $request->session()->flash('status', 'Güncelleme işlemi başarılı');
        } else {
            $request->session()->flash('status', 'Bir hata oluştu. Sistem yöneticisine haber veriniz.');
        }
        return redirect()->route('blog.list');
    }
}
