<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;


class adminController extends Controller
{
    public function login()
    {
        return view('admin.pages.login');
    }
    public function loginProgress(Request $request)
    {
        $username = $request->uname;
        $password = $request->pwd;
        $data = DB::select('select * from users where username = ? and password = ? limit 1', [$username, $password]);

        if (count($data) != 0) {
            $request->session()->put('username', $data[0]->username);
            $request->session()->put('level', $data[0]->level);
            $request->session()->put('name', $data[0]->name);
            $request->session()->put('lastname', $data[0]->lastname);
            $request->session()->put('login', true);
            return Redirect::to('/admin/panel');
        } else {
            $request->session()->flash('loginError', 'Bilgilerinizi hatalı girdiniz. Lütfen kontrol edip tekrar deneyiniz.');
            return Redirect::to('/admin/login');
        }
    }

    public function test()
    {
        echo "test";
    }

    public function panel()
    {
        $log = DB::select('select log.*, uye.name, uye.surname, uye.corporate_name from log left join uye on uye.id = log.user order by id desc limit 100');

        return view('admin.pages.panel', compact('log'));
    }

    public function menuedit()
    {
        $pages = DB::select('select page_id,page_title,page_title_seo from pages order by page_title asc');
        $menu = DB::select('select * from menu order by menuOrder asc');
        return view('admin.pages.menuEdit', compact('pages', 'menu'));
    }

    public function kategoriedit()
    {
        $pages = DB::select('select page_id,page_title,page_title_seo from products_category order by page_title asc');
        $menu = DB::select('select * from products_category order by menuOrder asc');
        return view('admin.pages.menuEdit', compact('pages', 'menu'));
    }

    public function menuduzenleadd(Request $request)
    {
        $pageName = $request->pageName;
        $menuName = $request->menuName;
        $menuNameEn = $request->menuNameEn;
        $type = $request->type;
        if ($type == "Link") {
            $pageName = $request->link;
        } else if ($type == "Statik") {
            $pageName = $request->static;
        }

        $addData = DB::table('menu')->insert([
            'menuTitle' => $menuName,
            'menuTitleEn' => $menuNameEn,
            'MenuType' => $type,
            'menuParent' => 0,
            'target' => $pageName,
            'menuOrder' => 999
        ]);

        if ($addData) {
            $id = DB::getPdo()->lastInsertId();
            echo $id;
        }
    }

    public function kategoriduzenleadd(Request $request)
    {
        $pageName = $request->pageName;
        $menuName = $request->menuName;
        $menuNameEn = $request->menuNameEn;
        $type = $request->type;
        if ($type == "Link") {
            $pageName = $request->link;
        }

        $addData = DB::table('products_category')->insert([
            'menuTitle' => $menuName,
            'menuTitleEn' => $menuNameEn,
            'menuParent' => 0,
        ]);

        if ($addData) {
            $id = DB::getPdo()->lastInsertId();
            echo $id;
        }
    }

    public function menureorder(Request $request)
    {
        $menu_data = json_decode($request->data, true);
        $this->updateMenuData($menu_data);
    }
    public function kategorireorder(Request $request)
    {
        $menu_data = json_decode($request->data, true);
        $this->updateKategoriData($menu_data);
    }
    public function updateKategoriData($data, $parent = null)
    {
        foreach ($data as $index => $menu) {
            DB::table('products_category')->where('id', $menu['id'])->update([
                'menuParent' => $parent,
                'menuOrder' => $index
            ]);
            if (isset($menu['children'])) {
                $this->updateKategoriData($menu['children'], $menu['id']);
            }
        }
    }
    public function updateMenuData($data, $parent = null)
    {
        foreach ($data as $index => $menu) {
            DB::table('menu')->where('id', $menu['id'])->update([
                'menuParent' => $parent,
                'menuOrder' => $index
            ]);
            if (isset($menu['children'])) {
                $this->updateMenuData($menu['children'], $menu['id']);
            }
        }
    }

    public function getMenuElement(Request $request)
    {
        $id = $request->id;
        $data = DB::select('select * from menu where id = ? ', [$id]);
        print_r(json_encode($data[0]));
        return;
    }

    public function getKategoriElement(Request $request)
    {
        $id = $request->id;
        $data = DB::select('select * from products_category where id = ? ', [$id]);
        print_r(json_encode($data[0]));
        return;
    }

    public function editMenuElement(Request $request)
    {
        $pageName = $request->pageName;
        $menuName = $request->menuName;
        $menuNameEn = $request->menuNameEn;
        $type = $request->type;
        $id = $request->id;
        if ($type == "Link") {
            $pageName = $request->link;
        } else if ($type == "Statik") {
            $pageName = $request->static;
        }

        $addData = DB::table('menu')->where(['id' => $id])->update([
            'menuTitle' => $menuName,
            'menuTitleEn' => $menuNameEn,
            'MenuType' => $type,
            'target' => $pageName,
        ]);
        if ($addData) {
            echo "ok";
        } else {
            echo "error";
        }
    }




    public function editKategoriElement(Request $request)
    {
        $pageName = $request->pageName;
        $menuName = $request->menuName;
        $menuNameEn = $request->menuNameEn;
        $type = $request->type;
        $id = $request->id;
        if ($type == "Link") {
            $pageName = $request->link;
        }

        $addData = DB::table('products_category')->where(['id' => $id])->update([
            'menuTitle' => $menuName,
            'menuTitleEn' => $menuNameEn,
            'MenuType' => '',
            'target' => '',
        ]);
        if ($addData) {
            echo "ok";
        } else {
            echo "error";
        }
    }

    public function deleteMenuElement(Request $request)
    {
        $id = $request->id;
        $deleteData = DB::table('menu')->where(['id' => $id])->delete();
        if ($deleteData) {
            echo "ok";
        } else {
            echo "error";
        }
    }

    public function deleteKategoriElement(Request $request)
    {
        $id = $request->id;
        $deleteData = DB::table('products_category')->where(['id' => $id])->delete();
        if ($deleteData) {
            echo "ok";
        } else {
            echo "error";
        }
    }


    // Sliderlerin eklendiği ve listelendiği kısım başlangıç
    public function sliderList()
    {
        $sliders = DB::table('slider')->select('id', 'title', 'tr_path', 'en_path', 'link', 'isActive', 'order')->get();
        return view('admin.pages.slider', compact('sliders'));
    }

    public function sliderEdit(Request $request)
    {
        $request->validate([
            'url' => 'required|url',
            'order' => 'required|integer',
            'file' => 'required|file|mimes:jpeg,png,jpg,gif,svg',
            'enfile' => 'required|file|mimes:jpeg,png,jpg,gif,svg',
        ]);
        $file = $request->file('file');
        $filename = sha1(time() . $file->getClientOriginalName()) . '.' . $file->getClientOriginalExtension();
        $file->move(public_path('uploads'), $filename);
        $enfile = $request->file('enfile');
        $enfilename = sha1(time() . $enfile->getClientOriginalName()) . '.' . $enfile->getClientOriginalExtension();
        $enfile->move(public_path('uploads'), $enfilename);
        $link = $request->input('url');
        $order = $request->input('order');
        $file = $request->file('file');
        $enfile = $request->file('enfile');
        $tr_path = $filename;
        $en_path = $enfilename;

        DB::table('slider')->insert([
            'link' => $link,
            'order' => $order,
            'en_path' => $en_path,
            'tr_path' => $tr_path,
        ]);

        return back()->withInput()->with('success', 'Slider Başarıyla Eklendi!');
    }

    public function sliderDelete(Request $request)
    {
        $response = new \stdClass();
        $id = $request->id;
        $del = DB::table('slider')->where(['id' => $id])->delete();
        $response->status = ($del) ? true : false;
        return;
    }

    public function listFolder()
    {
        $dosyalar = glob(config('view.paths')[0] . "/pages/static/*.php");
        foreach ($dosyalar as $key => $file)
            $dosyalar[$key] = str_replace('.blade.php', '', basename($file));
        print_r(json_encode($dosyalar));
    }
    public function logout()
    {
        session()->flush();
        return redirect('/');

        // $files = glob(public_path('uploads/') . '*.{jpg,jpeg,png}', GLOB_BRACE | GLOB_BRACE);

        // foreach ($files as $file) {
        //     if (is_file($file)) {
        //         try {

        //             echo $file . "<br>";
        //             $imageFull = Image::make($file)->resize(800, null, function ($constraint) {
        //                 $constraint->aspectRatio();
        //             })->encode('jpg', 90);
        //             $imageFull->save($file);
        //         } catch (\Exception $e) {
        //             // bir hata meydana geldi, sadece bir sonraki dosyaya geç
        //             continue;
        //         }
        //     } else {
        //         // klasör ise alt klasörlere bakmak için recursive olarak glob fonksiyonunu kullanın
        //         $subfiles = glob($file . '/*.{jpg,jpeg,png,gif}', GLOB_BRACE | GLOB_BRACE | GLOB_NOSORT | GLOB_NOESCAPE);
        //         $files = array_merge($files, $subfiles);
        //     }
        // }
    }

    // -----------------------------------------------------------------------------------------

    public function duyuruListesi()
    {
        $duyuru = DB::table('duyuru')->select('id', 'title', 'title_box', 'date_time')->get();
        return view('admin.pages.duyuru', compact('duyuru'));
    }
    public function duyuruEkle(Request $request)
    {
        $title = $request->input('title');
        $title_box = $request->input('title_box');

        $save = DB::table('duyuru')->insert([
            'title' => $title,
            'title_box' => $title_box,
            'date_time' => now()
        ]);
        
        if($save){
            return json_encode(['status' => 'success']);
        }else{
            return json_encode(['status' => 'false']);
        }

        
       




        //return view('admin.pages.duyuruEkle');
    }

    public function duyuruSil(Request $request){
        $id = $request->id;
        $delete = DB::table('duyuru')->where(['id' => $id])->delete();
        if($delete){
            return json_encode(['status' => 'success']);
        }else{
            return json_encode(['status' => 'false']);
        }
    }


    public function iletisimListesi(Request $request){

        $contactForms = DB::table('contact')->orderBy('id', 'desc')->get();
        return view('admin.pages.contactformsList', compact('contactForms'));


        echo "iletisimListesi";
    }

    public function deleteForm(Request $request){
      
        $response = new \stdClass();
        $id = $request->id;
        $response->status = (DB::delete('DELETE from contact where id  = ?', [$id])) ? true : false;
        echo json_encode($response);
    }
}