<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use App\Models\Semalar;


class SemaController extends Controller
{

    public function getSingleList(Request $request){

        $slug = $request->slug;
        $data = Semalar::where('page_title_seo', '=',$slug)->get()[0];
        $semaList = Semalar::all();
       
        return view('pages.showSchema',compact('data', 'semaList'));
        exit;

    }

    // ================================admin==============================================

    public function list()
    {
        $pages = Semalar::all();
        return view('admin.pages.semaList', compact('pages'));
    }

    public function yeni()
    {
        return view('admin.pages.sema_ekle');
    }

    public function yeni_save(Request $request)
    {
        $sema = new Semalar;

        $sema->page_title = $request->page_title;
        $sema->page_title_en = $request->page_title_en;
        $sema->page_title_seo = $request->page_title_seo;
        $sema->content = $request->content;
        $sema->content_en = $request->content_en;
        $sema->page_keywords = $request->page_keywords;
        $sema->page_description = $request->page_description;
        $sema->product_id =  $request->product_id;

        if ($sema->save()) {
            $request->session()->flash('status', 'Ekleme işlemi başarılı');
        } else {
            $request->session()->flash('status', 'Bir hata oluştu. Sistem yöneticisine haber veriniz.');
        }

        return redirect()->route('sema_list');
    }

    public function delete(Request $request)
    {
        $id = $request->id;
        $response = new \stdClass();
        $new_product = new Semalar;
        $data = $new_product::where(['page_id' => $id])->delete();
        $response->status = ($data) ? true : false;
        print_r(json_encode($response));
    }
    public function statusChanger(Request $request)
    {

        $response = new \stdClass();
        $check = Semalar::where(['page_id' => $request->id])->first();
        $page_status = ($check->page_status == "on") ? "off" : "on";
        $update = Semalar::where(['page_id' => $request->id])->update(["page_status" => $page_status]);
        $response->status =  ($update) ? true : false;
        print_r(json_encode($response));
    }

    public function pageEdit(Request $request)
    {
        $page = Semalar::where(['page_id' => $request->id])->first();
        $category = DB::select('select * from page_category');
        return view('admin.pages.editSema', compact('category', 'page'));
    }
     public function pageEdit_save(Request $request)
    {
        $id = $request->id;
        $new_page = Semalar::findOrFail($id);
        $new_page->page_title = $request->page_title;
        $new_page->page_title_en = $request->page_title_en;
        $new_page->page_title_seo = $request->page_title_seo;
        $new_page->content = $request->content;
        $new_page->content_en = $request->content_en;
        $new_page->page_keywords = $request->page_keywords;
        $new_page->page_description = $request->page_description;
        $new_page->page_order = $request->page_order;
         if ($new_page->update()) {
            $request->session()->flash('status', 'Güncelleme işlemi başarılı');
        } else {
            $request->session()->flash('status', 'Bir hata oluştu. Sistem yöneticisine haber veriniz.');
        }

        return redirect()->route('sema_list');
    }
}
