<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Models\Products;
use App\Models\News;
use App\Models\Blog;
use App\Models\log;
use App\Models\memberModel;
use Carbon\Carbon;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Storage;


class HomeController extends Controller
{
    public function index(Request $request)
    {

        //$socialforms = DB::table('settings')->get();


        $news = News::take(6)->orderBy('page_id', 'desc')->get()->toArray();





        return view('home', compact('news'));
    }

    public function languageSwitcher($lang)
    {
        if (in_array($lang, ['en', 'tr'])) {
            Session::put('locale', $lang);
            app()->setLocale($lang);
            return redirect()->back();
        }
    }
    public function dateReFormat($date)
    {
        $date = Carbon::parse($date);
        $w3c_date = $date->toW3cString();
        return $w3c_date;
    }

    function slugify($text)
    {
        $find = array('Ç', 'Ş', 'Ğ', 'Ü', 'İ', 'Ö', 'ç', 'ş', 'ğ', 'ü', 'ö', 'ı', '+', '#');
        $replace = array('c', 's', 'g', 'u', 'i', 'o', 'c', 's', 'g', 'u', 'o', 'i', 'plus', 'sharp');
        $text = strtolower(str_replace($find, $replace, $text));
        $text = preg_replace("@[^A-Za-z0-9\-_\.\+]@i", ' ', $text);
        $text = trim(preg_replace('/\s+/', ' ', $text));
        $text = str_replace(' ', '-', $text);

        return $text;
    }






    function eysiid()
    {
        if (session()->has('uye_login') && session()->get('uye_login') == true) {
            return redirect('/e-ysiid/portal');
        }
        return view('pages.eysiid');
    }

    function login(Request $request)
    {
        $response = new \stdClass();
        $email = $request->email;
        $password = md5($request->password);


        $data = DB::select('select * from uye where email = ? and password = ? and isActive = 1 limit 1', [$email, $password]);

        if (count($data) != 0) {

            $request->session()->put('uye_login', true);
            $request->session()->put('uye_id', $data[0]->id);
            $response->status = true;
            $response->message = "Giriş başarılı bekleyiniz.";
            $response->url = route('portal');

            $log = new Log();
            $log->user = $data[0]->id;
            $log->islem = 'Üye girişi yapıldı';
            $log->ip = $request->ip();
            $log->save();


        } else {
            $request->session()->put('uye_login', false);
            $response->status = false;
            $response->message = "Giriş başarısız. Lütfen tekrar deneyiniz.";
        }

        return response()->json($response, 200, [], JSON_UNESCAPED_UNICODE);

    }


    function portal(Request $request)
    {
        $uye = DB::select('select * from uye where id = ? limit 1', [$request->session()->get('uye_id')])[0];
        $settings = DB::select('select * from settings limit 1')[0];

        if ((int) $uye->approved == 0) {
            return view('pages.eysiid.waitForDocument');
        } else if ((int) $uye->approved == 2) {
            return view('pages.eysiid.documentRejected');
        } else {
            if ((int) $uye->register_pay == 1) {
                $firstData = DB::select('select content from pages where page_title_seo = ? limit 1', ['uye-karsilama-sayfasi'])[0]->content;
                return view('pages.eysiid.portal', compact('uye', 'settings', 'firstData'));
            } else {


                return view('pages.eysiid.registerPay', compact('settings'));
            }
        }

    }


    function register(Request $request)
    {
        $settings = DB::select('select * from settings limit 1')[0];
        return view('pages.eysiid.memberRegister', compact('settings'));
    }

    function authRegister(Request $request)
    {
        $response = new \stdClass();
        $email = $request->email;
        $password = $request->password;
        $name = $request->name;
        $surname = $request->surname;
        $phone = $request->phone;
        $isLegal = $request->isLegal;
        $corporate_role = $request->corporate_role;
        $corporate_name = $request->corporate_name;
        $g_recaptcha_response = $_POST["g-recaptcha-response"];
        $remote_ip = $_SERVER["REMOTE_ADDR"];



        $url = "https://www.google.com/recaptcha/api/siteverify";

        $data = array(
            "secret" => env('GOOGLE_reCAPTCHA_SECRET_KEY'),
            "response" => $g_recaptcha_response,
            "remoteip" => $remote_ip
        );

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($curl);
        curl_close($curl);

        $json = json_decode($result);

        if ($json->success == true) {

            $check = memberModel::where('email', $email)->count();
            if ($check > 0) {
                return redirect('/e-ysiid/register?error=1');
            }

            $member = new memberModel();
            $member->email = $email;
            $member->password = md5($password);
            $member->name = $name;
            $member->surname = $surname;
            $member->phone = $phone;
            $member->isLegal = $isLegal;
            $member->corporate_role = $corporate_role;
            $member->corporate_name = $corporate_name;

            if ($member->save()) {
                $data = $member::latest()->first();
                $log = new Log();
                $log->user = $data->id;
                $log->islem = 'Üye kaydı oluşturuldu.';
                $log->ip = $request->ip();
                $log->save();

                $request->session()->put('uye_login', true);
                $request->session()->put('uye_id', $data->id);
                return redirect('/e-ysiid/register/register-step-two');
            } else {
                return redirect('/e-ysiid/register?error=2');
            }

        } else {
            echo "reCAPTCHA verification failed!";
        }

    }

    function authRegisterTwo(Request $request)
    {
        $sehirler = ["Adana", "Adıyaman", "Afyon", "Ağrı", "Amasya", "Ankara", "Antalya", "Artvin", "Aydın", "Balıkesir", "Bilecik", "Bingöl", "Bitlis", "Bolu", "Burdur", "Bursa", "Çanakkale", "Çankırı", "Çorum", "Denizli", "Diyarbakır", "Edirne", "Elazığ", "Erzincan", "Erzurum", "Eskişehir", "Gaziantep", "Giresun", "Gümüşhane", "Hakkari", "Hatay", "Isparta", "İçel (Mersin)", "İstanbul", "İzmir", "Kars", "Kastamonu", "Kayseri", "Kırklareli", "Kırşehir", "Kocaeli", "Konya", "Kütahya", "Malatya", "Manisa", "Kahramanmaraş", "Mardin", "Muğla", "Muş", "Nevşehir", "Niğde", "Ordu", "Rize", "Sakarya", "Samsun", "Siirt", "Sinop", "Sivas", "Tekirdağ", "Tokat", "Trabzon", "Tunceli", "Şanlıurfa", "Uşak", "Van", "Yozgat", "Zonguldak", "Aksaray", "Bayburt", "Karaman", "Kırıkkale", "Batman", "Şırnak", "Bartın", "Ardahan", "Iğdır", "Yalova", "Karabük", "Kilis", "Osmaniye", "Düzce"];
        $uye = DB::select('select * from uye where id = ? limit 1', [session('uye_id')])[0];
        $settings = DB::select('select * from settings limit 1')[0];
        return view('pages.eysiid.memberRegisterTwo', compact('settings', 'uye', 'sehirler'));
    }

    function listFiles(Request $request)
    {
        try {
            $upload_folder = "uploads/sra/" . md5(session('uye_id') . 'MB') . "/";
            $file_list = array();
            $files = scandir($upload_folder);
            foreach ($files as $file) {
                if (!in_array($file, array(".", "..", "docs", "receipt"))) {
                    $size = filesize($upload_folder . $file);
                    $name = basename($file);
                    $file_path = $upload_folder . $file;

                    $file_list[] = ['name' => $name, 'size' => $size, 'path' => '/' . $file_path];
                }
            }
            return response()->json($file_list);
        } catch (\Throwable $th) {
            return response()->json([]);
        }
    }

    function addFile(Request $request)
    {
        $upload_folder = "uploads/sra/" . md5(session('uye_id') . 'MB');
        $target_dir = $upload_folder . "/";

        if (!Storage::exists($upload_folder)) {
            Storage::makeDirectory($upload_folder);
        }


        $file = $request->file('file');
        $extension = strtolower($file->getClientOriginalExtension());
        $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'pdf', 'doc', 'docx', 'xls', 'xlsx'];

        if (in_array($extension, $allowed_extensions)) {
            $target_file = $target_dir . $file->getClientOriginalName();

            if ($file->move($target_dir, $file->getClientOriginalName())) {
                return response()->json(['file_path' => $target_file]);
            } else {
                return response()->json(['error' => 'An error occurred while uploading file.']);
            }
        } else {
            return response()->json(['error' => 'Only jpg, jpeg, png, gif, bmp, pdf, doc, docx, xls and xlsx files are allowed.']);
        }

    }

    function authImageDelete(Request $request)
    {
        $id = $request->input('id');
        $userid = session('uye_id');
        if (file_exists('uploads/sra/' . md5($userid . 'MB') . '/' . $id)) {
            unlink('uploads/sra/' . md5($userid . 'MB') . '/' . $id);
            return response()->json(array('status' => 'success'));
        } else {
            return response()->json(array('status' => 'error'));
        }
    }

    function saveMyForm(Request $request)
    {




        $id = (!empty($request->input('uye_id'))) ? $request->input('uye_id') : session('uye_id');
        $model = memberModel::find($id);
        $corporate_name = $request->input('corporate_name');
        $isLegal = $request->input('isLegal');
        $ciro = $request->input('ciro');
        $personel_sayisi = $request->input('personel_sayisi');
        $website = $request->input('website');
        $faks = $request->input('faks');
        $sehir = $request->input('sehir');
        $adres = $request->input('adres');
        $name = $request->input('name');
        $surname = $request->input('surname');
        $tck = $request->input('tck');
        $d_tarih = $request->input('d_tarih');
        $phone = $request->input('phone');
        $corporate_role = $request->input('corporate_role');
        $asistanNameSurname = $request->input('asistanNameSurname');
        $asistanMail = $request->input('asistanMail');
        $asistanTel = $request->input('asistanTel');
        $email = $request->input('email');
        $sirketTel = $request->input('sirketTel');

        $upload_folder = "/home/ysiidorg/public_html/public/uploads/sra/" . md5(session('uye_id') . 'MB');
        $target_dir = $upload_folder . "/";



        if (!file_exists($upload_folder)) {
            mkdir($upload_folder, 0777, true);
        }

        if (!file_exists($upload_folder . '/docs')) {
            mkdir($upload_folder . '/docs', 0777, true);
        }




        if ($request->hasFile('logo') && $request->hasFile('kimfoto')) {
            $file1 = $request->file('logo');
            $file2 = $request->file('kimfoto');
            $extension1 = strtolower($file1->getClientOriginalExtension());
            $extension2 = strtolower($file2->getClientOriginalExtension());
            $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'pdf', 'doc', 'docx', 'xls', 'xlsx'];
            if (in_array($extension1, $allowed_extensions) && in_array($extension2, $allowed_extensions)) {
                $target_file1 = $upload_folder . '/docs/' . $file1->getClientOriginalName();
                $target_file2 = $upload_folder . '/docs/' . $file2->getClientOriginalName();
                if ($file1->move($upload_folder . '/docs/', $file1->getClientOriginalName()) && $file2->move($upload_folder . '/docs/', $file2->getClientOriginalName())) {

                } else {

                }
            }
            $model->logo = $file1->getClientOriginalName();
            $model->kimfoto = $file2->getClientOriginalName();
        }

        $model->email = $email;
        $model->corporate_name = $corporate_name;
        $model->isLegal = $isLegal;
        $model->name = $name;
        $model->surname = $surname;
        $model->phone = $phone;
        $model->corporate_role = $corporate_role;
        $model->tck = $tck;
        $model->d_tarih = $d_tarih;
        $model->adres = $adres;
        $model->sehir = $sehir;
        $model->asistanNameSurname = $asistanNameSurname;
        $model->asistanMail = $asistanMail;
        $model->asistanTel = $asistanTel;
        $model->website = $website;
        $model->faks = $faks;
        $model->ciro_miktari = $ciro;
        $model->personel_sayisi = $personel_sayisi;
        $model->sirketTel = $sirketTel;
        $model->isDocumentControl = 1;
        if ($request->formUpdate == '1') {
            $model->approved = '1';
        } else {
            $model->approved = '0';
        }

        if ($model->save()) {

            DB::delete('delete from check_list where uye_id = ?', [$id]);
            DB::insert('insert into check_list (uye_id,updated_at) values (?,?)', [$id, date('Y-m-d H:i:s')]);

            $log = new Log();
            $log->user = $id;
            $log->islem = 'Onaylanmış bilgiler tekrar Güncellendi';
            $log->ip = $request->ip();
            $log->save();
            return response()->json(array('status' => 'success'));
        }




    }
    function HomeController(Request $request)
    {
        $id = session('uye_id');
        $model = memberModel::find($id);
        $model->isDocumentControl = 1;
        $model->save();
        return redirect()->route('home');
    }

    function receiptupload(Request $request)
    {
        $id = session('uye_id');
        $model = memberModel::find($id);

        $log = new Log();
        $log->user = $id;
        $log->islem = 'Ödeme Bildirimi Yapıldı';
        $log->ip = $request->ip();
        $log->save();

        $upload_folder = "uploads/sra/" . md5(session('uye_id') . 'MB');



        $target_dir = $upload_folder . "/";

        if (!file_exists($upload_folder)) {
            mkdir($upload_folder, 0777, true);
        }
        if (!file_exists($upload_folder . '/receipt')) {
            mkdir($upload_folder . '/receipt', 0777, true);
        }


        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $extension = strtolower($file->getClientOriginalExtension());
            $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'pdf'];
            if (in_array($extension, $allowed_extensions)) {
                $unique_name = uniqid() . '.' . $extension; // Benzersiz dosya adı oluşturuldu
                $target_file = $upload_folder . '/receipt/' . $unique_name;
                $path = $request->file('file')->storeAs($upload_folder . '/receipt/', $unique_name, 'public'); // Dosya adı değiştirildi
                if ($file->move($upload_folder . '/receipt/', $unique_name)) {
                  
                    DB::insert('insert into check_list (uye_id,updated_at) values (?,?)', [$id, date('Y-m-d H:i:s')]);
                    return response()->json(array('status' => 'success'));
                } else {
                    return response()->json(array('status' => 'error'));
                }
            }
        }



    }



    function uyebilgilerim()
    {
        $id = session('uye_id');
        $uye = memberModel::find($id);
        $settings = DB::select('select * from settings limit 1')[0];
        $sehirler = ["Adana", "Adıyaman", "Afyon", "Ağrı", "Amasya", "Ankara", "Antalya", "Artvin", "Aydın", "Balıkesir", "Bilecik", "Bingöl", "Bitlis", "Bolu", "Burdur", "Bursa", "Çanakkale", "Çankırı", "Çorum", "Denizli", "Diyarbakır", "Edirne", "Elazığ", "Erzincan", "Erzurum", "Eskişehir", "Gaziantep", "Giresun", "Gümüşhane", "Hakkari", "Hatay", "Isparta", "İçel (Mersin)", "İstanbul", "İzmir", "Kars", "Kastamonu", "Kayseri", "Kırklareli", "Kırşehir", "Kocaeli", "Konya", "Kütahya", "Malatya", "Manisa", "Kahramanmaraş", "Mardin", "Muğla", "Muş", "Nevşehir", "Niğde", "Ordu", "Rize", "Sakarya", "Samsun", "Siirt", "Sinop", "Sivas", "Tekirdağ", "Tokat", "Trabzon", "Tunceli", "Şanlıurfa", "Uşak", "Van", "Yozgat", "Zonguldak", "Aksaray", "Bayburt", "Karaman", "Kırıkkale", "Batman", "Şırnak", "Bartın", "Ardahan", "Iğdır", "Yalova", "Karabük", "Kilis", "Osmaniye", "Düzce"];

        return view('pages.eysiid.uyebilgilerim', compact('uye', 'settings', 'sehirler'));

    }


    function getRelativePath($path)
    {
        $publicDir = '/public';
        $pos = strpos($path, $publicDir);

        if ($pos !== false) {
            return str_replace('_html', '', str_replace($publicDir, '', substr($path, $pos)));
        } else {
            return $path;
        }
    }
   function listFilesRecursively($directory)
{
    $allFiles = glob($directory . '*');

    if (empty($allFiles)) {
        return [];
    }

    $files = [];
    foreach ($allFiles as $file) {
        if (is_file($file)) {
            $fileType = mime_content_type($file);
            switch ($fileType) {
                case 'application/pdf':
                    $fileType = 'PDF Belgesi';
                    break;
                case 'application/msword':
                    $fileType = 'Word Belgesi';
                    break;
                case 'application/vnd.ms-excel':
                    $fileType = 'Excel Dosyası';
                    break;
                case 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet':
                    $fileType = 'Excel Dosyası';
                    break;
                case 'image/jpeg':
                case 'image/png':
                case 'image/gif':
                    $fileType = 'Resim';
                    break;
                case 'video/mp4':
                    $fileType = 'Video';
                    break;
                default:
                    $fileType = 'Bilinmeyen Dosya Türü';
            }

            $files[] = [
                'file_name' => basename($file),
                'file_type' => $fileType,
                'file_size' => filesize($file),
                'upload_date' => date("Y-m-d H:i:s", filemtime($file)),
                'relative_path' => $this->getRelativePath($file)
            ];
        } elseif (is_dir($file)) {
            // If the directory name contains "receipt", skip listing its contents
            if (strpos($file, 'receipt') === false) {
                $files = array_merge($files, $this->listFilesRecursively($file . '/'));
            }
        }
    }

    return $files;
}

    function yuklenendosyalar()
    {
        $id = session('uye_id');
        $uye = memberModel::find($id);
        $files = $this->listFilesRecursively('/home/ysiidorg/public_html/public/uploads/sra/' . md5(session('uye_id') . 'MB'));
        $settings = DB::select('select * from settings limit 1')[0];
        $sehirler = ["Adana", "Adıyaman", "Afyon", "Ağrı", "Amasya", "Ankara", "Antalya", "Artvin", "Aydın", "Balıkesir", "Bilecik", "Bingöl", "Bitlis", "Bolu", "Burdur", "Bursa", "Çanakkale", "Çankırı", "Çorum", "Denizli", "Diyarbakır", "Edirne", "Elazığ", "Erzincan", "Erzurum", "Eskişehir", "Gaziantep", "Giresun", "Gümüşhane", "Hakkari", "Hatay", "Isparta", "İçel (Mersin)", "İstanbul", "İzmir", "Kars", "Kastamonu", "Kayseri", "Kırklareli", "Kırşehir", "Kocaeli", "Konya", "Kütahya", "Malatya", "Manisa", "Kahramanmaraş", "Mardin", "Muğla", "Muş", "Nevşehir", "Niğde", "Ordu", "Rize", "Sakarya", "Samsun", "Siirt", "Sinop", "Sivas", "Tekirdağ", "Tokat", "Trabzon", "Tunceli", "Şanlıurfa", "Uşak", "Van", "Yozgat", "Zonguldak", "Aksaray", "Bayburt", "Karaman", "Kırıkkale", "Batman", "Şırnak", "Bartın", "Ardahan", "Iğdır", "Yalova", "Karabük", "Kilis", "Osmaniye", "Düzce"];
        return view('pages.eysiid.uploadedFiles', compact('uye', 'settings', 'files'));
    }

    function odemeler(){
        $id = session('uye_id');
        $uye = memberModel::find($id);
        $settings = DB::select('select * from settings limit 1')[0];
        $odemeler = DB::select('select * from pay_detail where uyeid = ?', [$id]);
        return view('pages.eysiid.payments', compact('uye', 'settings', 'odemeler'));
    }

    function dekontyukle(Request $request){
        $id = session('uye_id');
        $model = memberModel::find($id);

        $log = new Log();
        $log->user = $id;
        $log->islem = 'Aidat Dekontu Yükleme';
        $log->ip = $request->ip();
        $log->save();

        $upload_folder = "uploads/sra/" . md5(session('uye_id') . 'MB');



        $target_dir = $upload_folder . "/";

        if (!file_exists($upload_folder)) {
            mkdir($upload_folder, 0777, true);
        }
        if (!file_exists($upload_folder . '/receipt')) {
            mkdir($upload_folder . '/receipt', 0777, true);
        }


        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $extension = strtolower($file->getClientOriginalExtension());
            $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'pdf'];
            if (in_array($extension, $allowed_extensions)) {
                $unique_name = uniqid() . '.' . $extension; // Benzersiz dosya adı oluşturuldu
                $target_file = $upload_folder . '/receipt/' . $unique_name;
                $path = $request->file('file')->storeAs($upload_folder . '/receipt/', $unique_name, 'public'); // Dosya adı değiştirildi
                if ($file->move($upload_folder . '/receipt/', $unique_name)) {
                    DB::insert('insert into check_list (uye_id,updated_at) values (?,?)', [$id, date('Y-m-d H:i:s')]);
                    DB::update('update pay_detail set pay="2",file_path=? where id = ?', [$target_file , $request->id]);
                    return response()->json(array('status' => 'success'));
                } else {
                    return response()->json(array('status' => 'error'));
                }
            }
        }
    }

    public function cronpay(){
       
       $uyeler = DB::select('select * from uye');

        foreach($uyeler as $uye){
            DB::insert('insert into pay_detail (uyeid,amount,start_date,pay,dateTime) values (?,?,?,?,?)', 
            [$uye->id,$uye->aidat,date('Y-m-d'),'0',date('Y-m-d H:i:s')]);
        }





    }

    public function sifredegistir(){
          $id = session('uye_id');
        $uye = memberModel::find($id);
        $settings = DB::select('select * from settings limit 1')[0];
        $odemeler = DB::select('select * from pay_detail where uyeid = ?', [$id]);
        
        return view('pages.eysiid.sifredegistir', compact('uye', 'settings', 'odemeler'));
         
    }

    public function sifredegistirislemi(Request $request){
        $id = session('uye_id');
        if($request->password == $request->password_re){
            DB::update("update uye set password='".md5($request->password)."' where id = ".$id);
             $log = new Log();
        $log->user = $id;
        $log->islem = 'Şifresini Değiştirdi';
        $log->ip = $request->ip();
        $log->save();


            return redirect()->route('sifredegistir', ['succ' => 'Şifreniz başarıyla değiştirildi'])->with('success', 'Şifreniz başarıyla değiştirildi.');
        }else{
            return redirect()->route('sifredegistir', ['err' => 'Girmiş olduğunuz şifreler uyuşmuyor.'])->with('error', 'Şifreleriniz uyuşmuyor.');
        }
        
    }

    public function logout(){
        session()->flush();
        return redirect()->route('eysiid');
    }

    public function iletisim(){
        return view('pages.iletisim');
    }

    public function duyuruListe(){
        $duyurular = DB::select('select * from duyuru order by id desc');
        return view('pages.duyuruListe', compact('duyurular'));
    }

    public function onemliBilgilendirmeler(){
        $page = DB::select('select * from pages where page_title_seo = "onemli-bilgilendirmeler"');

        return view('pages.onemliBilgilendirme', compact('page'));
      
    }

    public function iletisimSave(Request $request){
        $name    = $request->name;
        $email   = $request->email;
        $message = $request->message;
        $phone   = $request->phone;
        $subject = $request->subject;

        $save = DB::insert('insert into contact (name,email,phone,message,subject,createdAt) values (?,?,?,?,?,?)', [$name,$email,$phone,$message,$subject,date('Y-m-d H:i:s')]);
        if($save){
                 $html = '<div class="alert alert-success">Mesajınız başarıyla gönderildi.</div>';
             
        }else{
               $html = '<div class="alert alert-danger">Mesajınız gönderilemedi.</div>';
        }
        print_r($html);
    }
 
}