<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\DataTables;
use App\Models\Bayi;




class BayiController extends Controller
{


    function get_bolge(){
        $bolge = json_encode(DB::select('select * from Bolgeler'));
        print_r($bolge);
    }
    function get_bolge_il(Request $request){
        $bolge  =  $request->bolgeID;
        $il = DB::select('select DISTINCT(Sehirler.SehirAd),Sehirler.Id from bayi LEFT JOIN Sehirler on Sehirler.Id = bayi.il where Sehirler.BolgeId = ? and bayi.page_status = "on"', [$bolge]);
        print_r(json_encode($il));

    }
    function filter(Request $request) {

        


        if($request->ilID != -1){
            print_r(json_encode(DB::select('select bayi.*, Sehirler.SehirAd from bayi left join Sehirler on Sehirler.Id = bayi.il where page_status ="on" and bayi.il = ?', [$request->ilID])));
        }else{
            print_r(json_encode(DB::select('select bayi.*, Sehirler.SehirAd from bayi left join Sehirler on Sehirler.Id = bayi.il where page_status = "on" order by bayi.il asc')));
        }
    }
 







    // --------------------------- Admin -------------------------
    public function list(){
        $sehir = json_encode(DB::select('select * from Sehirler'));
        return view('admin.pages.bayiListe', compact('sehir'));
    }
    public function ajaxList(){
        $query =  DB::Select("SELECT bayi.*,Sehirler.SehirAd as il, Bolgeler.BolgeAd as bolge, bayi.id as islem FROM `bayi` left join Sehirler on Sehirler.Id = bayi.il left join Bolgeler on Bolgeler.Id = Sehirler.BolgeId");
        return DataTables::of($query)->toJson();
    }
    public function ajaxsave(Request $request){
        $response = new \stdClass();
        $id = $request->update_id;
        $bayi = new Bayi;
        if(!empty($id)) $bayi = $bayi::find($id);
        $bayi->bayi_adi = $request->bayi_adi;
        $bayi->telefon = $request->telefon;
        $bayi->telefon_2 = $request->telefon_2;
        $bayi->faks = $request->faks;
        $bayi->email = $request->email;
        $bayi->site = $request->site;
        $bayi->yetkili_adi = $request->yetkili_adi;
        $bayi->adres = $request->adres;
        $bayi->il = $request->il;
        $response->status = ($bayi->save()) ? true : false;
        echo json_encode($response);
    }

    public function getSingle(Request $request){
        $id = $request->id;
        $bayi = Bayi::where('id', '=' , $id)->get();
        echo json_encode($bayi);
    }
    public function ajaxDelete(Request $request){
        $response = new \stdClass();
        $id = $request->id;
        $Bayi = Bayi::find($id);
        $response->status = ($Bayi->delete()) ? true : false;
        echo json_encode($response);
    }
    public function statusChanger(Request $request){
        $id = $request->id;
        $bayiCheck = Bayi::where('id', '=' , $id)->get();
        $response = new \stdClass();
   
      
        $bayi = Bayi::find($id);
     
        if($bayiCheck[0]->page_status != 'on'){
            $bayi->page_status = 'on';
        }else{
            $bayi->page_status = 'off';
        }
        $response->status = ($bayi->save()) ? true : false;
        echo json_encode($response);
    }
    

}
